/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.formats;

public class RGB {
    private int r;
    private int g;
    private int b;

    public RGB() {
    }

    public RGB(int iRgb) {
        this(iRgb >> 16 & 0xFF, iRgb >> 8 & 0xFF, iRgb & 0xFF);
    }

    public RGB(int iR, int iG, int iB) {
        this.r = iR;
        this.g = iG;
        this.b = iB;
    }

    public void setR(double dblRed) {
        this.r = (int)Math.round(dblRed);
    }

    public void setG(double dblGreen) {
        this.g = (int)Math.round(dblGreen);
    }

    public void setB(double dblBlue) {
        this.b = (int)Math.round(dblBlue);
    }

    public void setR(int iRed) {
        this.r = iRed;
    }

    public void setG(int iGreen) {
        this.g = iGreen;
    }

    public void setB(int iBlue) {
        this.b = iBlue;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public int toInt() {
        int clampg;
        int clampr;
        int n = this.r < 0 ? 0 : (clampr = this.r > 255 ? 0xFF0000 : this.r << 16);
        int n2 = this.g < 0 ? 0 : (clampg = this.g > 255 ? 65280 : this.g << 8);
        int clampb = this.b < 0 ? 0 : (this.b > 255 ? 255 : this.b);
        return 0xFF000000 | clampr | clampg | clampb;
    }

    public String toString() {
        return String.format("(%d, %d, %d)", this.r, this.g, this.b);
    }

    public void set(int iRgb) {
        this.r = iRgb >> 16 & 0xFF;
        this.g = iRgb >> 8 & 0xFF;
        this.b = iRgb & 0xFF;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGB other = (RGB)obj;
        return this.r == other.r && this.g == other.g && this.b == other.b;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.r;
        hash = 53 * hash + this.g;
        hash = 53 * hash + this.b;
        return hash;
    }
}

