/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.formats;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;

public enum JavaImageFormat {
    PNG("png", "png", "png", true, true),
    BMP("bmp", "bmp", "bmp", true, false),
    GIF("gif", "gif", "gif", false, false),
    TIFF("tiff", "tif", "tif", true, false);

    @Nonnull
    private final String _sUiId;
    @Nonnull
    private final String _sImageIOid;
    @Nonnull
    private final String _sExtension;
    private final boolean _blnTrueColor;
    private final boolean _blnAlpha;
    private final boolean _blnAvailable;

    private JavaImageFormat(@Nonnull String sUiId, String sImageIOid, String sExtension, boolean blnTrueColor, boolean blnAlpha) {
        this._sUiId = sUiId;
        this._sImageIOid = sImageIOid;
        this._sExtension = sExtension;
        this._blnTrueColor = blnTrueColor;
        this._blnAlpha = blnAlpha;
        String[] asValues = ImageIO.getWriterFormatNames();
        boolean blnAvailable = false;
        for (String s : asValues) {
            if (!s.equalsIgnoreCase(this._sImageIOid)) continue;
            blnAvailable = true;
            break;
        }
        this._blnAvailable = blnAvailable;
    }

    @Nonnull
    public String getUiId() {
        return this._sUiId;
    }

    @Nonnull
    public String getImageIOid() {
        return this._sImageIOid;
    }

    @Nonnull
    public String getExtension() {
        return this._sExtension;
    }

    public boolean hasTrueColor() {
        return this._blnTrueColor;
    }

    public boolean isAvailable() {
        return this._blnAvailable;
    }

    public boolean hasAlpha() {
        return this._blnAlpha;
    }

    public String toString() {
        return this._sUiId;
    }

    @Nonnull
    public static List<JavaImageFormat> getAvailable() {
        JavaImageFormat[] aeFormats = JavaImageFormat.values();
        ArrayList<JavaImageFormat> available = new ArrayList<JavaImageFormat>(aeFormats.length);
        for (JavaImageFormat fmt : aeFormats) {
            if (!fmt.isAvailable()) continue;
            available.add(fmt);
        }
        return available;
    }
}

