/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.formats;

import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.UnlocalizedMessage;

public class JavaAudioFormat {
    @Nonnull
    private final AudioFileFormat.Type _audioType;
    @Nonnull
    private final String _sExtension;
    @Nonnull
    private final UnlocalizedMessage _localizedCmdId;
    @Nonnull
    private final UnlocalizedMessage _localizedGuiDotExtension;
    private final boolean _blnIsAvailable;
    private static final JavaAudioFormat WAVE = new JavaAudioFormat(AudioFileFormat.Type.WAVE);
    private static final JavaAudioFormat AIFF = new JavaAudioFormat(AudioFileFormat.Type.AIFF);
    private static final JavaAudioFormat AU = new JavaAudioFormat(AudioFileFormat.Type.AU);
    private static final JavaAudioFormat AIFC = new JavaAudioFormat(AudioFileFormat.Type.AIFC);
    private static final JavaAudioFormat SND = new JavaAudioFormat(AudioFileFormat.Type.SND);
    @CheckForNull
    private static JavaAudioFormat[] AUDIO_FORMATS;

    private JavaAudioFormat(@Nonnull AudioFileFormat.Type audioType) {
        this._audioType = audioType;
        this._sExtension = audioType.getExtension();
        this._localizedCmdId = new UnlocalizedMessage(this._sExtension);
        this._localizedGuiDotExtension = new UnlocalizedMessage("." + this._sExtension);
        this._blnIsAvailable = AudioSystem.isFileTypeSupported(audioType);
    }

    private boolean isAvailable() {
        return this._blnIsAvailable;
    }

    @Nonnull
    public AudioFileFormat.Type getJavaType() {
        return this._audioType;
    }

    @Nonnull
    public String getExtension() {
        return this._sExtension;
    }

    @Nonnull
    public ILocalizedMessage getCmdId() {
        return this._localizedCmdId;
    }

    public String toString() {
        return this._localizedGuiDotExtension.toString();
    }

    @Nonnull
    public static JavaAudioFormat getDefaultAudioFormat() {
        return JavaAudioFormat.getAudioFormats()[0];
    }

    @Nonnull
    public static JavaAudioFormat[] getAudioFormats() {
        if (AUDIO_FORMATS != null) {
            return AUDIO_FORMATS;
        }
        ArrayList<JavaAudioFormat> javaAudFmts = new ArrayList<JavaAudioFormat>();
        if (WAVE.isAvailable()) {
            javaAudFmts.add(WAVE);
        }
        if (AIFF.isAvailable()) {
            javaAudFmts.add(AIFF);
        }
        if (AU.isAvailable()) {
            javaAudFmts.add(AU);
        }
        if (AIFC.isAvailable()) {
            javaAudFmts.add(AIFC);
        }
        if (SND.isAvailable()) {
            javaAudFmts.add(SND);
        }
        if (javaAudFmts.isEmpty()) {
            throw new ExceptionInInitializerError("JVM unable to save any audio formats");
        }
        AUDIO_FORMATS = javaAudFmts.toArray(new JavaAudioFormat[javaAudFmts.size()]);
        return AUDIO_FORMATS;
    }

    @CheckForNull
    public static JavaAudioFormat fromCmdLine(@Nonnull String s) {
        for (JavaAudioFormat fmt : JavaAudioFormat.getAudioFormats()) {
            if (!fmt.getCmdId().equalsIgnoreCase(s)) continue;
            return fmt;
        }
        return null;
    }
}

