/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.discitems;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.util.Misc;

public class SerializedDiscItem {
    private static final String KEY_VALUE_DELIMITER = ":";
    private static final String FIELD_DELIMITER = "|";
    private static final String INDEX_KEY = "#";
    private static final String ID_KEY = "ID";
    private static final String TYPE_KEY = "Type";
    private static final String SECTOR_RANGE_KEY = "Sectors";
    private final LinkedHashMap<String, String> _fields = new LinkedHashMap();

    public SerializedDiscItem(@Nonnull String sType, int iIndex, @CheckForNull String sIndexId, int iSectorStart, int iSectorEnd) {
        if (iIndex >= 0) {
            this.addNumberNoKeyNameCheck(INDEX_KEY, iIndex);
        }
        if (sIndexId != null) {
            this.addStringNoKeyNameCheck(ID_KEY, sIndexId);
        }
        this.addStringNoKeyNameCheck(TYPE_KEY, sType);
        this.addRangeNoKeyNameCheck(SECTOR_RANGE_KEY, iSectorStart, iSectorEnd);
    }

    public SerializedDiscItem(@Nonnull String sSerialized) throws LocalizedDeserializationFail {
        String[] asFields;
        if (sSerialized.matches("^\\s*$")) {
            throw new LocalizedDeserializationFail(I.EMPTY_SERIALIZED_STRING());
        }
        for (String sField : asFields = sSerialized.split(Pattern.quote(FIELD_DELIMITER))) {
            String[] asParts = sField.split(KEY_VALUE_DELIMITER);
            if (asParts.length != 2) {
                throw new LocalizedDeserializationFail(I.SERIALIZATION_FIELD_IMPROPERLY_FORMATTED(sField));
            }
            String sKey = asParts[0];
            String sValue = asParts[1];
            this._fields.put(sKey, sValue);
        }
        if (!(this._fields.containsKey(INDEX_KEY) && this._fields.containsKey(ID_KEY) && this._fields.containsKey(TYPE_KEY) && this._fields.containsKey(SECTOR_RANGE_KEY))) {
            throw new LocalizedDeserializationFail(I.SERIALIZATION_MISSING_REQUIRED_FIELDS(sSerialized));
        }
    }

    @Nonnull
    public String serialize() {
        LinkedHashMap<String, String> fieldsCopy = new LinkedHashMap<String, String>(this._fields);
        StringBuilder sb = new StringBuilder();
        if (fieldsCopy.containsKey(INDEX_KEY)) {
            sb.append(INDEX_KEY);
            sb.append(KEY_VALUE_DELIMITER);
            sb.append((String)fieldsCopy.remove(INDEX_KEY));
            sb.append(FIELD_DELIMITER);
        }
        if (fieldsCopy.containsKey(ID_KEY)) {
            sb.append(ID_KEY);
            sb.append(KEY_VALUE_DELIMITER);
            sb.append((String)fieldsCopy.remove(ID_KEY));
            sb.append(FIELD_DELIMITER);
        }
        sb.append(SECTOR_RANGE_KEY);
        sb.append(KEY_VALUE_DELIMITER);
        sb.append((String)fieldsCopy.remove(SECTOR_RANGE_KEY));
        sb.append(FIELD_DELIMITER);
        sb.append(TYPE_KEY);
        sb.append(KEY_VALUE_DELIMITER);
        sb.append((String)fieldsCopy.remove(TYPE_KEY));
        for (Map.Entry<String, String> entry : fieldsCopy.entrySet()) {
            sb.append(FIELD_DELIMITER);
            sb.append(entry.getKey());
            sb.append(KEY_VALUE_DELIMITER);
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public final void addString(@Nonnull String sFieldName, @Nonnull String sValue) {
        this.checkValidKeyName(sFieldName);
        this.addStringNoKeyNameCheck(sFieldName, sValue);
    }

    private void addStringNoKeyNameCheck(@Nonnull String sFieldName, @Nonnull String sValue) {
        this.checkValidKey(sFieldName);
        SerializedDiscItem.checkValidValue(sValue);
        this._fields.put(sFieldName, sValue);
    }

    public final void addYesNo(@Nonnull String sFieldName, boolean blnYesNo) {
        this.checkValidKeyName(sFieldName);
        this.addStringNoKeyNameCheck(sFieldName, blnYesNo ? "Yes" : "No");
    }

    public final void addNumber(@Nonnull String sFieldName, long lngValue) {
        this.checkValidKeyName(sFieldName);
        this.addNumberNoKeyNameCheck(sFieldName, lngValue);
    }

    private void addNumberNoKeyNameCheck(@Nonnull String sFieldName, long lngValue) {
        this.checkValidKey(sFieldName);
        this._fields.put(sFieldName, String.format("%d", lngValue));
    }

    public final void addRange(@Nonnull String sFieldName, long lngStart, long lngEnd) {
        this.checkValidKeyName(sFieldName);
        this.addRangeNoKeyNameCheck(sFieldName, lngStart, lngEnd);
    }

    public void addRangeNoKeyNameCheck(@Nonnull String sFieldName, long lngStart, long lngEnd) {
        if (lngStart < 0L || lngEnd < 0L) {
            throw new IllegalArgumentException("Range values must be >= 0");
        }
        this.checkValidKey(sFieldName);
        this._fields.put(sFieldName, String.format("%d-%d", lngStart, lngEnd));
    }

    public void addFraction(@Nonnull String sFieldName, long lngNumerator, long lngDenominator) {
        if (lngNumerator < 0L || lngDenominator < 0L) {
            throw new IllegalArgumentException("Fraction values must be >= 0");
        }
        this.checkValidKey(sFieldName);
        this.checkValidKeyName(sFieldName);
        this._fields.put(sFieldName, String.format("%d/%d", lngNumerator, lngDenominator));
    }

    public void addDimensions(@Nonnull String sFieldName, int iWidth, int iHeight) {
        if (iWidth < 0 || iHeight < 0) {
            throw new IllegalArgumentException("Range values must be >= 0");
        }
        this.checkValidKey(sFieldName);
        this.checkValidKeyName(sFieldName);
        this._fields.put(sFieldName, String.format("%dx%d", iWidth, iHeight));
    }

    private static void checkValidValue(String sValue) {
        if (sValue.matches(".*[:\\|].*")) {
            throw new IllegalArgumentException("Keys and Values cannot contain ':' or '|'");
        }
    }

    private void checkValidKeyName(String sKey) {
        if (INDEX_KEY.equals(sKey) || ID_KEY.equals(sKey) || TYPE_KEY.equals(sKey) || SECTOR_RANGE_KEY.equals(sKey)) {
            throw new IllegalArgumentException("Key cannot be one of the default required ones " + sKey);
        }
    }

    private void checkValidKey(String sKey) {
        if (sKey.length() == 0) {
            throw new IllegalArgumentException("Empty key or value?");
        }
        if (sKey.matches(".*[:\\|].*")) {
            throw new IllegalArgumentException("Keys and Values cannot contain ':' or '|'");
        }
        if (this._fields.containsKey(sKey)) {
            throw new IllegalArgumentException("Key already exists " + sKey);
        }
    }

    public boolean hasField(@Nonnull String sFieldName) {
        return this._fields.containsKey(sFieldName);
    }

    @Nonnull
    public String getString(@Nonnull String sFieldName) throws LocalizedDeserializationFail {
        String sValue = this._fields.get(sFieldName);
        if (sValue == null) {
            throw new LocalizedDeserializationFail(I.SERIALIZATION_FIELD_NOT_FOUND(sFieldName));
        }
        return sValue;
    }

    @Nonnull
    public boolean getYesNo(@Nonnull String sFieldName) throws LocalizedDeserializationFail {
        String sValue = this.getString(sFieldName);
        if ("No".equalsIgnoreCase(sValue)) {
            return false;
        }
        if ("Yes".equalsIgnoreCase(sValue)) {
            return true;
        }
        throw new LocalizedDeserializationFail(I.FIELD_HAS_INVALID_VALUE_STR(sFieldName, sValue));
    }

    public long getLong(@Nonnull String sFieldName) throws LocalizedDeserializationFail {
        String sValue = this.getString(sFieldName);
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new LocalizedDeserializationFail(I.SERIALIZATION_FAILED_TO_CONVERT_TO_NUMBER(sValue));
        }
    }

    public int getInt(@Nonnull String sFieldName) throws LocalizedDeserializationFail {
        String sValue = this.getString(sFieldName);
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new LocalizedDeserializationFail(I.SERIALIZATION_FAILED_TO_CONVERT_TO_NUMBER(sValue));
        }
    }

    public int getInt(@Nonnull String sFieldName, int iDefault) throws LocalizedDeserializationFail {
        String sValue = this._fields.get(sFieldName);
        if (sValue == null) {
            return iDefault;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new LocalizedDeserializationFail(I.SERIALIZATION_FAILED_TO_CONVERT_TO_NUMBER(sValue));
        }
    }

    @Nonnull
    public int[] getIntRange(@Nonnull String sFieldName) throws LocalizedDeserializationFail {
        String sValue = this.getString(sFieldName);
        int[] ai = Misc.splitInt(sValue, "\\D+");
        if (ai == null || ai.length != 2) {
            throw new LocalizedDeserializationFail(I.SERIALIZATION_FAILED_TO_CONVERT_TO_RANGE(sValue));
        }
        return ai;
    }

    @Nonnull
    public long[] getLongRange(@Nonnull String sFieldName) throws LocalizedDeserializationFail {
        String sValue = this.getString(sFieldName);
        long[] alng = Misc.splitLong(sValue, "\\D+");
        if (alng == null || alng.length != 2) {
            throw new LocalizedDeserializationFail(I.SERIALIZATION_FAILED_TO_CONVERT_TO_RANGE(sValue));
        }
        return alng;
    }

    @Nonnull
    public int[] getDimensions(@Nonnull String sFieldName) throws LocalizedDeserializationFail {
        return this.getIntRange(sFieldName);
    }

    @Nonnull
    public long[] getFraction(@Nonnull String sFieldName) throws LocalizedDeserializationFail {
        return this.getLongRange(sFieldName);
    }

    @Nonnull
    public String getType() {
        return this._fields.get(TYPE_KEY);
    }

    @Nonnull
    public int[] getSectorRange() throws LocalizedDeserializationFail {
        return this.getIntRange(SECTOR_RANGE_KEY);
    }

    public int getIndex() throws LocalizedDeserializationFail {
        return this.getInt(INDEX_KEY);
    }

    @Nonnull
    public String getId() throws LocalizedDeserializationFail {
        return this.getString(ID_KEY);
    }

    public String toString() {
        return this._fields.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this._fields != null ? this._fields.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedDiscItem other = (SerializedDiscItem)obj;
        return Misc.objectEquals(this._fields, other._fields);
    }
}

