/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.discitems;

import com.jhlabs.awt.ParagraphLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import javax.annotation.Nonnull;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpsxdec.i18n.ILocalizedMessage;

public abstract class ParagraphPanel
extends JPanel {
    public ParagraphPanel() {
        super(new ParagraphLayout());
    }

    @Nonnull
    protected static JTextArea makeMultiLineJLabel(int iVisibleLineHeight) {
        JTextArea txtArea = new JTextArea(iVisibleLineHeight, 0);
        Font f = UIManager.getFont("TextField.font");
        txtArea.setFont(f);
        txtArea.setEditable(false);
        txtArea.setWrapStyleWord(true);
        txtArea.setLineWrap(true);
        txtArea.setOpaque(false);
        Color c = txtArea.getBackground();
        txtArea.setBackground(new Color(c.getRed(), c.getGreen(), c.getBlue(), 0));
        return txtArea;
    }

    protected abstract class AbstractComboExtension
    extends AbstractListModel
    implements ComboBoxModel,
    ChangeListener {
        @Nonnull
        protected Object __cur;
        @Nonnull
        protected final JLabel __label;
        @Nonnull
        protected final JLabel __name;
        @Nonnull
        protected final JComboBox __combo;

        public AbstractComboExtension(@Nonnull ILocalizedMessage label, String baseName) {
            this.__label = new JLabel(label.getLocalizedMessage());
            this.__name = new JLabel(baseName);
            this.__combo = new JComboBox(this);
            ParagraphPanel.this.add((Component)this.__label, ParagraphLayout.NEW_PARAGRAPH);
            ParagraphPanel.this.add(this.__name);
            ParagraphPanel.this.add(this.__combo);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.__cur != this.getSelectedItem()) {
                this.__cur = this.getSelectedItem();
                this.fireContentsChanged(this, 0, this.getSize());
            }
            this.__name.setText(this.getBaseName());
        }

        @Override
        public abstract int getSize();

        @Override
        public abstract Object getElementAt(int var1);

        @Override
        public abstract void setSelectedItem(Object var1);

        @Override
        public abstract Object getSelectedItem();

        public abstract String getBaseName();
    }

    protected abstract class AbstractCombo
    extends AbstractListModel
    implements ComboBoxModel,
    ChangeListener {
        @Nonnull
        protected Object __cur = new Object();
        @Nonnull
        protected final JLabel __label;
        @Nonnull
        protected final JComboBox __combo;

        public AbstractCombo(ILocalizedMessage label, boolean blnStretch) {
            this.__label = new JLabel(label.getLocalizedMessage());
            this.__combo = new JComboBox(this);
            ParagraphPanel.this.add((Component)this.__label, ParagraphLayout.NEW_PARAGRAPH);
            if (blnStretch) {
                ParagraphPanel.this.add((Component)this.__combo, ParagraphLayout.STRETCH_H);
            } else {
                ParagraphPanel.this.add(this.__combo);
            }
        }

        @Override
        public void stateChanged(@Nonnull ChangeEvent e) {
            Object o = this.getSelectedItem();
            if (!this.__cur.equals(o)) {
                this.__cur = o;
            }
            this.fireContentsChanged(this, 0, this.getSize());
            this.updateEnabled();
        }

        private void updateEnabled() {
            boolean bln = this.getEnabled();
            if (bln != this.__label.isEnabled()) {
                this.__label.setEnabled(bln);
            }
            if (bln != this.__combo.isEnabled()) {
                this.__combo.setEnabled(bln);
            }
        }

        @Override
        public abstract int getSize();

        @Override
        public abstract Object getElementAt(int var1);

        @Override
        public abstract void setSelectedItem(Object var1);

        @Override
        public abstract Object getSelectedItem();

        protected abstract boolean getEnabled();
    }

    protected abstract class AbstractCheck
    extends JToggleButton.ToggleButtonModel
    implements ChangeListener {
        protected final JCheckBox __chk = new JCheckBox();
        @Nonnull
        protected final JLabel __label;
        boolean __cur = this.isSelected();

        public AbstractCheck(ILocalizedMessage label) {
            this.__label = new JLabel(label.getLocalizedMessage());
            ParagraphPanel.this.add((Component)this.__label, ParagraphLayout.NEW_PARAGRAPH);
            ParagraphPanel.this.add(this.__chk);
            this.__chk.setModel(null);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.__chk.getModel() == null) {
                this.__chk.setModel(this);
            }
            if (this.isSelected() != this.__cur) {
                this.__cur = this.isSelected();
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
            }
            if (this.__chk.isEnabled() != this.isEnabled()) {
                this.fireStateChanged();
            }
            if (this.__label.isEnabled() != this.isEnabled()) {
                this.__label.setEnabled(this.isEnabled());
            }
            boolean v = this.isVisibile();
            this.__label.setVisible(v);
            this.__chk.setVisible(v);
        }

        @Override
        public abstract boolean isSelected();

        @Override
        public abstract void setSelected(boolean var1);

        @Override
        public abstract boolean isEnabled();

        public boolean isVisibile() {
            return true;
        }
    }
}

