/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.discitems;

import java.io.File;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.util.Misc;

public class IndexId {
    @CheckForNull
    private final File _sourceFile;
    @CheckForNull
    private final int[] _aiTreeIndexes;
    private static final String UNNAMED_INDEX = "?";
    private static final ILocalizedMessage UNNAMED_FILE_NAME = I.UNNAMED_DISC_ITEM();
    private static final File UNNAMED_FILE = new File(UNNAMED_FILE_NAME.getLocalizedMessage());

    public IndexId(int iIndex) {
        this._sourceFile = null;
        this._aiTreeIndexes = new int[]{iIndex};
    }

    public IndexId(@Nonnull File baseFile) {
        this._sourceFile = baseFile;
        this._aiTreeIndexes = null;
    }

    private IndexId(@CheckForNull File baseFile, @Nonnull int[] aiIndex) {
        this._sourceFile = baseFile;
        this._aiTreeIndexes = aiIndex;
    }

    public IndexId(@Nonnull String sSerialized) throws LocalizedDeserializationFail {
        String[] asParts = Misc.regex("([^\\[]+)(\\[[^\\]]+\\])?", sSerialized);
        if (asParts == null || asParts.length != 3) {
            throw new LocalizedDeserializationFail(I.ID_FORMAT_INVALID(sSerialized));
        }
        this._sourceFile = UNNAMED_INDEX.equals(asParts[1]) ? null : new File(asParts[1]);
        if (asParts[2] == null) {
            this._aiTreeIndexes = null;
        } else {
            this._aiTreeIndexes = Misc.splitInt(asParts[2].substring(1, asParts[2].length() - 1), "\\.");
            if (this._aiTreeIndexes == null) {
                throw new LocalizedDeserializationFail(I.ID_FORMAT_INVALID(sSerialized));
            }
        }
    }

    @Nonnull
    private File safePath() {
        return this._sourceFile == null ? UNNAMED_FILE : this._sourceFile;
    }

    @Nonnull
    public String serialize() {
        return (this._sourceFile == null ? UNNAMED_INDEX : Misc.forwardSlashPath(this._sourceFile)) + this.getTreeIndex();
    }

    @Nonnull
    public String getId() {
        return Misc.forwardSlashPath(this.safePath()) + this.getTreeIndex();
    }

    @CheckForNull
    public File getFile() {
        return this._sourceFile;
    }

    @Nonnull
    private String getTreeIndex() {
        if (this._aiTreeIndexes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i : this._aiTreeIndexes) {
            if (sb.length() > 1) {
                sb.append('.');
            }
            sb.append(i);
        }
        sb.append(']');
        return sb.toString();
    }

    @Nonnull
    public File getSuggestedBaseName(@Nonnull String sFallback) {
        String sFile = this._sourceFile == null ? sFallback : this._sourceFile.getPath();
        return new File(sFile + this.getTreeIndex());
    }

    @Nonnull
    public String getTopLevel() {
        return this.safePath().getName() + this.getTreeIndex();
    }

    public String toString() {
        return this.serialize();
    }

    public boolean isParent(@Nonnull IndexId parentId) {
        if (this.isRoot()) {
            return false;
        }
        File parentFile = parentId._sourceFile;
        if (!Misc.objectEquals(this._sourceFile, parentFile)) {
            return false;
        }
        int[] aiParentTreeIndexes = parentId._aiTreeIndexes;
        if (aiParentTreeIndexes == null) {
            if (this._aiTreeIndexes.length == 1) {
                return true;
            }
        } else if (this._aiTreeIndexes.length - 1 == aiParentTreeIndexes.length) {
            for (int i = 0; i < aiParentTreeIndexes.length; ++i) {
                if (this._aiTreeIndexes[i] == aiParentTreeIndexes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isRoot() {
        if (this._aiTreeIndexes == null) {
            return true;
        }
        return this._sourceFile == null && this._aiTreeIndexes.length == 1;
    }

    @Nonnull
    public IndexId createNext() {
        if (this._aiTreeIndexes == null) {
            throw new IllegalStateException("Unable to create the next id from " + this);
        }
        int[] aiNext = (int[])this._aiTreeIndexes.clone();
        int n = aiNext.length - 1;
        aiNext[n] = aiNext[n] + 1;
        return new IndexId(this._sourceFile, aiNext);
    }

    @Nonnull
    public IndexId createChild() {
        int[] aiChild;
        if (this._aiTreeIndexes == null) {
            aiChild = new int[]{0};
        } else {
            aiChild = new int[this._aiTreeIndexes.length + 1];
            System.arraycopy(this._aiTreeIndexes, 0, aiChild, 0, this._aiTreeIndexes.length);
            aiChild[aiChild.length - 1] = 0;
        }
        return new IndexId(this._sourceFile, aiChild);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexId other = (IndexId)obj;
        if (!Misc.objectEquals(this._sourceFile, other._sourceFile)) {
            return false;
        }
        return Arrays.equals(this._aiTreeIndexes, other._aiTreeIndexes);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this._sourceFile != null ? this._sourceFile.hashCode() : 0);
        return hash;
    }
}

