/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.discitems;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.util.ArgParser;
import jpsxdec.util.TaskCanceledException;

public abstract class DiscItemSaverBuilder {
    @CheckForNull
    private WeakHashMap<ChangeListener, Boolean> _changeListeners;
    @CheckForNull
    private ChangeEvent _event;
    private final List<File> _generatedFiles = new ArrayList<File>();

    public final void addChangeListener(@CheckForNull ChangeListener listener) {
        if (this._changeListeners == null) {
            this._changeListeners = new WeakHashMap();
        }
        this._changeListeners.put(listener, Boolean.TRUE);
    }

    public final void removeChangeListener(@CheckForNull ChangeListener listener) {
        if (this._changeListeners == null) {
            return;
        }
        this._changeListeners.remove(listener);
    }

    protected final void firePossibleChange() {
        if (this._changeListeners == null || this._changeListeners.isEmpty()) {
            return;
        }
        if (this._event == null) {
            this._event = new ChangeEvent(this);
        }
        for (ChangeListener listener : this._changeListeners.keySet()) {
            listener.stateChanged(this._event);
        }
    }

    protected final void clearGeneratedFiles() {
        this._generatedFiles.clear();
    }

    protected final void addGeneratedFile(@Nonnull File file) {
        this._generatedFiles.add(file);
    }

    @Nonnull
    public final List<File> getGeneratedFiles() {
        return this._generatedFiles;
    }

    @Nonnull
    public abstract DiscItem getDiscItem();

    @Nonnull
    public final String getInput() {
        return this.getDiscItem().getIndexId().serialize();
    }

    public abstract boolean copySettingsTo(@Nonnull DiscItemSaverBuilder var1);

    public abstract void printHelp(@Nonnull FeedbackStream var1);

    public abstract void commandLineOptions(@Nonnull ArgParser var1, @Nonnull FeedbackStream var2);

    public abstract void printSelectedOptions(@Nonnull ILocalizedLogger var1);

    @Nonnull
    public abstract ILocalizedMessage getOutputSummary();

    @Nonnull
    public abstract DiscItemSaverBuilderGui getOptionPane();

    public abstract void startSave(@Nonnull ProgressLogger var1, @CheckForNull File var2) throws LoggedFailure, TaskCanceledException;
}

