/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.discitems;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.IndexId;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.util.Misc;

public abstract class DiscItem
implements Comparable<DiscItem> {
    private static final Logger LOG = Logger.getLogger(DiscItem.class.getName());
    private final int _iStartSector;
    private final int _iEndSector;
    @Nonnull
    private final CdFileSectorReader _cdReader;
    private int _iIndex = -1;
    @CheckForNull
    private IndexId _indexId;

    protected DiscItem(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector) {
        if (iStartSector < 0 || iStartSector > iEndSector) {
            throw new IllegalArgumentException("Bad start/end sectors " + iStartSector + " - " + iEndSector);
        }
        if (iEndSector > cd.getSectorCount()) {
            LOG.log(Level.WARNING, "Disc item sectors {0,number,#}-{1,number,#} breaks CD end sector {2,number,#}", new Object[]{iStartSector, iEndSector, cd.getSectorCount()});
        }
        this._cdReader = cd;
        this._iStartSector = iStartSector;
        this._iEndSector = iEndSector;
    }

    protected DiscItem(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        this._cdReader = cd;
        int[] aiRng = fields.getSectorRange();
        this._iStartSector = aiRng[0];
        this._iEndSector = aiRng[1];
        this._iIndex = fields.getIndex();
        this._indexId = new IndexId(fields.getId());
    }

    @Nonnull
    public SerializedDiscItem serialize() {
        return new SerializedDiscItem(this.getSerializationTypeId(), this._iIndex, this._indexId == null ? null : this._indexId.serialize(), this._iStartSector, this._iEndSector);
    }

    @Nonnull
    public abstract String getSerializationTypeId();

    @Nonnull
    public CdFileSectorReader getSourceCd() {
        return this._cdReader;
    }

    public void setIndex(int iIndex) {
        this._iIndex = iIndex;
    }

    public int getIndex() {
        if (this._iIndex == -1) {
            throw new IllegalStateException("Index# should have been set before use.");
        }
        return this._iIndex;
    }

    public boolean setIndexId(@Nonnull IndexId id) {
        this._indexId = id;
        return true;
    }

    @Nonnull
    public final IndexId getIndexId() {
        if (this._indexId == null) {
            throw new IllegalStateException("IndexId should have been set before use.");
        }
        return this._indexId;
    }

    public int getParentRating(@Nonnull DiscItem child) {
        return 0;
    }

    public boolean addChild(@Nonnull DiscItem child) {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    @CheckForNull
    public Iterable<? extends DiscItem> getChildren() {
        return null;
    }

    public int getOverlap(@Nonnull DiscItem other) {
        DiscItem right;
        DiscItem left;
        if (this.getStartSector() <= other.getStartSector()) {
            left = this;
            right = other;
        } else {
            left = other;
            right = this;
        }
        if (left.getEndSector() < right.getStartSector()) {
            return 0;
        }
        if (left.getEndSector() < right.getEndSector()) {
            return left.getEndSector() - right.getStartSector() + 1;
        }
        return right.getSectorLength();
    }

    @Nonnull
    public SectorClaimSystem createClaimSystem() {
        return SectorClaimSystem.create(this.getSourceCd(), this.getStartSector(), this.getEndSector());
    }

    public int getStartSector() {
        return this._iStartSector;
    }

    public int getEndSector() {
        return this._iEndSector;
    }

    @Nonnull
    public SectorRange makeSectorRange() {
        return new SectorRange(this._iStartSector, this._iEndSector);
    }

    public int getSectorLength() {
        return this._iEndSector - this._iStartSector + 1;
    }

    public boolean notEntirelyInCd() {
        return this._iEndSector > this._cdReader.getSectorCount();
    }

    public String toString() {
        return this.serialize().serialize();
    }

    @Nonnull
    public abstract GeneralType getType();

    @Nonnull
    public abstract ILocalizedMessage getInterestingDescription();

    @Nonnull
    public abstract DiscItemSaverBuilder makeSaverBuilder();

    @Nonnull
    public File getSuggestedBaseName() {
        File suggestedBaseName = this._indexId == null ? new File(this._cdReader.getSourceFile().getName()) : this._indexId.getSuggestedBaseName(this._cdReader.getSourceFile().getName());
        return suggestedBaseName;
    }

    @Override
    public int compareTo(@Nonnull DiscItem other) {
        int iEndSectorDiff;
        if (this == other) {
            return 0;
        }
        int iStartSectorDiff = Misc.intCompare(this.getStartSector(), other.getStartSector());
        if (iStartSectorDiff != 0) {
            return iStartSectorDiff;
        }
        if (this instanceof IHasStartOffset && other instanceof IHasStartOffset) {
            IHasStartOffset thisWithOffset = (IHasStartOffset)((Object)this);
            IHasStartOffset otherWithOffset = (IHasStartOffset)((Object)other);
            int iOffsetDiff = Misc.intCompare(thisWithOffset.getStartOffset(), otherWithOffset.getStartOffset());
            if (iOffsetDiff != 0) {
                return iOffsetDiff;
            }
        }
        if ((iEndSectorDiff = Misc.intCompare(other.getEndSector(), this.getEndSector())) != 0) {
            return iEndSectorDiff;
        }
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Identical item position {0} == {1}", new Object[]{other, this});
        return Misc.intCompare(other.getClass().hashCode(), this.getClass().hashCode());
    }

    public boolean equals(@CheckForNull Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiscItem other = (DiscItem)obj;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public static interface IHasStartOffset {
        public int getStartOffset();
    }

    public static enum GeneralType {
        Audio(I.ITEM_TYPE_AUDIO(), I.ITEM_TYPE_AUDIO_APPLY()),
        Video(I.ITEM_TYPE_VIDEO(), I.ITEM_TYPE_VIDEO_APPLY()),
        Image(I.ITEM_TYPE_IMAGE(), I.ITEM_TYPE_IMAGE_APPLY()),
        File(I.ITEM_TYPE_FILE(), I.ITEM_TYPE_FILE_APPLY()),
        Sound(I.ITEM_TYPE_SOUND(), I.ITEM_TYPE_SOUND_APPLY());

        @Nonnull
        private final ILocalizedMessage _localizedName;
        @Nonnull
        private final ILocalizedMessage _localizedApplyToName;

        private GeneralType(ILocalizedMessage name, ILocalizedMessage applyToName) {
            this._localizedName = name;
            this._localizedApplyToName = applyToName;
        }

        @Nonnull
        public ILocalizedMessage getName() {
            return this._localizedName;
        }

        @Nonnull
        public ILocalizedMessage getApplyToName() {
            return this._localizedApplyToName;
        }
    }
}

