/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.discitems;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.util.ByteArrayFPIS;

public class DemuxedSectorInputStream
extends SequenceInputStream {
    private static final Logger LOG = Logger.getLogger(DemuxedSectorInputStream.class.getName());

    public DemuxedSectorInputStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iOffset) {
        super(new SectorEnumerator(cd, iStartSector, iOffset));
    }

    @Override
    public void close() {
    }

    private static class SectorEnumerator
    implements Enumeration<InputStream> {
        @Nonnull
        public final CdFileSectorReader _cd;
        private final int _iOffset;
        private final int _iStartSector;
        public int _iSector;
        @CheckForNull
        private ByteArrayFPIS _currentStream;

        public SectorEnumerator(@Nonnull CdFileSectorReader cd, int iSector, int iOffset) {
            this._cd = cd;
            this._iStartSector = this._iSector = iSector;
            this._iOffset = iOffset;
        }

        @Override
        public boolean hasMoreElements() {
            return this._iSector < this._cd.getSectorCount();
        }

        @Override
        @Nonnull
        public InputStream nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            try {
                CdSector sector = this._cd.getSector(this._iSector);
                if (sector.getCdUserDataSize() != 2048) {
                    LOG.log(Level.WARNING, "Demuxing non Mode1/Mode2Form1 sector {0}", sector);
                }
                this._currentStream = sector.getCdUserDataStream();
                if (this._iSector == this._iStartSector) {
                    this._currentStream.skip(this._iOffset);
                }
                ++this._iSector;
                return this._currentStream;
            }
            catch (CdFileSectorReader.CdReadException ex) {
                LOG.log(Level.SEVERE, null, ex);
                this._currentStream = null;
                return new InputStream(){

                    @Override
                    public int read() throws IOException {
                        throw ex;
                    }
                };
            }
        }
    }
}

