/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.discitems;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpsxdec.discitems.DiscItemSaverBuilder;

public class CombinedBuilderListener<T extends DiscItemSaverBuilder> {
    private final ArrayList<ChangeListener> _controlsListening = new ArrayList();
    @Nonnull
    private final Class<?> _cls;
    @Nonnull
    private T _saverBuilder;
    @Nonnull
    private final ChangeListener _thisChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(@Nonnull ChangeEvent e) {
            for (ChangeListener control : CombinedBuilderListener.this._controlsListening) {
                control.stateChanged(e);
            }
        }
    };

    public CombinedBuilderListener(@Nonnull T saverBuilder) {
        this._saverBuilder = saverBuilder;
        ((DiscItemSaverBuilder)this._saverBuilder).addChangeListener(this._thisChangeListener);
        this._cls = this._saverBuilder.getClass();
    }

    public void addListeners(ChangeListener ... aoControls) {
        this._controlsListening.addAll(Arrays.asList(aoControls));
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener control : aoControls) {
            control.stateChanged(e);
        }
    }

    public boolean changeSourceBuilder(@Nonnull DiscItemSaverBuilder saverBuilder) {
        if (this._cls.equals(saverBuilder.getClass())) {
            T oldBuilder = this._saverBuilder;
            this._saverBuilder = saverBuilder;
            ((DiscItemSaverBuilder)oldBuilder).removeChangeListener(this._thisChangeListener);
            ((DiscItemSaverBuilder)this._saverBuilder).addChangeListener(this._thisChangeListener);
            ChangeEvent e = new ChangeEvent(this);
            this._thisChangeListener.stateChanged(e);
            return true;
        }
        return false;
    }

    @Nonnull
    public T getBuilder() {
        return this._saverBuilder;
    }
}

