/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cmdline;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import jpsxdec.modules.IIdentifiedSector;

public class SectorCounter
implements Iterable<Map.Entry<String, Integer>> {
    private final TreeMap<String, Integer> _sectorCounts = new TreeMap();

    public void increment(IIdentifiedSector idSect) {
        if (idSect == null) {
            this.incrementName("UnidentifiedSector");
        } else {
            this.incrementName(idSect.getTypeName());
        }
    }

    private void incrementName(@Nonnull String sName) {
        Integer oiCount = this._sectorCounts.get(sName);
        if (oiCount == null) {
            this._sectorCounts.put(sName, 1);
        } else {
            this._sectorCounts.put(sName, oiCount + 1);
        }
    }

    public void put(@Nonnull String sName, int iCount) {
        this._sectorCounts.put(sName, iCount);
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<String, Integer>> iterator() {
        return this._sectorCounts.entrySet().iterator();
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this._sectorCounts != null ? this._sectorCounts.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SectorCounter other = (SectorCounter)obj;
        return this._sectorCounts == other._sectorCounts || this._sectorCounts != null && this._sectorCounts.equals(other._sectorCounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return sb.toString();
    }
}

