/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cmdline;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.DiscPatcher;
import jpsxdec.i18n.log.ConsoleProgressLogger;
import jpsxdec.util.TaskCanceledException;

public class SectorCopy {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new IllegalArgumentException("Need 3 args: <source file> <dest CD image> <dest sector start>");
        }
        SectorCopy.sectorCopy(args[0], args[1], Integer.parseInt(args[2]));
    }

    public static void sectorCopy(@Nonnull String sSource, @Nonnull String sDest, int iDestStartSector) throws CdFileSectorReader.CdFileNotFoundException, CdFileSectorReader.FileTooSmallToIdentifyException, CdFileSectorReader.CdReadException, CdFileSectorReader.CdWriteException, CdFileSectorReader.CdReopenException, DiscPatcher.CreatePatchFileException, DiscPatcher.WritePatchException, DiscPatcher.PatchReadException, IOException {
        CdFileSectorReader src = CdFileSectorReader.open(sSource);
        CdFileSectorReader dest = CdFileSectorReader.open(new File(sDest), true);
        if (src.getSectorCount() > dest.getSectorCount()) {
            throw new IllegalArgumentException("Source file is larger than dest file");
        }
        if (iDestStartSector + src.getSectorCount() > dest.getSectorCount()) {
            throw new IllegalArgumentException("Source file will run off the end of dest file");
        }
        dest.beginPatching();
        for (int iOfsSect = 0; iOfsSect < src.getSectorCount(); ++iOfsSect) {
            byte[] abSrcUserData = src.getSector(iOfsSect).getCdUserDataCopy();
            System.out.println("Overriting sector " + (iDestStartSector + iOfsSect));
            dest.addPatch(iDestStartSector + iOfsSect, 0, abSrcUserData);
        }
        System.out.println(src.getSectorCount() + " sectors overwritten.");
        src.close();
        try {
            dest.applyPatches(new ConsoleProgressLogger(SectorCopy.class.getSimpleName(), System.out));
        }
        catch (TaskCanceledException ex) {
            throw new RuntimeException(ex);
        }
        dest.close();
    }
}

