/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cmdline;

import com.pdfjet.Box;
import com.pdfjet.Font;
import com.pdfjet.PDF;
import com.pdfjet.Page;
import com.pdfjet.RGB;
import com.pdfjet.TextLine;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cmdline.Command;
import jpsxdec.cmdline.CommandLineException;
import jpsxdec.discitems.DiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.log.ShouldNotLog;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.util.ArgParser;
import jpsxdec.util.IO;

class Command_Visualize
extends Command {
    @Nonnull
    private String _sOutfile;
    private final HashMap<Class<?>, Color> colorLookup = new HashMap();

    public Command_Visualize() {
        super("-visualize");
    }

    @Override
    @CheckForNull
    protected ILocalizedMessage validate(@Nonnull String s) {
        this._sOutfile = s;
        return null;
    }

    @Override
    public void execute(@Nonnull ArgParser ap) throws CommandLineException {
        DiscIndex index = this.getIndex();
        CdFileSectorReader cd = index.getSourceCd();
        FileOutputStream pdfStream = null;
        try {
            int SECTOR_SECTION_SIZE = 32;
            int TEXT_LINE_HEIGHT = 16;
            int BOX_AREA_WIDTH = 16;
            int BOX_MARGIN_LEFT = 2;
            int BOX_MARGIN_RIGHT = 2;
            int BOX_WIDTH = 12;
            double MAX_PDF_SIZE = 14382.0;
            this._fbs.println(I.CMD_GENERATING_VISUALIZATION());
            int[] aiDataPoints = Command_Visualize.extractDataPoints(index);
            int iMaxOverlap = Command_Visualize.findMaxOverlap(aiDataPoints, index);
            int iWidth = 32 + iMaxOverlap * 16 + iMaxOverlap * 16;
            int iHeight = cd.getSectorCount() + 1;
            double SCALE = (double)iHeight < 14382.0 ? 1.0 : 14382.0 / (double)iHeight;
            pdfStream = new FileOutputStream(this._sOutfile);
            PDF pdf = new PDF(pdfStream);
            Font pdfFont = new Font(pdf, "Helvetica");
            pdfFont.setSize(6.0 * SCALE);
            Page pdfPage = new Page(pdf, new double[]{(double)iWidth * SCALE, (double)iHeight * SCALE});
            SectorClaimSystem it = SectorClaimSystem.create(cd);
            ShouldNotLog log = new ShouldNotLog();
            int iSector = 0;
            while (it.hasNext()) {
                try {
                    IIdentifiedSector idSector = it.next(log);
                    Color c = this.classToColor(idSector.getClass());
                    int[] aiRgb = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
                    Box pdfBox = new Box(0.0 * SCALE, (double)iSector * SCALE, 32.0 * SCALE, 1.0 * SCALE);
                    pdfBox.setFillShape(true);
                    pdfBox.setLineWidth(0.0);
                    pdfBox.setColor(aiRgb);
                    pdfBox.drawOn(pdfPage);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                ++iSector;
            }
            Object[] aoRunningItems = new DiscItem[iMaxOverlap];
            for (int iDataPoint : aiDataPoints) {
                for (DiscItem item : index) {
                    if (item.getStartSector() != iDataPoint) continue;
                    int i = Command_Visualize.findFree(aoRunningItems);
                    aoRunningItems[i] = item;
                    double x = (double)(32 + i * 16 + 2) * SCALE;
                    double y = (double)item.getStartSector() * SCALE;
                    double w = 12.0 * SCALE;
                    double h = (double)item.getSectorLength() * SCALE;
                    Box pdfBox = new Box(x, y, w, h);
                    Color c = this.classToColor(item.getClass());
                    int[] aiRgb = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
                    pdfBox.setColor(aiRgb);
                    pdfBox.setFillShape(true);
                    pdfBox.setLineWidth(0.0);
                    pdfBox.drawOn(pdfPage);
                    pdfBox.setFillShape(false);
                    pdfBox.setColor(RGB.WHITE);
                    pdfBox.setLineWidth(0.3 * SCALE);
                    pdfBox.drawOn(pdfPage);
                    TextLine pdfText = new TextLine(pdfFont, item.toString());
                    pdfText.setPosition(x, y);
                    pdfText.setColor(RGB.DARK_GRAY);
                    pdfText.drawOn(pdfPage);
                }
                for (int i = 0; i < aoRunningItems.length; ++i) {
                    if (aoRunningItems[i] == null || iDataPoint < ((DiscItem)aoRunningItems[i]).getEndSector()) continue;
                    aoRunningItems[i] = null;
                }
            }
            pdf.flush();
        }
        catch (Exception ex) {
            try {
                throw new CommandLineException(I.CMD_VISUALIZATION_ERR(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                IO.closeSilently(pdfStream, Logger.getLogger(Command_Visualize.class.getName()));
                throw throwable;
            }
        }
        IO.closeSilently(pdfStream, Logger.getLogger(Command_Visualize.class.getName()));
    }

    @Nonnull
    private Color classToColor(@Nonnull Class<?> c) {
        Color color = this.colorLookup.get(c.getClass());
        if (color == null) {
            int iClr = c.getName().hashCode();
            color = new Color(iClr);
            this.colorLookup.put(c, color);
        }
        return color;
    }

    private static int findFree(@Nonnull Object[] ao) {
        for (int i = 0; i < ao.length; ++i) {
            if (ao[i] != null) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    private static int[] extractDataPoints(@Nonnull DiscIndex index) {
        TreeSet<Integer> dataPoints = new TreeSet<Integer>();
        for (DiscItem item : index) {
            dataPoints.add(item.getStartSector());
            dataPoints.add(item.getEndSector());
        }
        int[] aiDataPoints = new int[dataPoints.size()];
        int i = 0;
        for (Integer point : dataPoints) {
            aiDataPoints[i] = point;
            ++i;
        }
        return aiDataPoints;
    }

    private static int findMaxOverlap(@Nonnull int[] aiDataPoints, @Nonnull DiscIndex index) {
        int iMaxOverlap = 0;
        for (int iSector : aiDataPoints) {
            int iSectorOverlap = 0;
            for (DiscItem item : index) {
                if (iSector < item.getStartSector() || iSector > item.getEndSector()) continue;
                ++iSectorOverlap;
            }
            if (iSectorOverlap <= iMaxOverlap) continue;
            iMaxOverlap = iSectorOverlap;
        }
        return iMaxOverlap;
    }
}

