/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cmdline;

import argparser.BooleanHolder;
import argparser.StringHolder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import jpsxdec.cmdline.Command;
import jpsxdec.cmdline.CommandLineException;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.UserFriendlyLogger;
import jpsxdec.modules.video.save.AutowireVDP;
import jpsxdec.modules.video.save.MdecDecodeQuality;
import jpsxdec.modules.video.save.VDP;
import jpsxdec.modules.video.save.VideoFileNameFormatter;
import jpsxdec.modules.video.save.VideoFormat;
import jpsxdec.psxvideo.bitstreams.BitStreamDebugging;
import jpsxdec.psxvideo.mdec.ChromaUpsample;
import jpsxdec.psxvideo.mdec.MdecDecoder;
import jpsxdec.psxvideo.mdec.MdecDecoder_double;
import jpsxdec.psxvideo.mdec.MdecInputStreamReader;
import jpsxdec.tim.Tim;
import jpsxdec.util.ArgParser;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.Fraction;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

class Command_Static
extends Command {
    @Nonnull
    private StaticType _eStaticType;

    public Command_Static() {
        super("-static");
    }

    @Override
    @CheckForNull
    protected ILocalizedMessage validate(@Nonnull String s) {
        for (StaticType type : StaticType.values()) {
            if (!s.equalsIgnoreCase(type.name())) continue;
            this._eStaticType = type;
            return null;
        }
        return I.CMD_INVALID_VALUE_FOR_CMD(s, "-static");
    }

    @Override
    public void execute(@Nonnull ArgParser ap) throws CommandLineException {
        File inFile = this.getInFile();
        switch (this._eStaticType) {
            case bs: 
            case mdec: {
                byte[] abFileData;
                VideoFormat outputFormat;
                BooleanHolder debug = ap.addBoolOption("-debug");
                StringHolder dimentions = ap.addStringOption("-dim");
                StringHolder quality = ap.addStringOption("-quality", "-q");
                StringHolder outFormat = ap.addStringOption("-fmt");
                StringHolder upsample = ap.addStringOption("-up");
                ap.match();
                if (dimentions.value == null) {
                    throw new CommandLineException(I.CMD_DIM_OPTION_REQURIED());
                }
                int[] aiDim = Misc.splitInt(dimentions.value, "x");
                if (aiDim == null || aiDim.length != 2) {
                    throw new CommandLineException(I.CMD_INVALID_VALUE_FOR_CMD(dimentions.value, "-dim"));
                }
                int iWidth = aiDim[0];
                int iHeight = aiDim[1];
                ArrayList<VideoFormat> validOutputFormat = new ArrayList<VideoFormat>(Arrays.asList(VideoFormat.IMGSEQ_BITSTREAM, VideoFormat.IMGSEQ_JPG, VideoFormat.IMGSEQ_BMP, VideoFormat.IMGSEQ_PNG));
                if (this._eStaticType == StaticType.bs) {
                    validOutputFormat.add(VideoFormat.IMGSEQ_MDEC);
                }
                this._fbs.println(I.CMD_READING_STATIC_FILE(inFile));
                if (outFormat.value == null) {
                    outputFormat = VideoFormat.IMGSEQ_PNG;
                } else {
                    outputFormat = VideoFormat.fromCmdLine(outFormat.value);
                    if (!validOutputFormat.contains((Object)outputFormat)) {
                        throw new CommandLineException(I.CMD_INVALID_VALUE_FOR_CMD(outFormat.value, "-fmt"));
                    }
                }
                if (debug.value) {
                    BitStreamDebugging.DEBUG = true;
                    MdecDecoder.DEBUG = true;
                    boolean blnAssertsEnabled = false;
                    if (!$assertionsDisabled) {
                        blnAssertsEnabled = true;
                        if (!true) {
                            throw new AssertionError();
                        }
                    }
                    if (!blnAssertsEnabled) {
                        this._fbs.printlnWarn(I.CMD_ASSERT_DISABLED_NO_DEBUG());
                        this._fbs.printlnWarn(I.CMD_ASSERT_DISABLED_NO_DEBUG_USE_EA());
                    }
                }
                UserFriendlyLogger log = new UserFriendlyLogger("static", this._fbs.getUnderlyingStream());
                FileAndIssueListener fileAndIssueListener = new FileAndIssueListener(this._fbs);
                log.setListener(fileAndIssueListener);
                String sFileBaseName = Misc.removeExt(inFile.getName());
                AutowireVDP pipeline = this.setupPipeline(iWidth, iHeight, outputFormat, sFileBaseName, quality.value, upsample.value, log);
                pipeline.setFileListener(fileAndIssueListener);
                try {
                    abFileData = IO.readFile(inFile);
                }
                catch (FileNotFoundException ex) {
                    throw new CommandLineException(I.IO_OPENING_FILE_NOT_FOUND_NAME(inFile.toString()), (Throwable)ex);
                }
                catch (IOException ex) {
                    throw new CommandLineException(I.IO_READING_FILE_ERROR_NAME(inFile.toString()), (Throwable)ex);
                }
                Fraction dummyFrameNumber = new Fraction(-1);
                try {
                    if (this._eStaticType == StaticType.bs) {
                        pipeline.setMap(new VDP.Bitstream2Mdec());
                        pipeline.autowire();
                        pipeline.getBitstreamListener().bitstream(abFileData, abFileData.length, null, dummyFrameNumber);
                    } else {
                        pipeline.autowire();
                        pipeline.getMdecListener().mdec(new MdecInputStreamReader(abFileData), null, dummyFrameNumber);
                    }
                    if (!fileAndIssueListener.blnHadIssue) {
                        this._fbs.println(I.CMD_FRAME_CONVERT_OK());
                    }
                    this._fbs.println(I.CMD_NUM_FILES_CREATED(fileAndIssueListener.genFiles.size()));
                }
                catch (LoggedFailure ex) {
                    this._fbs.printErr(ex.getSourceMessage());
                }
                return;
            }
            case tim: {
                this.saveTim(inFile);
                return;
            }
        }
        throw new RuntimeException("Shouldn't happen");
    }

    private AutowireVDP setupPipeline(int iWidth, int iHeight, @Nonnull VideoFormat outputFormat, @Nonnull String sOutputBaseName, @CheckForNull String sOutputQuality, @CheckForNull String sUpsampleQuality, @Nonnull ILocalizedLogger log) throws CommandLineException {
        VideoFileNameFormatter formatter = new VideoFileNameFormatter(null, sOutputBaseName, outputFormat, iWidth, iHeight);
        AutowireVDP pipline = new AutowireVDP();
        switch (outputFormat) {
            case IMGSEQ_MDEC: {
                pipline.setMap(new VDP.Mdec2File(formatter, iWidth, iHeight, log));
                break;
            }
            case IMGSEQ_JPG: {
                pipline.setMap(new VDP.Mdec2Jpeg(formatter, iWidth, iHeight, log));
                break;
            }
            case IMGSEQ_BMP: 
            case IMGSEQ_PNG: {
                MdecDecodeQuality decQuality = MdecDecodeQuality.HIGH;
                if (sOutputQuality != null && (decQuality = MdecDecodeQuality.fromCmdLine(sOutputQuality)) == null) {
                    throw new CommandLineException(I.CMD_INVALID_VALUE_FOR_CMD(sOutputQuality, "-q,-quality"));
                }
                MdecDecoder vidDecoder = decQuality.makeDecoder(iWidth, iHeight);
                this._fbs.println(I.CMD_USING_QUALITY(decQuality.getCmdLine()));
                ChromaUpsample up = ChromaUpsample.Bicubic;
                if (vidDecoder instanceof MdecDecoder_double) {
                    if (sUpsampleQuality != null && (up = ChromaUpsample.fromCmdLine(sUpsampleQuality)) == null) {
                        throw new CommandLineException(I.CMD_INVALID_VALUE_FOR_CMD(sUpsampleQuality, "-up"));
                    }
                    this._fbs.println(I.CMD_UPSAMPLE_QUALITY(up.getDescription().getLocalizedMessage()));
                    ((MdecDecoder_double)vidDecoder).setUpsampler(up);
                }
                pipline.setMap(new VDP.Mdec2Decoded(vidDecoder, log));
                pipline.setMap(new VDP.Decoded2JavaImage(formatter, outputFormat.getImgFmt(), iWidth, iHeight, log));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this._fbs.println(I.CMD_SAVING_AS(formatter.format(null, log)));
        return pipline;
    }

    private void saveTim(@Nonnull File inFile) throws CommandLineException {
        this._fbs.println(I.CMD_READING_TIM(inFile));
        FileInputStream is = null;
        try {
            is = new FileInputStream(inFile);
            String sOutBaseName = Misc.removeExt(inFile.getName());
            Tim tim = Tim.read(is);
            this._fbs.println(new UnlocalizedMessage(tim.toString()));
            int iDigitCount = String.valueOf(tim.getPaletteCount()).length();
            for (int i = 0; i < tim.getPaletteCount(); ++i) {
                BufferedImage bi = tim.toBufferedImage(i);
                String sFileName = String.format("%s_p%0" + iDigitCount + "d.png", sOutBaseName, i);
                File file = new File(sFileName);
                this._fbs.println(I.IO_WRITING_FILE(file.getName()));
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            this._fbs.println(I.CMD_IMAGE_CONVERT_OK());
        }
        catch (BinaryDataNotRecognized ex) {
            throw new CommandLineException(I.CMD_NOT_TIM(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CommandLineException(I.CMD_TIM_IO_ERR(), (Throwable)ex);
        }
        finally {
            IO.closeSilently(is, Logger.getLogger(Command_Static.class.getName()));
        }
    }

    private static class FileAndIssueListener
    implements VDP.GeneratedFileListener,
    UserFriendlyLogger.OnWarnErr {
        public final List<File> genFiles = new ArrayList<File>();
        public final FeedbackStream fbs;
        public boolean blnHadIssue = false;

        public FileAndIssueListener(FeedbackStream fbs) {
            this.fbs = fbs;
        }

        @Override
        public void fileGenerated(File f) {
            this.genFiles.add(f);
        }

        @Override
        public void onWarn(ILocalizedMessage msg) {
            this.fbs.printlnWarn(msg);
            this.blnHadIssue = true;
        }

        @Override
        public void onErr(ILocalizedMessage msg) {
            this.fbs.printlnErr(msg);
            this.blnHadIssue = true;
        }
    }

    private static enum StaticType {
        bs,
        mdec,
        tim;

    }
}

