/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cmdline;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cmdline.Command;
import jpsxdec.cmdline.CommandLineException;
import jpsxdec.cmdline.SectorCounter;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.log.DebugLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.util.ArgParser;

class Command_SectorDump
extends Command {
    @Nonnull
    private String _sOutfile;

    public Command_SectorDump() {
        super("-sectordump");
    }

    @Override
    @CheckForNull
    protected ILocalizedMessage validate(@Nonnull String s) {
        this._sOutfile = s;
        return null;
    }

    @Override
    public void execute(@Nonnull ArgParser ap) throws CommandLineException {
        CdFileSectorReader cdReader = this.getCdReader();
        this._fbs.println(I.CMD_GENERATING_SECTOR_LIST());
        PrintStream ps = null;
        try {
            if (this._sOutfile.equals("-")) {
                ps = System.out;
            } else {
                try {
                    ps = new PrintStream(this._sOutfile);
                }
                catch (FileNotFoundException ex) {
                    throw new CommandLineException(I.IO_OPENING_FILE_NOT_FOUND_NAME(this._sOutfile), (Throwable)ex);
                }
            }
            ps.println(cdReader.getSourceFile());
            SectorCounter counter = new SectorCounter();
            SectorClaimSystem it = SectorClaimSystem.create(cdReader);
            while (it.hasNext()) {
                IIdentifiedSector idSect = it.next(DebugLogger.Log);
                ps.println(idSect);
                counter.increment(idSect);
            }
            it.close(DebugLogger.Log);
            for (Map.Entry<String, Integer> entry : counter) {
                ps.println(entry.getKey() + " " + entry.getValue());
            }
        }
        catch (CdFileSectorReader.CdReadException ex) {
            throw new CommandLineException(I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
        }
        finally {
            if (ps != null) {
                ps.flush();
                if (!ps.equals(System.out)) {
                    ps.close();
                }
            }
        }
    }
}

