/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cmdline;

import argparser.BooleanHolder;
import argparser.StringHolder;
import java.io.File;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cmdline.Command;
import jpsxdec.cmdline.CommandLineException;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.ILocalizedException;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ConsoleProgressLogger;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.tim.DiscItemTim;
import jpsxdec.modules.video.DiscItemVideoStream;
import jpsxdec.modules.video.sectorbased.DiscItemSectorBasedVideoStream;
import jpsxdec.modules.xa.DiscItemXaAudioStream;
import jpsxdec.util.ArgParser;
import jpsxdec.util.TaskCanceledException;

class Command_Items {
    private static final Logger LOG = Logger.getLogger(Command_Items.class.getName());

    Command_Items() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleItem(@Nonnull DiscItem item, @Nonnull ArgParser ap, @Nonnull FeedbackStream fbs, @Nonnull ConsoleProgressLogger saveLog, @Nonnull ConsoleProgressLogger replaceLog) throws CommandLineException {
        block24: {
            BooleanHolder fpsDumpArg = ap.addBoolOption("-fpsdump");
            BooleanHolder itemHelpArg = ap.addHelp();
            BooleanHolder frameInfoArg = ap.addBoolOption("-frameinfodump");
            StringHolder replaceFrames = ap.addStringOption("-replaceframes");
            StringHolder replaceTim = ap.addStringOption("-replacetim");
            StringHolder replaceAudio = ap.addStringOption("-replaceaudio");
            StringHolder replaceXa = ap.addStringOption("-replacexa");
            StringHolder xaNum = ap.addStringOption("-xa");
            StringHolder directory = ap.addStringOption("-dir");
            ap.match();
            try {
                if (fpsDumpArg.value) {
                    if (!(item instanceof DiscItemSectorBasedVideoStream)) {
                        throw new CommandLineException(I.CMD_DISC_ITEM_NOT_VIDEO());
                    }
                    fbs.println(new UnlocalizedMessage("Generating fps dump."));
                    PrintStream ps = new PrintStream("fps.txt");
                    try {
                        ((DiscItemSectorBasedVideoStream)item).fpsDump2(ps);
                        break block24;
                    }
                    finally {
                        ps.close();
                    }
                }
                if (itemHelpArg.value) {
                    fbs.println(I.CMD_DETAILED_HELP_FOR());
                    fbs.println(new UnlocalizedMessage(item.toString()));
                    item.makeSaverBuilder().printHelp(fbs);
                    break block24;
                }
                if (frameInfoArg.value) {
                    if (!(item instanceof DiscItemVideoStream)) {
                        throw new CommandLineException(I.CMD_DISC_ITEM_NOT_VIDEO());
                    }
                    ((DiscItemVideoStream)item).frameInfoDump(fbs.getUnderlyingStream(), fbs.getLevel() >= 4);
                    break block24;
                }
                if (replaceFrames.value != null) {
                    if (!(item instanceof DiscItemVideoStream)) {
                        throw new CommandLineException(I.CMD_DISC_ITEM_NOT_VIDEO());
                    }
                    if (!(item instanceof DiscItemSectorBasedVideoStream)) {
                        throw new CommandLineException(I.CMD_DISC_ITEM_VIDEO_FRAME_REPLACE_UNSUPPORTED(item.getSerializationTypeId()));
                    }
                    item.getSourceCd().beginPatching();
                    ((DiscItemSectorBasedVideoStream)item).replaceFrames(replaceLog, replaceFrames.value);
                    fbs.printlnWarn(I.CMD_BACKUP_DISC_IMAGE_WARNING());
                    fbs.printlnWarn(I.CMD_REOPENING_DISC_WRITE_ACCESS());
                    item.getSourceCd().applyPatches(replaceLog);
                    break block24;
                }
                if (replaceTim.value != null) {
                    if (!(item instanceof DiscItemTim)) {
                        throw new CommandLineException(I.CMD_DISC_ITEM_NOT_TIM());
                    }
                    DiscItemTim timItem = (DiscItemTim)item;
                    timItem.getSourceCd().beginPatching();
                    timItem.replace(fbs, new File(replaceTim.value));
                    fbs.printlnWarn(I.CMD_BACKUP_DISC_IMAGE_WARNING());
                    fbs.printlnWarn(I.CMD_REOPENING_DISC_WRITE_ACCESS());
                    timItem.getSourceCd().applyPatches(replaceLog);
                    break block24;
                }
                if (replaceAudio.value != null) {
                    if (!(item instanceof DiscItemAudioStream)) {
                        throw new CommandLineException(I.CMD_DISC_ITEM_NOT_AUDIO());
                    }
                    DiscItemAudioStream audioItem = (DiscItemAudioStream)item;
                    audioItem.getSourceCd().beginPatching();
                    audioItem.replace(replaceLog, new File(replaceAudio.value));
                    fbs.printlnWarn(I.CMD_BACKUP_DISC_IMAGE_WARNING());
                    fbs.printlnWarn(I.CMD_REOPENING_DISC_WRITE_ACCESS());
                    audioItem.getSourceCd().applyPatches(replaceLog);
                    break block24;
                }
                if (replaceXa.value != null) {
                    DiscItemXaAudioStream patchXa;
                    if (xaNum.value == null) {
                        throw new CommandLineException(I.CMD_REPLACEXA_MISSING_XA_OPTION());
                    }
                    if (!(item instanceof DiscItemXaAudioStream)) {
                        throw new CommandLineException(I.CMD_DISC_ITEM_NOT_XA());
                    }
                    DiscItemXaAudioStream xaItem = (DiscItemXaAudioStream)item;
                    fbs.println(I.CMD_XA_REPLACE_OPENING_PATCH_IDX(replaceXa.value));
                    DiscIndex patchIndex = new DiscIndex(replaceXa.value, (ILocalizedLogger)replaceLog);
                    try {
                        int iPatchXaIndex = Integer.parseInt(xaNum.value);
                        patchXa = (DiscItemXaAudioStream)patchIndex.getByIndex(iPatchXaIndex);
                        if (patchXa == null) {
                            throw new NullPointerException();
                        }
                    }
                    catch (Throwable ex) {
                        throw new CommandLineException(I.CMD_XA_REPLACE_BAD_ITEM_NUM(xaNum.value), ex);
                    }
                    xaItem.getSourceCd().beginPatching();
                    xaItem.replaceXa(replaceLog, patchXa);
                    fbs.printlnWarn(I.CMD_BACKUP_DISC_IMAGE_WARNING());
                    fbs.printlnWarn(I.CMD_REOPENING_DISC_WRITE_ACCESS());
                    xaItem.getSourceCd().applyPatches(replaceLog);
                    break block24;
                }
                File dir = directory.value != null ? new File(directory.value) : null;
                Command_Items.decodeDiscItem(item, dir, ap, fbs, saveLog);
                fbs.println(I.CMD_PROCESS_COMPLETE());
            }
            catch (Throwable ex) {
                if (ex instanceof ILocalizedException) {
                    throw new CommandLineException(((ILocalizedException)((Object)ex)).getSourceMessage());
                }
                ILocalizedMessage msg = I.CMD_ERR_EX_CLASS(ex, ex.getClass().getSimpleName());
                saveLog.log(Level.SEVERE, msg, ex);
                throw new CommandLineException(msg, ex);
            }
        }
    }

    private static void decodeDiscItem(@Nonnull DiscItem item, @CheckForNull File dir, @Nonnull ArgParser ap, @Nonnull FeedbackStream fbs, @Nonnull ConsoleProgressLogger cpl) throws LoggedFailure {
        DiscItemSaverBuilder builder = item.makeSaverBuilder();
        fbs.println(I.CMD_SAVING(item.toString()));
        builder.commandLineOptions(ap, fbs);
        fbs.println();
        builder.printSelectedOptions(fbs.makeLogger());
        long lngStart = System.currentTimeMillis();
        try {
            cpl.log(Level.INFO, new UnlocalizedMessage(item.getSourceCd().toString()));
            cpl.log(Level.INFO, new UnlocalizedMessage(item.toString()));
            builder.startSave(cpl, dir);
            fbs.println(I.CMD_NUM_FILES_CREATED(builder.getGeneratedFiles().size()));
        }
        catch (TaskCanceledException ex) {
            LOG.log(Level.SEVERE, "SHOULD NEVER HAPPEN", ex);
        }
        long lngEnd = System.currentTimeMillis();
        fbs.println(I.PROCESS_TIME((double)(lngEnd - lngStart) / 1000.0));
    }

    public static class Command_All
    extends Command {
        @Nonnull
        private String _sType;

        public Command_All() {
            super("-a", "-all");
        }

        @Override
        @CheckForNull
        protected ILocalizedMessage validate(@Nonnull String s) {
            this._sType = s;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@Nonnull ArgParser ap) throws CommandLineException {
            DiscIndex discIndex = this.getIndex();
            boolean blnFound = false;
            ConsoleProgressLogger saveLog = new ConsoleProgressLogger(I.SAVE_LOG_FILE_BASE_NAME().getLocalizedMessage(), this._fbs.getUnderlyingStream());
            ConsoleProgressLogger replaceLog = new ConsoleProgressLogger(I.REPLACE_LOG_FILE_BASE_NAME().getLocalizedMessage(), this._fbs.getUnderlyingStream());
            try {
                for (DiscItem item : discIndex) {
                    if (!item.getType().getName().equalsIgnoreCase(this._sType)) continue;
                    blnFound = true;
                    Command_Items.handleItem(item, ap.copy(), this._fbs, saveLog, replaceLog);
                    this._fbs.println(I.CMD_ITEM_COMPLETE());
                    this._fbs.println();
                }
            }
            finally {
                saveLog.close();
                replaceLog.close();
            }
            if (!blnFound) {
                this._fbs.println(I.CMD_NO_ITEMS_OF_TYPE(this._sType));
            } else {
                this._fbs.println(I.CMD_ALL_ITEMS_COMPLETE());
            }
        }
    }

    public static class Command_Item
    extends Command {
        @CheckForNull
        private String _sItemId;
        private int _iItemNum;

        public Command_Item() {
            super("-i", "-item");
        }

        @Override
        @CheckForNull
        protected ILocalizedMessage validate(@Nonnull String s) {
            try {
                this._iItemNum = Integer.parseInt(s);
                if (this._iItemNum < 0) {
                    return I.CMD_INVALID_VALUE_FOR_CMD(s, "-i,-item");
                }
                return null;
            }
            catch (NumberFormatException ex) {
                if (s.contains(" ")) {
                    return I.CMD_INVALID_VALUE_FOR_CMD(s, "-i,-item");
                }
                this._sItemId = s;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@Nonnull ArgParser ap) throws CommandLineException {
            DiscItem item;
            DiscIndex discIndex = this.getIndex();
            if (this._sItemId != null) {
                item = discIndex.getById(this._sItemId);
                if (item == null) {
                    throw new CommandLineException(I.CMD_DISC_ITEM_NOT_FOUND_STR(this._sItemId));
                }
            } else {
                item = discIndex.getByIndex(this._iItemNum);
                if (item == null) {
                    throw new CommandLineException(I.CMD_DISC_ITEM_NOT_FOUND_NUM(this._iItemNum));
                }
            }
            ConsoleProgressLogger saveLog = new ConsoleProgressLogger(I.SAVE_LOG_FILE_BASE_NAME().getLocalizedMessage(), this._fbs.getUnderlyingStream());
            ConsoleProgressLogger replaceLog = new ConsoleProgressLogger(I.REPLACE_LOG_FILE_BASE_NAME().getLocalizedMessage(), this._fbs.getUnderlyingStream());
            try {
                Command_Items.handleItem(item, ap, this._fbs, saveLog, replaceLog);
            }
            finally {
                saveLog.close();
                replaceLog.close();
            }
        }
    }
}

