/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cmdline;

import argparser.BooleanHolder;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.CdRiffHeader;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cmdline.Command;
import jpsxdec.cmdline.CommandLineException;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.util.ArgParser;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

class Command_CopySect
extends Command {
    private static final Logger LOG = Logger.getLogger(Command_CopySect.class.getName());
    @Nonnull
    private int[] _aiStartEndSectors;

    public Command_CopySect() {
        super("-copysect");
    }

    @Override
    @CheckForNull
    protected ILocalizedMessage validate(@Nonnull String s) {
        this._aiStartEndSectors = Command_CopySect.parseNumberRange(s);
        if (this._aiStartEndSectors == null) {
            return I.CMD_INVALID_VALUE_FOR_CMD(s, "-copysect");
        }
        return null;
    }

    @Override
    public void execute(@Nonnull ArgParser ap) throws CommandLineException {
        CdFileSectorReader cdReader = this.getCdReader();
        String sOutputFile = String.format("%s%d-%d.dat", Misc.removeExt(cdReader.getSourceFile().getName()), this._aiStartEndSectors[0], this._aiStartEndSectors[1]);
        this._fbs.println(I.CMD_COPYING_SECTOR(this._aiStartEndSectors[0], this._aiStartEndSectors[1], sOutputFile));
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(sOutputFile);
        }
        catch (FileNotFoundException ex) {
            throw new CommandLineException(I.IO_OPENING_FILE_NOT_FOUND_NAME(sOutputFile), (Throwable)ex);
        }
        BufferedOutputStream os = null;
        try {
            boolean blnAddCdxaHeader;
            os = new BufferedOutputStream(fos);
            int iRawSectorSize = cdReader.getRawSectorSize();
            if (iRawSectorSize == 2048) {
                blnAddCdxaHeader = false;
            } else if (!ap.hasRemaining()) {
                blnAddCdxaHeader = true;
            } else {
                BooleanHolder noCdxaHeader = ap.addBoolOption(false, "-nocdxa");
                ap.match();
                boolean bl = blnAddCdxaHeader = !noCdxaHeader.value;
            }
            if (blnAddCdxaHeader) {
                long lngFileSize = (long)(this._aiStartEndSectors[1] - this._aiStartEndSectors[0] + 1) * (long)iRawSectorSize;
                CdRiffHeader.write(os, lngFileSize);
            }
            for (int i = this._aiStartEndSectors[0]; i <= this._aiStartEndSectors[1]; ++i) {
                CdSector sector = cdReader.getSector(i);
                ((OutputStream)os).write(sector.getRawSectorDataCopy());
            }
        }
        catch (CdFileSectorReader.CdReadException ex) {
            throw new CommandLineException(I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CommandLineException(I.IO_WRITING_TO_FILE_ERROR_NAME(sOutputFile), (Throwable)ex);
        }
        finally {
            IO.closeSilently(os, LOG);
        }
    }

    @CheckForNull
    private static int[] parseNumberRange(@Nonnull String s) {
        String[] split = s.split("-");
        try {
            int iEnd;
            int iStart;
            if (split.length == 2) {
                iStart = Integer.parseInt(split[0]);
                iEnd = Integer.parseInt(split[1]);
            } else {
                iStart = iEnd = Integer.parseInt(s);
            }
            return new int[]{iStart, iEnd};
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

