/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cmdline;

import argparser.StringHolder;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cmdline.Command;
import jpsxdec.cmdline.CommandLineException;
import jpsxdec.cmdline.Command_CopySect;
import jpsxdec.cmdline.Command_Items;
import jpsxdec.cmdline.Command_SectorDump;
import jpsxdec.cmdline.Command_Static;
import jpsxdec.cmdline.Command_Visualize;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.MiscResources;
import jpsxdec.i18n.log.ConsoleProgressLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.util.ArgParser;
import jpsxdec.util.IO;
import jpsxdec.util.TaskCanceledException;

public class CommandLine {
    private static final Logger LOG = Logger.getLogger(CommandLine.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int main(@Nonnull ArgParser ap) {
        Command[] aoCommands;
        FeedbackStream Feedback = new FeedbackStream(System.out, 3);
        CommandLine.checkVerbosity(ap, Feedback);
        Feedback.println(I.JPSXDEC_VERSION_NON_COMMERCIAL("1.05 (beta)"));
        StringHolder inputFileArg = ap.addStringOption("-f", "-file");
        StringHolder indexFileArg = ap.addStringOption("-x", "-index");
        for (Command command : aoCommands = new Command[]{new Command_CopySect(), new Command_SectorDump(), new Command_Static(), new Command_Visualize(), new Command_Items.Command_Item(), new Command_Items.Command_All()}) {
            command.init(ap, inputFileArg, indexFileArg, Feedback);
        }
        ap.match();
        Command mainCommand = null;
        for (Command command : aoCommands) {
            if (!command.found()) continue;
            if (mainCommand != null) {
                Feedback.printlnErr(I.CMD_TOO_MANY_MAIN_COMMANDS());
                Feedback.printlnErr(I.CMD_TRY_HELP());
                return 1;
            }
            mainCommand = command;
        }
        try {
            if (mainCommand == null) {
                if (ap.hasHelp()) {
                    CommandLine.printMainHelp(Feedback);
                    return 0;
                }
                if (inputFileArg.value != null && indexFileArg.value != null) {
                    CommandLine.createAndSaveIndex(inputFileArg.value, indexFileArg.value, Feedback);
                    return 0;
                }
                Feedback.printlnErr(I.CMD_NEED_MAIN_COMMAND());
                Feedback.printlnErr(I.CMD_TRY_HELP());
                return 1;
            }
            ILocalizedMessage errMsg = mainCommand.validate();
            if (errMsg != null) {
                Feedback.printlnErr(errMsg);
                Feedback.printlnErr(I.CMD_TRY_HELP());
                return 1;
            }
            mainCommand.execute(ap);
            return 0;
        }
        catch (CommandLineException ex) {
            ILocalizedMessage msg = ex.getSourceMessage();
            msg.logEnglish(LOG, Level.SEVERE, ex);
            Feedback.printlnErr(msg);
            return 1;
        }
        catch (Throwable ex) {
            Feedback.printlnErr(I.CMD_ERR_EX_CLASS(ex, ex.getClass().getSimpleName()));
            LOG.log(Level.SEVERE, "Unhandled exception", ex);
            return 1;
        }
    }

    private static void checkVerbosity(@Nonnull ArgParser ap, @Nonnull FeedbackStream fbs) {
        StringHolder verbose = ap.addStringOption("-v", "-verbose");
        ap.match();
        if (verbose.value != null) {
            try {
                int iValue = Integer.parseInt(verbose.value);
                if (iValue >= 0 && iValue <= 4) {
                    fbs.setLevel(iValue);
                } else {
                    fbs.printlnWarn(I.CMD_INVALID_VALUE_FOR_CMD(verbose.value, "-v,-verbose"));
                }
            }
            catch (NumberFormatException ex) {
                fbs.printlnWarn(I.CMD_INVALID_VALUE_FOR_CMD(verbose.value, "-v,-verbose"));
            }
        }
    }

    private static void printMainHelp(@Nonnull FeedbackStream fbs) {
        Iterator<ILocalizedMessage> helpLines = MiscResources.main_cmdline_help();
        while (helpLines.hasNext()) {
            fbs.println(helpLines.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAndSaveIndex(@CheckForNull String sDiscFile, @Nonnull String sIndexFile, @Nonnull FeedbackStream Feedback) throws CommandLineException {
        CdFileSectorReader cd = CommandLine.loadDisc(sDiscFile, Feedback);
        try {
            DiscIndex index = CommandLine.buildIndex(cd, Feedback);
            CommandLine.saveIndex(index, sIndexFile, Feedback);
        }
        finally {
            IO.closeSilently(cd, LOG);
        }
    }

    @Nonnull
    static CdFileSectorReader loadDisc(@CheckForNull String sDiscFile, @Nonnull FeedbackStream Feedback) throws CommandLineException {
        if (sDiscFile == null) {
            throw new CommandLineException(I.CMD_COMMAND_NEEDS_DISC());
        }
        Feedback.println(I.IO_OPENING_FILE(sDiscFile));
        try {
            CdFileSectorReader cd = CdFileSectorReader.open(sDiscFile);
            Feedback.println(I.CMD_DISC_IDENTIFIED(cd.getTypeDescription()));
            return cd;
        }
        catch (CdFileSectorReader.CdFileNotFoundException ex) {
            throw new CommandLineException(I.IO_OPENING_FILE_NOT_FOUND_NAME(ex.getFile().toString()), (Throwable)ex);
        }
        catch (CdFileSectorReader.FileTooSmallToIdentifyException ex) {
            throw new CommandLineException(I.CD_FILE_TOO_SMALL(sDiscFile), (Throwable)ex);
        }
        catch (CdFileSectorReader.CdReadException ex) {
            throw new CommandLineException(I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
        }
    }

    static DiscIndex buildIndex(@Nonnull CdFileSectorReader cd, @Nonnull FeedbackStream fbs) {
        fbs.println(I.CMD_BUILDING_INDEX());
        DiscIndex index = null;
        ConsoleProgressLogger cpl = new ConsoleProgressLogger(I.INDEX_LOG_FILE_BASE_NAME().getLocalizedMessage(), fbs.getUnderlyingStream());
        try {
            cpl.log(Level.INFO, I.CMD_GUI_INDEXING(cd.toString()));
            index = new DiscIndex(cd, cpl);
        }
        catch (TaskCanceledException ex) {
            throw new RuntimeException("Impossible TaskCanceledException during commandline indexing", ex);
        }
        finally {
            cpl.close();
        }
        fbs.println(I.CMD_NUM_ITEMS_FOUND(index.size()));
        fbs.println();
        return index;
    }

    static void saveIndex(@Nonnull DiscIndex index, @Nonnull String sIndexFile, @Nonnull FeedbackStream Feedback) throws CommandLineException {
        if (index.size() < 1) {
            Feedback.println(I.CMD_NOT_SAVING_EMPTY_INDEX());
        } else {
            Feedback.println(I.CMD_SAVING_INDEX(sIndexFile));
            try {
                index.serializeIndex(new File(sIndexFile));
            }
            catch (FileNotFoundException ex) {
                throw new CommandLineException(I.IO_OPENING_FILE_NOT_FOUND_NAME(sIndexFile), (Throwable)ex);
            }
        }
    }
}

