/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cmdline;

import argparser.StringHolder;
import java.io.File;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cmdline.CommandLine;
import jpsxdec.cmdline.CommandLineException;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.UserFriendlyLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.util.ArgParser;

public abstract class Command {
    @Nonnull
    private final String[] _asFlags;
    @Nonnull
    private StringHolder _receiver;
    @Nonnull
    private StringHolder inputFileArg;
    @Nonnull
    private StringHolder indexFileArg;
    @Nonnull
    protected FeedbackStream _fbs;

    public Command(String ... asFlags) {
        this._asFlags = asFlags;
    }

    public abstract void execute(@Nonnull ArgParser var1) throws CommandLineException;

    public final Command init(@Nonnull ArgParser ap, @Nonnull StringHolder inputFileArg, @Nonnull StringHolder indexFileArg, @Nonnull FeedbackStream fbs) {
        this._receiver = ap.addStringOption(this._asFlags);
        this.inputFileArg = inputFileArg;
        this.indexFileArg = indexFileArg;
        this._fbs = fbs;
        return this;
    }

    public final boolean found() {
        return this._receiver.value != null;
    }

    @CheckForNull
    public final ILocalizedMessage validate() {
        return this.validate(this._receiver.value);
    }

    @CheckForNull
    protected abstract ILocalizedMessage validate(@Nonnull String var1);

    @Nonnull
    protected CdFileSectorReader getCdReader() throws CommandLineException {
        if (this.inputFileArg.value != null) {
            return CommandLine.loadDisc(this.inputFileArg.value, this._fbs);
        }
        if (this.indexFileArg.value != null) {
            DiscIndex index;
            this._fbs.println(I.CMD_READING_INDEX_FILE(this.indexFileArg.value));
            UserFriendlyLogger log = new UserFriendlyLogger(I.INDEX_LOG_FILE_BASE_NAME().getLocalizedMessage());
            try {
                index = new DiscIndex(this.indexFileArg.value, log);
            }
            catch (DiscIndex.IndexNotFoundException ex) {
                throw new CommandLineException(I.IO_OPENING_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
            }
            catch (DiscIndex.IndexReadException ex) {
                throw new CommandLineException(I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
            }
            catch (LocalizedDeserializationFail ex) {
                throw new CommandLineException(I.ERR_LOADING_INDEX_FILE_REASON(ex.getSourceMessage()), (Throwable)ex);
            }
            catch (CdFileSectorReader.CdFileNotFoundException ex) {
                throw new CommandLineException(I.IO_OPENING_FILE_NOT_FOUND_NAME(ex.getFile().toString()), (Throwable)ex);
            }
            catch (CdFileSectorReader.CdReadException ex) {
                throw new CommandLineException(I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
            }
            finally {
                log.close();
            }
            this._fbs.println(I.CMD_ITEMS_LOADED(index.size()));
            return index.getSourceCd();
        }
        throw new CommandLineException(I.CMD_DISC_FILE_REQUIRED());
    }

    @Nonnull
    protected DiscIndex getIndex() throws CommandLineException {
        DiscIndex index;
        if (this.indexFileArg.value != null) {
            if (this.inputFileArg.value != null) {
                CdFileSectorReader cd = CommandLine.loadDisc(this.inputFileArg.value, this._fbs);
                File idxFile = new File(this.indexFileArg.value);
                if (idxFile.exists()) {
                    this._fbs.println(I.CMD_READING_INDEX_FILE(this.indexFileArg.value));
                    UserFriendlyLogger log = new UserFriendlyLogger(I.INDEX_LOG_FILE_BASE_NAME().getLocalizedMessage());
                    try {
                        index = new DiscIndex(this.indexFileArg.value, cd, (ILocalizedLogger)log);
                    }
                    catch (DiscIndex.IndexNotFoundException ex) {
                        throw new CommandLineException(I.IO_OPENING_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
                    }
                    catch (DiscIndex.IndexReadException ex) {
                        throw new CommandLineException(I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
                    }
                    catch (LocalizedDeserializationFail ex) {
                        throw new CommandLineException(I.ERR_LOADING_INDEX_FILE_REASON(ex.getSourceMessage()), (Throwable)ex);
                    }
                    catch (CdFileSectorReader.CdFileNotFoundException ex) {
                        throw new CommandLineException(I.IO_OPENING_FILE_NOT_FOUND_NAME(ex.getFile().toString()), (Throwable)ex);
                    }
                    catch (CdFileSectorReader.CdReadException ex) {
                        throw new CommandLineException(I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
                    }
                    finally {
                        log.close();
                    }
                    this._fbs.println(I.CMD_USING_SRC_FILE(index.getSourceCd().getSourceFile()));
                    this._fbs.println(I.CMD_ITEMS_LOADED(index.size()));
                } else {
                    index = CommandLine.buildIndex(cd, this._fbs);
                    CommandLine.saveIndex(index, this.indexFileArg.value, this._fbs);
                }
            } else {
                this._fbs.println(I.CMD_READING_INDEX_FILE(this.indexFileArg.value));
                UserFriendlyLogger log = new UserFriendlyLogger(I.INDEX_LOG_FILE_BASE_NAME().getLocalizedMessage());
                try {
                    index = new DiscIndex(this.indexFileArg.value, log);
                }
                catch (DiscIndex.IndexNotFoundException ex) {
                    throw new CommandLineException(I.IO_OPENING_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
                }
                catch (DiscIndex.IndexReadException ex) {
                    throw new CommandLineException(I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
                }
                catch (LocalizedDeserializationFail ex) {
                    throw new CommandLineException(I.ERR_LOADING_INDEX_FILE_REASON(ex.getSourceMessage()), (Throwable)ex);
                }
                catch (CdFileSectorReader.CdFileNotFoundException ex) {
                    throw new CommandLineException(I.IO_OPENING_FILE_NOT_FOUND_NAME(ex.getFile().toString()), (Throwable)ex);
                }
                catch (CdFileSectorReader.CdReadException ex) {
                    throw new CommandLineException(I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), (Throwable)ex);
                }
                finally {
                    log.close();
                }
                this._fbs.println(I.CMD_USING_SRC_FILE(index.getSourceCd().getSourceFile()));
                this._fbs.println(I.CMD_ITEMS_LOADED(index.size()));
            }
        } else if (this.inputFileArg.value != null) {
            CdFileSectorReader cd = CommandLine.loadDisc(this.inputFileArg.value, this._fbs);
            index = CommandLine.buildIndex(cd, this._fbs);
        } else {
            throw new CommandLineException(I.CMD_NEED_INPUT_OR_INDEX());
        }
        return index;
    }

    @Nonnull
    protected File getInFile() throws CommandLineException {
        if (this.inputFileArg.value == null) {
            throw new CommandLineException(I.CMD_INPUT_FILE_REQUIRED());
        }
        File file = new File(this.inputFileArg.value);
        if (!file.exists()) {
            throw new CommandLineException(I.CMD_INPUT_FILE_NOT_FOUND(file));
        }
        return file;
    }
}

