/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorXaSubHeader;

public class XaAnalysis {
    private static final Logger LOG = Logger.getLogger(XaAnalysis.class.getName());
    public final int iSamplesPerSecond;
    public final int iBitsPerSample;
    public final boolean blnStereo;
    public final int iErrors;
    public final int iProbability;

    private XaAnalysis(int iSamplesPerSecond, int iBitsPerSample, boolean blnStereo, int iErrors, int iProbability) {
        this.iSamplesPerSecond = iSamplesPerSecond;
        this.iBitsPerSample = iBitsPerSample;
        this.blnStereo = blnStereo;
        this.iErrors = iErrors;
        this.iProbability = iProbability;
    }

    @CheckForNull
    public static XaAnalysis analyze(@Nonnull CdSector cdSector) {
        int iOfs;
        int iMaxErrors;
        if (cdSector.getType() != CdSector.Type.MODE2FORM2) {
            return null;
        }
        CdSectorXaSubHeader sh = cdSector.getSubHeader();
        if (sh == null) {
            return null;
        }
        if (sh.getSubMode().mask(100) != 100) {
            return null;
        }
        if (sh.getChannel() < 0 || sh.getChannel() > 255) {
            return null;
        }
        boolean blnStereo = sh.getCodingInfo().isStereo();
        int iSamplesPerSecond = sh.getCodingInfo().getSamplesPerSecond();
        int iBitsPerSample = sh.getCodingInfo().getBitsPerSample();
        int iErrors = 0;
        if (iBitsPerSample == 4) {
            iMaxErrors = 144;
            for (iOfs = 0; iOfs < cdSector.getCdUserDataSize() - 128; iOfs += 128) {
                for (int i = 0; i < 4; ++i) {
                    if (cdSector.readUserDataByte(iOfs + i) != cdSector.readUserDataByte(iOfs + 4 + i)) {
                        ++iErrors;
                    }
                    if (cdSector.readUserDataByte(iOfs + 8 + i) == cdSector.readUserDataByte(iOfs + 12 + i)) continue;
                    ++iErrors;
                }
            }
        } else {
            iMaxErrors = 216;
            for (iOfs = 0; iOfs < cdSector.getCdUserDataSize() - 128; iOfs += 128) {
                for (int i = 0; i < 4; ++i) {
                    byte b = cdSector.readUserDataByte(iOfs + i);
                    if (b != cdSector.readUserDataByte(iOfs + 4 + i)) {
                        ++iErrors;
                    }
                    if (b != cdSector.readUserDataByte(iOfs + 8 + i)) {
                        ++iErrors;
                    }
                    if (b == cdSector.readUserDataByte(iOfs + 12 + i)) continue;
                    ++iErrors;
                }
            }
        }
        int iProbability = 100 - iErrors * 100 / iMaxErrors;
        if (iErrors > 0) {
            LOG.log(Level.WARNING, "{0,number,#} errors out of {1,number,#} in XA sound parameters for {2}", new Object[]{iErrors, iMaxErrors, cdSector});
        }
        return new XaAnalysis(iSamplesPerSecond, iBitsPerSample, blnStereo, iErrors, iProbability);
    }
}

