/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import java.util.Arrays;

public class SectorErrorCorrection {
    private static final long[] EDC_crctable = new long[]{0L, 0x90910101L, 2434859521L, 28312320L, 2453734401L, 47187200L, 0x3600600L, 2482046721L, 2491484161L, 68159744L, 0x5A00A00L, 2503019265L, 0x6C00C00L, 2521894145L, 2548108801L, 0x7700F00L, 0x99011001L, 0x9901100L, 136319488L, 2561741569L, 188748800L, 2614170881L, 2590053889L, 183506688L, 226498560L, 2635143425L, 2627803649L, 204479232L, 2680232961L, 256908544L, 0xEE01E00L, 2658213633L, 2181111809L, 311435520L, 320872960L, 2209424129L, 272638976L, 2161190145L, 2170627585L, 300951296L, 377497600L, 2249271553L, 2275486209L, 389032704L, 2227252225L, 340798720L, 367013376L, 2238787329L, 452997120L, 2341548289L, 2317431297L, 447755008L, 2302751745L, 433075456L, 408958464L, 2297509633L, 2407610369L, 521156864L, 513817088L, 2385591041L, 499137536L, 2370911489L, 2363571713L, 477118208L, 3019980801L, 613433600L, 622871040L, 3048293121L, 641745920L, 3067168001L, 3076605441L, 670058240L, 545277952L, 2953922817L, 2980137473L, 556813056L, 2999012353L, 575687936L, 601902592L, 3010547457L, 754995200L, 3180417281L, 3156300289L, 749753088L, 3208729601L, 802182400L, 778065408L, 3203487489L, 3112261633L, 688937216L, 681597440L, 3090242305L, 734026752L, 3142671617L, 3135331841L, 712007424L, 0x36006000L, 2794545409L, 2803982849L, 934306560L, 2755748865L, 886072576L, 895510016L, 2784061185L, 2726389761L, 839936256L, 866150912L, 2737924865L, 817916928L, 2689690881L, 2715905537L, 829452032L, 2936107009L, 1066430720L, 1042313728L, 2930864897L, 1027634176L, 2916185345L, 2892068353L, 1022392064L, 998275072L, 2870049025L, 2862709249L, 976255744L, 2848029697L, 961576192L, 954236416L, 2826010369L, 3623976961L, 1217429760L, 1226867200L, 3652289281L, 1245742080L, 3671164161L, 3680601601L, 1274054400L, 1283491840L, 3692136705L, 3718351361L, 1295026944L, 3737226241L, 1313901824L, 1340116480L, 3748761345L, 1090555904L, 3515977985L, 3491860993L, 1085313792L, 3544290305L, 1137743104L, 1113626112L, 3539048193L, 3582040065L, 1158715648L, 1151375872L, 3560020737L, 1203805184L, 3612450049L, 3605110273L, 1181785856L, 0x5A00A000L, 3398541569L, 3407979009L, 1538302720L, 3359745025L, 1490068736L, 1499506176L, 3388057345L, 3464603649L, 1578150144L, 1604364800L, 3476138753L, 1556130816L, 3427904769L, 3454119425L, 1567665920L, 3271667713L, 1401991424L, 1377874432L, 3266425601L, 1363194880L, 3251746049L, 3227629057L, 1357952768L, 1468053504L, 3339827457L, 3332487681L, 1446034176L, 3317808129L, 1431354624L, 1424014848L, 3295788801L, 0x6C00C000L, 4237410561L, 4246848001L, 1840300800L, 4265722881L, 1859175680L, 1868613120L, 4294035201L, 4169254913L, 1745930496L, 1772145152L, 4180790017L, 1791020032L, 4199664897L, 4225879553L, 1802555136L, 4110536705L, 1703989504L, 1679872512L, 4105294593L, 1732301824L, 4157723905L, 4133606913L, 1727059712L, 1635833856L, 4044478721L, 4037138945L, 1613814528L, 4089568257L, 1666243840L, 1658904064L, 4067548929L, 0xEE01E001L, 2123424000L, 2132861440L, 4021412609L, 2084627456L, 3973178625L, 3982616065L, 2112939776L, 2055268352L, 3927042305L, 3953256961L, 2066803456L, 3905022977L, 2018569472L, 2044784128L, 3916558081L, 0x7700F000L, 3885101313L, 3860984321L, 1991308032L, 3846304769L, 1976628480L, 1952511488L, 3841062657L, 3816945665L, 1930492160L, 1923152384L, 3794926337L, 1908472832L, 3780246785L, 3772907009L, 0x7070FF00L};
    private static final short[] rs_l12_log = new short[]{0, 0, 1, 25, 2, 50, 26, 198, 3, 223, 51, 238, 27, 104, 199, 75, 4, 100, 224, 14, 52, 141, 239, 129, 28, 193, 105, 248, 200, 8, 76, 113, 5, 138, 101, 47, 225, 36, 15, 33, 53, 147, 142, 218, 240, 18, 130, 69, 29, 181, 194, 125, 106, 39, 249, 185, 201, 154, 9, 120, 77, 228, 114, 166, 6, 191, 139, 98, 102, 221, 48, 253, 226, 152, 37, 179, 16, 145, 34, 136, 54, 208, 148, 206, 143, 150, 219, 189, 241, 210, 19, 92, 131, 56, 70, 64, 30, 66, 182, 163, 195, 72, 126, 110, 107, 58, 40, 84, 250, 133, 186, 61, 202, 94, 155, 159, 10, 21, 121, 43, 78, 212, 229, 172, 115, 243, 167, 87, 7, 112, 192, 247, 140, 128, 99, 13, 103, 74, 222, 237, 49, 197, 254, 24, 227, 165, 153, 119, 38, 184, 180, 124, 17, 68, 146, 217, 35, 32, 137, 46, 55, 63, 209, 91, 149, 188, 207, 205, 144, 135, 151, 178, 220, 252, 190, 97, 242, 86, 211, 171, 20, 42, 93, 158, 132, 60, 57, 83, 71, 109, 65, 162, 31, 45, 67, 216, 183, 123, 164, 118, 196, 23, 73, 236, 127, 12, 111, 246, 108, 161, 59, 82, 41, 157, 85, 170, 251, 96, 134, 177, 187, 204, 62, 90, 203, 89, 95, 176, 156, 169, 160, 81, 11, 245, 22, 235, 122, 117, 44, 215, 79, 174, 213, 233, 230, 231, 173, 232, 116, 214, 244, 234, 168, 80, 88, 175};
    private static final short[] rs_l12_alog = new short[]{1, 2, 4, 8, 16, 32, 64, 128, 29, 58, 116, 232, 205, 135, 19, 38, 76, 152, 45, 90, 180, 117, 234, 201, 143, 3, 6, 12, 24, 48, 96, 192, 157, 39, 78, 156, 37, 74, 148, 53, 106, 212, 181, 119, 238, 193, 159, 35, 70, 140, 5, 10, 20, 40, 80, 160, 93, 186, 105, 210, 185, 111, 222, 161, 95, 190, 97, 194, 153, 47, 94, 188, 101, 202, 137, 15, 30, 60, 120, 240, 253, 231, 211, 187, 107, 214, 177, 127, 254, 225, 223, 163, 91, 182, 113, 226, 217, 175, 67, 134, 17, 34, 68, 136, 13, 26, 52, 104, 208, 189, 103, 206, 129, 31, 62, 124, 248, 237, 199, 147, 59, 118, 236, 197, 151, 51, 102, 204, 133, 23, 46, 92, 184, 109, 218, 169, 79, 158, 33, 66, 132, 21, 42, 84, 168, 77, 154, 41, 82, 164, 85, 170, 73, 146, 57, 114, 228, 213, 183, 115, 230, 209, 191, 99, 198, 145, 63, 126, 252, 229, 215, 179, 123, 246, 241, 255, 227, 219, 171, 75, 150, 49, 98, 196, 149, 55, 110, 220, 165, 87, 174, 65, 130, 25, 50, 100, 200, 141, 7, 14, 28, 56, 112, 224, 221, 167, 83, 166, 81, 162, 89, 178, 121, 242, 249, 239, 195, 155, 43, 86, 172, 69, 138, 9, 18, 36, 72, 144, 61, 122, 244, 245, 247, 243, 251, 235, 203, 139, 11, 22, 44, 88, 176, 125, 250, 233, 207, 131, 27, 54, 108, 216, 173, 71, 142};
    private static final short[][] DQ = new short[][]{{190, 96, 250, 132, 59, 81, 159, 154, 200, 7, 111, 245, 10, 20, 41, 156, 168, 79, 173, 231, 229, 171, 210, 240, 17, 67, 215, 43, 120, 8, 199, 74, 102, 220, 251, 95, 175, 87, 166, 113, 75, 198, 25}, {97, 251, 133, 60, 82, 160, 155, 201, 8, 112, 246, 11, 21, 42, 157, 169, 80, 174, 232, 230, 172, 211, 241, 18, 68, 216, 44, 121, 9, 200, 75, 103, 221, 252, 96, 176, 88, 167, 114, 76, 199, 26, 1}};
    private static final short[][] DP = new short[][]{{231, 229, 171, 210, 240, 17, 67, 215, 43, 120, 8, 199, 74, 102, 220, 251, 95, 175, 87, 166, 113, 75, 198, 25}, {230, 172, 211, 241, 18, 68, 216, 44, 121, 9, 200, 75, 103, 221, 252, 96, 176, 88, 167, 114, 76, 199, 26, 1}};
    private static final int RS_L12_BITS = 8;
    private static final int L2_P = 172;
    private static final int L2_Q = 104;

    public static long generateErrorDetectionAndCorrection(byte[] data, int iStart, int iEnd) {
        long edc_i = 0L;
        for (int i = iStart; i < iEnd; ++i) {
            edc_i = EDC_crctable[(int)((edc_i ^ (long)data[i]) & 0xFFL)] ^ edc_i >> 8;
        }
        return edc_i;
    }

    public static void generateErrorCorrectionCode_P(byte[] data, int data_p, byte[] output, int output_p) {
        assert (data.length - data_p >= 2064);
        assert (output.length - output_p >= 172);
        int j = 0;
        while (j < 43) {
            for (int i = 0; i < 24; ++i) {
                for (int n = 0; n < 2; ++n) {
                    int cdata = data[data_p + i * 2 * 43 + n] & 0xFF;
                    if (cdata == 0) continue;
                    short base = rs_l12_log[cdata];
                    for (int t = 0; t < 2; ++t) {
                        int sum = base + DP[t][i];
                        if (sum >= 255) {
                            sum -= 255;
                        }
                        int n2 = output_p + 86 * t + n;
                        output[n2] = (byte)(output[n2] ^ rs_l12_alog[sum]);
                    }
                }
            }
            ++j;
            output_p += 2;
            data_p += 2;
        }
    }

    public static void generateErrorCorrectionCode_Q(byte[] data, int data_p, byte[] output, int output_p) {
        assert (data.length - data_p >= 2236);
        assert (output.length - output_p >= 104);
        int j = 0;
        while (j < 26) {
            for (int i = 0; i < 43; ++i) {
                for (int n = 0; n < 2; ++n) {
                    int cdata = data[data_p + (j * 43 * 2 + i * 2 * 44 + n) % 2236] & 0xFF;
                    if (cdata == 0) continue;
                    short base = rs_l12_log[cdata];
                    for (int t = 0; t < 2; ++t) {
                        int sum = base + DQ[t][i];
                        if (sum >= 255) {
                            sum -= 255;
                        }
                        int n2 = output_p + 52 * t + n;
                        output[n2] = (byte)(output[n2] ^ rs_l12_alog[sum]);
                    }
                }
            }
            ++j;
            output_p += 2;
        }
    }

    public static void rebuildErrorCorrection(byte[] abRawSectorData, int iForm) {
        if (abRawSectorData.length < 2352 || iForm != 1 && iForm != 2) {
            throw new IllegalArgumentException();
        }
        if (iForm == 1) {
            long lngEdc = SectorErrorCorrection.generateErrorDetectionAndCorrection(abRawSectorData, 16, 2072);
            abRawSectorData[2072] = (byte)(lngEdc & 0xFFL);
            abRawSectorData[2073] = (byte)(lngEdc >> 8 & 0xFFL);
            abRawSectorData[2074] = (byte)(lngEdc >> 16 & 0xFFL);
            abRawSectorData[2075] = (byte)(lngEdc >> 24 & 0xFFL);
            byte[] bcd = Arrays.copyOfRange(abRawSectorData, 12, 16);
            Arrays.fill(abRawSectorData, 12, 16, (byte)0);
            Arrays.fill(abRawSectorData, 2076, 2248, (byte)0);
            Arrays.fill(abRawSectorData, 2248, 2352, (byte)0);
            SectorErrorCorrection.generateErrorCorrectionCode_P(abRawSectorData, 12, abRawSectorData, 2076);
            SectorErrorCorrection.generateErrorCorrectionCode_Q(abRawSectorData, 12, abRawSectorData, 2248);
            System.arraycopy(bcd, 0, abRawSectorData, 12, bcd.length);
        } else {
            long lngEdc = SectorErrorCorrection.generateErrorDetectionAndCorrection(abRawSectorData, 16, 2348);
            abRawSectorData[2348] = (byte)(lngEdc & 0xFFL);
            abRawSectorData[2349] = (byte)(lngEdc >> 8 & 0xFFL);
            abRawSectorData[2350] = (byte)(lngEdc >> 16 & 0xFFL);
            abRawSectorData[2351] = (byte)(lngEdc >> 24 & 0xFFL);
        }
    }
}

