/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;
import jpsxdec.util.TaskCanceledException;

public class DiscPatcher {
    private static final Logger LOG = Logger.getLogger(DiscPatcher.class.getName());
    @Nonnull
    private final File _patchFileName;
    @Nonnull
    private final RandomAccessFile _patchFile;
    private final int _iSectorCount;
    private final TreeSet<PatchEntry> _patches = new TreeSet();

    public DiscPatcher(@Nonnull CdFileSectorReader cd) throws CreatePatchFileException {
        try {
            this._patchFileName = File.createTempFile(cd.getSourceFile().getName(), ".temp");
        }
        catch (IOException ex) {
            File nearlyTempFileName = new File(cd.getSourceFile().getName() + "???.temp");
            throw new CreatePatchFileException(nearlyTempFileName, ex);
        }
        try {
            this._patchFile = new RandomAccessFile(this._patchFileName, "rw");
        }
        catch (FileNotFoundException ex) {
            throw new CreatePatchFileException(this._patchFileName, ex);
        }
        this._iSectorCount = cd.getSectorCount();
    }

    @Nonnull
    public File getTempFile() {
        return this._patchFileName;
    }

    public void addPatch(int iSector, int iOffsetInSector, @Nonnull byte[] abBytesToReplace, int iStartByteToUse, int iNumberOfBytesToReplace) throws WritePatchException {
        if (iSector > this._iSectorCount) {
            throw new IllegalArgumentException();
        }
        LOG.log(Level.INFO, "Patch sector {0} @{1} {2} bytes", new Object[]{iSector, iOffsetInSector, iNumberOfBytesToReplace});
        try {
            PatchEntry patch = new PatchEntry(iSector, iOffsetInSector, iNumberOfBytesToReplace, this._patchFile.getFilePointer());
            if (!this._patches.add(patch)) {
                throw new IllegalArgumentException("Replacement overlap");
            }
            this._patchFile.write(abBytesToReplace, iStartByteToUse, iNumberOfBytesToReplace);
        }
        catch (IOException ex) {
            throw new WritePatchException(this._patchFileName, ex);
        }
    }

    public void applyPatches(@Nonnull CdFileSectorReader cd, @Nonnull ProgressLogger pl) throws CdFileSectorReader.CdReopenException, CdFileSectorReader.CdReadException, CdFileSectorReader.CdWriteException, PatchReadException, TaskCanceledException {
        if (cd.getSectorCount() != this._iSectorCount) {
            throw new IllegalArgumentException();
        }
        Iterator<PatchEntry> it = this._patches.iterator();
        pl.progressStart(this._patches.size());
        cd.reopenForWriting();
        CdSector sector = null;
        byte[] abUserData = null;
        int i = 0;
        while (it.hasNext()) {
            PatchEntry patch = it.next();
            if (sector != null && patch.iSector != sector.getSectorIndexFromStart()) {
                pl.log(Level.INFO, new UnlocalizedMessage("Writing patched sector " + sector.getSectorIndexFromStart()));
                assert (abUserData != null);
                cd.writeSector(sector.getSectorIndexFromStart(), abUserData);
                sector = null;
                abUserData = null;
            }
            if (sector == null) {
                sector = cd.getSector(patch.iSector);
                abUserData = sector.getCdUserDataCopy();
            }
            try {
                this._patchFile.seek(patch.lngOffsetInPatchFile);
                assert (abUserData != null);
                IO.readByteArray(this._patchFile, abUserData, patch.iOffsetInSector, patch.iNumberOfBytesToReplace);
            }
            catch (IOException ex) {
                throw new PatchReadException(this._patchFileName, ex);
            }
            if (pl.isSeekingEvent()) {
                pl.event(new UnlocalizedMessage("Applying patch " + i + " of " + this._patches.size()));
            }
            pl.progressUpdate(i);
            ++i;
        }
        if (sector != null) {
            assert (abUserData != null);
            cd.writeSector(sector.getSectorIndexFromStart(), abUserData);
        }
        pl.progressEnd();
        IO.closeSilently(this._patchFile, LOG);
    }

    public void cancel() {
        IO.closeSilently(this._patchFile, LOG);
    }

    private static class PatchEntry
    implements Comparable<PatchEntry> {
        public final int iSector;
        public final int iOffsetInSector;
        public final int iNumberOfBytesToReplace;
        public final long lngOffsetInPatchFile;

        public PatchEntry(int iSector, int iOffsetInSector, int iNumberOfBytesToReplace, long lngOffsetInPatchFile) {
            if (iSector < 0 || iOffsetInSector < 0 || iOffsetInSector + iNumberOfBytesToReplace > 2448) {
                throw new IllegalArgumentException();
            }
            this.iSector = iSector;
            this.iOffsetInSector = iOffsetInSector;
            this.iNumberOfBytesToReplace = iNumberOfBytesToReplace;
            this.lngOffsetInPatchFile = lngOffsetInPatchFile;
        }

        @Override
        public int compareTo(PatchEntry o) {
            boolean blnNoOverlap;
            int i = Misc.intCompare(this.iSector, o.iSector);
            if (i != 0) {
                return i;
            }
            boolean bl = blnNoOverlap = this.iOffsetInSector + this.iNumberOfBytesToReplace < o.iOffsetInSector || o.iOffsetInSector + o.iNumberOfBytesToReplace < this.iOffsetInSector;
            if (blnNoOverlap) {
                return Misc.intCompare(this.iOffsetInSector, o.iOffsetInSector);
            }
            return 0;
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ApplyPatchToCdException
    extends IOException {
        @Nonnull
        private final File _file;

        public ApplyPatchToCdException(File file, IOException cause) {
            super(cause);
            this._file = file;
        }

        public File getFile() {
            return this._file;
        }
    }

    public static class PatchReadException
    extends IOException {
        @Nonnull
        private final File _file;

        public PatchReadException(File file, IOException cause) {
            super(cause);
            this._file = file;
        }

        public File getFile() {
            return this._file;
        }
    }

    public static class WritePatchException
    extends IOException {
        @Nonnull
        private final File _file;

        public WritePatchException(File file, IOException cause) {
            super(cause);
            this._file = file;
        }

        public File getFile() {
            return this._file;
        }
    }

    public static class CreatePatchFileException
    extends IOException {
        @Nonnull
        private final File _file;

        public CreatePatchFileException(File file, IOException cause) {
            super(cause);
            this._file = file;
        }

        public File getFile() {
            return this._file;
        }
    }
}

