/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class CdSectorXaSubHeader {
    private static final Logger LOG = Logger.getLogger(CdSectorXaSubHeader.class.getName());
    public static final int SIZEOF = 8;
    private final int _iFileNum1;
    private final int _iFileNum2;
    @Nonnull
    private final IssueType _eFileIssue;
    private final int _iChannel1;
    private final int _iChannel2;
    @Nonnull
    private final IssueType _eChannelIssue;
    @Nonnull
    private final SubMode _submode1;
    @Nonnull
    private final SubMode _submode2;
    @Nonnull
    private final IssueType _eSubModeIssue;
    private final CodingInfo _codingInfo1;
    private final CodingInfo _codingInfo2;
    @Nonnull
    private final IssueType _eCodingInfoIssue;
    private final int _iConfidenceBalance;

    public int getFileNumber() {
        switch (this._eFileIssue) {
            case DIFF_1BAD2GOOD: {
                return this._iFileNum2;
            }
            case DIFF_BOTHGOOD: 
            case DIFF_BOTHBAD: {
                return this._iConfidenceBalance <= 0 ? this._iFileNum1 : this._iFileNum2;
            }
        }
        return this._iFileNum1;
    }

    public int getChannel() {
        switch (this._eChannelIssue) {
            case DIFF_1BAD2GOOD: {
                return this._iChannel2;
            }
            case DIFF_BOTHGOOD: 
            case DIFF_BOTHBAD: {
                return this._iConfidenceBalance <= 0 ? this._iChannel1 : this._iChannel2;
            }
        }
        return this._iChannel1;
    }

    @Nonnull
    public SubMode getSubMode() {
        switch (this._eChannelIssue) {
            case DIFF_1BAD2GOOD: {
                return this._submode2;
            }
            case DIFF_BOTHGOOD: 
            case DIFF_BOTHBAD: {
                return this._iConfidenceBalance <= 0 ? this._submode1 : this._submode2;
            }
        }
        return this._submode1;
    }

    @Nonnull
    public CodingInfo getCodingInfo() {
        switch (this._eChannelIssue) {
            case DIFF_1BAD2GOOD: {
                return this._codingInfo2;
            }
            case DIFF_BOTHGOOD: 
            case DIFF_BOTHBAD: {
                return this._iConfidenceBalance <= 0 ? this._codingInfo1 : this._codingInfo2;
            }
        }
        return this._codingInfo1;
    }

    public CdSectorXaSubHeader(int iSector, @Nonnull byte[] abSectorData, int iStartOffset) {
        this._iFileNum1 = abSectorData[iStartOffset + 0] & 0xFF;
        this._iFileNum2 = abSectorData[iStartOffset + 0 + 4] & 0xFF;
        this._iChannel1 = abSectorData[iStartOffset + 1] & 0xFF;
        this._iChannel2 = abSectorData[iStartOffset + 1 + 4] & 0xFF;
        this._submode1 = new SubMode(abSectorData[iStartOffset + 2] & 0xFF);
        this._submode2 = new SubMode(abSectorData[iStartOffset + 2 + 4] & 0xFF);
        this._codingInfo1 = new CodingInfo(abSectorData[iStartOffset + 3] & 0xFF);
        this._codingInfo2 = new CodingInfo(abSectorData[iStartOffset + 3 + 4] & 0xFF);
        int iConfidenceBalance = 0;
        this._eFileIssue = this._iFileNum1 == this._iFileNum2 ? IssueType.EQUAL_BOTH_GOOD : IssueType.DIFF_BOTHGOOD;
        this._eChannelIssue = this._iChannel1 == this._iChannel2 ? IssueType.EQUAL_BOTH_GOOD : IssueType.DIFF_BOTHGOOD;
        boolean blnValid1 = this._submode1.isValid();
        if (this._submode1.toByte() == this._submode2.toByte()) {
            this._eSubModeIssue = blnValid1 ? IssueType.EQUAL_BOTH_GOOD : IssueType.EQUAL_BOTHBAD;
        } else {
            this._eSubModeIssue = IssueType.diffIssue(blnValid1, this._submode2.isValid());
            iConfidenceBalance += this._eSubModeIssue.Balance;
        }
        blnValid1 = this._codingInfo1.isValid();
        if (this._codingInfo1.toByte() == this._codingInfo2.toByte()) {
            this._eCodingInfoIssue = blnValid1 ? IssueType.EQUAL_BOTH_GOOD : IssueType.EQUAL_BOTHBAD;
        } else {
            this._eCodingInfoIssue = IssueType.diffIssue(blnValid1, this._codingInfo2.isValid());
            iConfidenceBalance += this._eChannelIssue.Balance;
        }
        this._iConfidenceBalance = iConfidenceBalance;
        if (LOG.isLoggable(Level.WARNING)) {
            StringBuilder sb = new StringBuilder();
            if (this._eFileIssue != IssueType.EQUAL_BOTH_GOOD) {
                this._eFileIssue.err("File", String.valueOf(this._iFileNum1), String.valueOf(this._iFileNum2), iConfidenceBalance, sb);
            }
            if (this._eChannelIssue != IssueType.EQUAL_BOTH_GOOD) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                this._eChannelIssue.err("Channel", String.valueOf(this._iChannel1), String.valueOf(this._iChannel2), iConfidenceBalance, sb);
            }
            if (this._eSubModeIssue != IssueType.EQUAL_BOTH_GOOD) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                this._eSubModeIssue.err("Submode", this._submode1.toString(), this._submode2.toString(), iConfidenceBalance, sb);
            }
            if (this._eCodingInfoIssue != IssueType.EQUAL_BOTH_GOOD) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                this._eCodingInfoIssue.err("Coding info", this._codingInfo1.toString(), this._codingInfo2.toString(), iConfidenceBalance, sb);
            }
            if (sb.length() > 0) {
                LOG.warning("Sector " + iSector + " corrupted " + sb);
            }
        }
    }

    int getErrorCount() {
        int i;
        int n = i = this._eFileIssue != IssueType.EQUAL_BOTH_GOOD ? 1 : 0;
        if (this._eChannelIssue != IssueType.EQUAL_BOTH_GOOD) {
            ++i;
        }
        if (this._eSubModeIssue != IssueType.EQUAL_BOTH_GOOD) {
            ++i;
        }
        if (this._eCodingInfoIssue != IssueType.EQUAL_BOTH_GOOD) {
            ++i;
        }
        return i;
    }

    public boolean hasErrors() {
        return this._eFileIssue != IssueType.EQUAL_BOTH_GOOD || this._eChannelIssue != IssueType.EQUAL_BOTH_GOOD || this._eSubModeIssue != IssueType.EQUAL_BOTH_GOOD || this._eCodingInfoIssue != IssueType.EQUAL_BOTH_GOOD;
    }

    public String toString() {
        return String.format("File.Channel:%d.%d Submode:%s", this.getFileNumber(), this.getChannel(), this.getSubMode());
    }

    public static class CodingInfo {
        private final int _iCodinginfo;

        public boolean getReserved() {
            return (this._iCodinginfo & 0x80) != 0;
        }

        public boolean getEmphasis() {
            return (this._iCodinginfo & 0x40) != 0;
        }

        public int getBitsPerSample() {
            return (this._iCodinginfo & 0x10) == 0 ? 4 : 8;
        }

        public int getSamplesPerSecond() {
            return (this._iCodinginfo & 4) == 0 ? 37800 : 18900;
        }

        public boolean isStereo() {
            return (this._iCodinginfo & 1) != 0;
        }

        CodingInfo(int i) {
            this._iCodinginfo = i;
        }

        public int toByte() {
            return this._iCodinginfo;
        }

        public boolean isValid() {
            return (this._iCodinginfo & 0x2A) == 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.isStereo() ? "Stereo" : "Mono");
            sb.append((this._iCodinginfo & 2) == 0 ? " " : "! ");
            sb.append(this.getBitsPerSample()).append(" bits/sample");
            sb.append((this._iCodinginfo & 8) == 0 ? " " : "! ");
            sb.append(this.getSamplesPerSecond()).append("Hz");
            if ((this._iCodinginfo & 0x20) != 0) {
                sb.append('!');
            }
            return sb.toString();
        }
    }

    public static class SubMode {
        private final int _iSubmode;
        public static final int MASK_END_OF_FILE = 128;
        public static final int MASK_REAL_TIME = 64;
        public static final int MASK_FORM = 32;
        public static final int MASK_TRIGGER = 16;
        public static final int MASK_DATA = 8;
        public static final int MASK_AUDIO = 4;
        public static final int MASK_VIDEO = 2;
        public static final int MASK_END_OF_RECORD = 1;
        private static final String[] CHAR_FLAGS_1 = new String[]{"----", "---E", "--V-", "--VE", "-A--", "-A-E", "-AV-", "-AVE", "D---", "D--E", "D-V-", "D-VE", "DA--", "DA-E", "DAV-", "DAVE"};
        private static final String[] CHAR_FLAGS_2 = new String[]{"----", "---T", "--2-", "--2T", "-R--", "-R-T", "-R2-", "-R2T", "F---", "F--T", "F-2-", "F-2T", "FR--", "FR-T", "FR2-", "FR2T"};

        SubMode(int i) {
            this._iSubmode = i;
        }

        public boolean getEndOfFile() {
            return (this._iSubmode & 0x80) != 0;
        }

        public boolean getRealTime() {
            return (this._iSubmode & 0x40) != 0;
        }

        public int getForm() {
            return (this._iSubmode >> 5 & 1) + 1;
        }

        public boolean getTrigger() {
            return (this._iSubmode & 0x10) != 0;
        }

        public boolean getData() {
            return (this._iSubmode & 8) != 0;
        }

        public boolean getAudio() {
            return (this._iSubmode & 4) != 0;
        }

        public boolean getVideo() {
            return (this._iSubmode & 2) != 0;
        }

        public boolean getEndOfRecord() {
            return (this._iSubmode & 1) != 0;
        }

        public int mask(int i) {
            return this._iSubmode & i;
        }

        public int toByte() {
            return this._iSubmode;
        }

        public boolean isValid() {
            int iByte = this._iSubmode >> 1 & 7;
            int iCount = 0;
            for (int i = 8; i > 0; i >>= 1) {
                if ((iByte & i) == 0) continue;
                ++iCount;
            }
            return iCount <= 1;
        }

        public String toString() {
            return CHAR_FLAGS_2[this._iSubmode >> 4] + CHAR_FLAGS_1[this._iSubmode & 0xF];
        }
    }

    private static enum IssueType {
        EQUAL_BOTH_GOOD(0){

            @Override
            public void err(String sName, String sVal1, String sVal2, int iConfidenceBalance, StringBuilder sb) {
                throw new IllegalStateException("Should never happen");
            }
        }
        ,
        EQUAL_BOTHBAD(0){

            @Override
            public void err(String sName, String sVal1, String sVal2, int iConfidenceBalance, StringBuilder sb) {
                sb.append(sName).append('[').append(sVal1).append(" (bad) == ").append(sVal2).append(" (bad)]");
            }
        }
        ,
        DIFF_BOTHGOOD(0){

            @Override
            public void err(String sName, String sVal1, String sVal2, int iConfidenceBalance, StringBuilder sb) {
                sb.append(sName).append('[').append(sVal1).append(" != ").append(sVal2).append(" chose ");
                if (iConfidenceBalance < 0) {
                    sb.append(sVal1).append(" by confidence]");
                } else if (iConfidenceBalance > 0) {
                    sb.append(sVal2).append(" by confidence]");
                } else {
                    sb.append(sVal1).append(" by default]");
                }
            }
        }
        ,
        DIFF_1GOOD2BAD(-1){

            @Override
            public void err(String sName, String sVal1, String sVal2, int iConfidenceBalance, StringBuilder sb) {
                sb.append(sName).append('[').append(sVal1).append(" != ").append(sVal2).append(" (bad)]");
            }
        }
        ,
        DIFF_1BAD2GOOD(1){

            @Override
            public void err(String sName, String sVal1, String sVal2, int iConfidenceBalance, StringBuilder sb) {
                sb.append(sName).append('[').append(sVal1).append(" (bad) != ").append(sVal2).append("]");
            }
        }
        ,
        DIFF_BOTHBAD(0){

            @Override
            public void err(String sName, String sVal1, String sVal2, int iConfidenceBalance, StringBuilder sb) {
                sb.append(sName).append('[').append(sVal1).append(" (bad) != ").append(sVal2).append(" (bad) chose ");
                if (iConfidenceBalance < 0) {
                    sb.append(sVal1).append(" by confidence]");
                } else if (iConfidenceBalance > 0) {
                    sb.append(sVal2).append(" by confidence]");
                } else {
                    sb.append(sVal1).append(" by default]");
                }
            }
        };

        public final int Balance;

        private IssueType(int i) {
            this.Balance = i;
        }

        public abstract void err(String var1, String var2, String var3, int var4, StringBuilder var5);

        @Nonnull
        public static IssueType diffIssue(boolean blnValid1, boolean blnValid2) {
            if (blnValid1) {
                if (blnValid2) {
                    return DIFF_BOTHGOOD;
                }
                return DIFF_1GOOD2BAD;
            }
            if (blnValid2) {
                return DIFF_1BAD2GOOD;
            }
            return DIFF_BOTHBAD;
        }
    }
}

