/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class CdSectorHeader {
    public static final int SIZEOF = 16;
    static final int[] SECTOR_SYNC_HEADER_INT = new int[]{0xFFFFFF, -1, -256};
    static final byte[] SECTOR_SYNC_HEADER = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0};
    private static final Logger LOG = Logger.getLogger(CdSectorHeader.class.getName());
    private final int _iSyncHeaderErrorCount;
    private final int _iMinutesBCD;
    private final boolean _blnMinutesBCD_ok;
    private final int _iSecondsBCD;
    private final boolean _blnSecondsBCD_ok;
    private final int _iSectorsBCD;
    private final boolean _blnSectorsBCD_ok;
    private final int _iMode;
    private final boolean _blnMode_ok;
    private final int _iByteErrorCount;
    @Nonnull
    private final Type _eType;

    public CdSectorHeader(int iSectorIndex, @Nonnull byte[] abSectorData, int iStartOffset) {
        boolean blnIsCdAudioSector;
        int iByteErrorCount = 0;
        for (int i = 0; i < SECTOR_SYNC_HEADER.length; ++i) {
            if (abSectorData[iStartOffset + i] == SECTOR_SYNC_HEADER[i]) continue;
            ++iByteErrorCount;
        }
        this._iSyncHeaderErrorCount = iByteErrorCount++;
        this._iMinutesBCD = abSectorData[iStartOffset + SECTOR_SYNC_HEADER.length + 0] & 0xFF;
        this._iSecondsBCD = abSectorData[iStartOffset + SECTOR_SYNC_HEADER.length + 1] & 0xFF;
        this._iSectorsBCD = abSectorData[iStartOffset + SECTOR_SYNC_HEADER.length + 2] & 0xFF;
        this._iMode = abSectorData[iStartOffset + SECTOR_SYNC_HEADER.length + 3] & 0xFF;
        this._blnMinutesBCD_ok = CdSectorHeader.isValidBinaryCodedDecimal(this._iMinutesBCD);
        if (!this._blnMinutesBCD_ok) {
            // empty if block
        }
        if (!(this._blnSecondsBCD_ok = CdSectorHeader.isValidBinaryCodedDecimal(this._iSecondsBCD))) {
            ++iByteErrorCount;
        }
        if (!(this._blnSectorsBCD_ok = CdSectorHeader.isValidBinaryCodedDecimal(this._iSectorsBCD))) {
            ++iByteErrorCount;
        }
        if (!(this._blnMode_ok = this._iMode >= 1 && this._iMode <= 2)) {
            ++iByteErrorCount;
        }
        this._iByteErrorCount = iByteErrorCount;
        boolean bl = blnIsCdAudioSector = !this._blnMode_ok || this._iSyncHeaderErrorCount > 4;
        if (blnIsCdAudioSector) {
            this._eType = Type.CD_AUDIO;
        } else {
            Type type = this._eType = this._iMode == 1 ? Type.MODE1 : Type.MODE2;
            if (this._iSyncHeaderErrorCount != 0) {
                LOG.log(Level.WARNING, "Sector {0,number,#} {1,number,#} bytes in the sync header are corrupted", new Object[]{iSectorIndex, this._iSyncHeaderErrorCount});
            }
            if (!this._blnMinutesBCD_ok) {
                LOG.log(Level.WARNING, "Sector {0,number,#} Minutes number is corrupted {1}", new Object[]{iSectorIndex, String.format("%02x", this._iMinutesBCD)});
            }
            if (!this._blnSecondsBCD_ok) {
                LOG.log(Level.WARNING, "Sector {0,number,#} Seconds number is corrupted {1}", new Object[]{iSectorIndex, String.format("%02x", this._iSecondsBCD)});
            }
            if (!this._blnSectorsBCD_ok) {
                LOG.log(Level.WARNING, "Sector {0,number,#} Sectors number is corrupted {1}", new Object[]{iSectorIndex, String.format("%02x", this._iSectorsBCD)});
            }
        }
    }

    @Nonnull
    Type getType() {
        return this._eType;
    }

    public int calculateSectorNumber() {
        if (this._eType == Type.CD_AUDIO) {
            throw new UnsupportedOperationException("Unable to calculate header sector number from CD audio sector.");
        }
        if (this._blnMinutesBCD_ok && this._blnSecondsBCD_ok && this._blnSectorsBCD_ok) {
            return CdSectorHeader.binaryCodedDecimalToInt(this._iMinutesBCD) * 60 * 75 + CdSectorHeader.binaryCodedDecimalToInt(this._iSecondsBCD) * 75 + CdSectorHeader.binaryCodedDecimalToInt(this._iSectorsBCD) - 150;
        }
        return -1;
    }

    private static boolean isValidBinaryCodedDecimal(int i) {
        return (i & 0xF) <= 9 && (i >> 4 & 0xF) <= 9;
    }

    private static int binaryCodedDecimalToInt(int i) {
        return (i >> 4 & 0xF) * 10 + (i & 0xF);
    }

    public String toString() {
        if (this._eType == Type.CD_AUDIO) {
            return "CD audio sector";
        }
        return String.format("Mode:%d Number:%02x'%02x\"%02xs=%d", this._iMode, this._iMinutesBCD, this._iSecondsBCD, this._iSectorsBCD, this.calculateSectorNumber());
    }

    public boolean hasErrors() {
        if (this._eType == Type.CD_AUDIO) {
            return false;
        }
        return this._iSyncHeaderErrorCount > 0 || !this._blnMode_ok || !this._blnMinutesBCD_ok || !this._blnSecondsBCD_ok || !this._blnSectorsBCD_ok;
    }

    int getErrorCount() {
        return this._iByteErrorCount;
    }

    static enum Type {
        CD_AUDIO,
        MODE1,
        MODE2;

    }
}

