/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorHeader;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.cdreaders.SectorErrorCorrection;

public class CdSector2352
extends CdSector {
    @CheckForNull
    private final CdSectorHeader _header;
    @CheckForNull
    private final CdSectorXaSubHeader _subHeader;
    private final int _iHeaderSize;
    private final int _iUserDataSize;
    @Nonnull
    private final CdSector.Type _type;

    public CdSector2352(int iSectorIndex, @Nonnull byte[] abSectorBytes, int iByteStartOffset, long lngFilePointer) {
        super(iSectorIndex, abSectorBytes, iByteStartOffset, lngFilePointer);
        if (iByteStartOffset + 2352 > abSectorBytes.length) {
            throw new IllegalArgumentException();
        }
        CdSectorHeader header = new CdSectorHeader(iSectorIndex, abSectorBytes, iByteStartOffset);
        switch (header.getType()) {
            case CD_AUDIO: {
                this._header = null;
                this._subHeader = null;
                this._iHeaderSize = 0;
                this._iUserDataSize = 2352;
                this._type = CdSector.Type.CD_AUDIO;
                break;
            }
            case MODE1: {
                this._header = header;
                this._subHeader = null;
                this._iHeaderSize = 16;
                this._iUserDataSize = 2048;
                this._type = CdSector.Type.MODE1;
                break;
            }
            default: {
                assert (header.getType() == CdSectorHeader.Type.MODE2);
                this._header = header;
                this._subHeader = new CdSectorXaSubHeader(iSectorIndex, abSectorBytes, iByteStartOffset + 16);
                this._iHeaderSize = 24;
                if (this._subHeader.getSubMode().getForm() == 1) {
                    this._iUserDataSize = 2048;
                    this._type = CdSector.Type.MODE2FORM1;
                    break;
                }
                this._iUserDataSize = 2324;
                this._type = CdSector.Type.MODE2FORM2;
            }
        }
    }

    @Override
    public int getRawCdSectorSize() {
        return 2352;
    }

    @Override
    public int getCdUserDataSize() {
        return this._iUserDataSize;
    }

    @Override
    protected int getHeaderDataSize() {
        return this._iHeaderSize;
    }

    @Override
    public CdSector.Type getType() {
        return this._type;
    }

    @Override
    public boolean isCdAudioSector() {
        return this._type == CdSector.Type.CD_AUDIO;
    }

    @Override
    @CheckForNull
    public CdSectorHeader getHeader() {
        return this._header;
    }

    @Override
    @CheckForNull
    public CdSectorXaSubHeader getSubHeader() {
        return this._subHeader;
    }

    @Override
    public boolean hasHeaderErrors() {
        return this._header != null && this._header.hasErrors() || this._subHeader != null && this._subHeader.hasErrors();
    }

    @Override
    public int getErrorCount() {
        int iCount = 0;
        if (this._header != null) {
            iCount += this._header.getErrorCount();
        }
        if (this._subHeader != null) {
            iCount += this._subHeader.getErrorCount();
        }
        return iCount;
    }

    @Override
    @Nonnull
    public byte[] rebuildRawSector(@Nonnull byte[] abNewUserData) {
        if (this._type == CdSector.Type.MODE1) {
            throw new UnsupportedOperationException("Rebuilding error correction for mode 1 not supported.");
        }
        if (abNewUserData.length != this._iUserDataSize) {
            throw new IllegalArgumentException();
        }
        if (this._type == CdSector.Type.CD_AUDIO) {
            return (byte[])abNewUserData.clone();
        }
        byte[] abRawData = this.getRawSectorDataCopy();
        System.arraycopy(abNewUserData, 0, abRawData, this._iHeaderSize, this._iUserDataSize);
        SectorErrorCorrection.rebuildErrorCorrection(abRawData, this._subHeader.getSubMode().getForm());
        return abRawData;
    }

    @Override
    public String toString() {
        switch (this._type) {
            case CD_AUDIO: {
                return String.format("[Sector:%d CD Audio]", this.getSectorIndexFromStart());
            }
            case MODE1: {
                return String.format("[Sector:%d %s]", this.getSectorIndexFromStart(), this.getHeader());
            }
        }
        assert (this._type == CdSector.Type.MODE2FORM1 || this._type == CdSector.Type.MODE2FORM2);
        return String.format("[Sector:%d %s %s]", this.getSectorIndexFromStart(), this.getHeader(), this.getSubHeader());
    }
}

