/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorHeader;
import jpsxdec.cdreaders.CdSectorXaSubHeader;

public class CdSector2336
extends CdSector {
    @Nonnull
    private final CdSectorXaSubHeader _subHeader;
    private final int _iUserDataSize;
    @Nonnull
    private final CdSector.Type _type;

    public CdSector2336(int iSectorIndex, @Nonnull byte[] abSectorBytes, int iByteStartOffset, long lngFilePointer) {
        super(iSectorIndex, abSectorBytes, iByteStartOffset, lngFilePointer);
        if (iByteStartOffset + 2336 > abSectorBytes.length) {
            throw new IllegalArgumentException();
        }
        this._subHeader = new CdSectorXaSubHeader(iSectorIndex, abSectorBytes, iByteStartOffset);
        if (this._subHeader.getSubMode().getForm() == 1) {
            this._iUserDataSize = 2048;
            this._type = CdSector.Type.MODE2FORM1;
        } else {
            this._iUserDataSize = 2324;
            this._type = CdSector.Type.MODE2FORM2;
        }
    }

    @Override
    public int getRawCdSectorSize() {
        return 2336;
    }

    @Override
    public int getCdUserDataSize() {
        return this._iUserDataSize;
    }

    @Override
    protected int getHeaderDataSize() {
        return 8;
    }

    @Override
    @Nonnull
    public CdSector.Type getType() {
        return this._type;
    }

    @Override
    public boolean isCdAudioSector() {
        return false;
    }

    @Override
    @CheckForNull
    public CdSectorHeader getHeader() {
        return null;
    }

    @Override
    @Nonnull
    public CdSectorXaSubHeader getSubHeader() {
        return this._subHeader;
    }

    @Override
    public boolean hasHeaderErrors() {
        return this._subHeader.hasErrors();
    }

    @Override
    public int getErrorCount() {
        return this._subHeader.getErrorCount();
    }

    @Override
    @Nonnull
    public byte[] rebuildRawSector(@Nonnull byte[] abNewUserData) {
        byte[] abRawData = this.getRawSectorDataCopy();
        System.arraycopy(abNewUserData, 0, abRawData, 8, this._iUserDataSize);
        Logger.getLogger(CdSector2336.class.getName()).info("No need to rebuild 2336 EDC");
        return abRawData;
    }

    @Override
    public String toString() {
        return String.format("[Sector:%d M2 %s]", this.getSectorIndexFromStart(), this.getSubHeader());
    }
}

