/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorHeader;
import jpsxdec.cdreaders.CdSectorXaSubHeader;

public class CdSector2048
extends CdSector {
    public CdSector2048(int iSectorIndex, @Nonnull byte[] abSectorBytes, int iByteStartOffset, long lngFilePointer) {
        super(iSectorIndex, abSectorBytes, iByteStartOffset, lngFilePointer);
        if (iByteStartOffset + 2048 > abSectorBytes.length) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int getRawCdSectorSize() {
        return 2048;
    }

    @Override
    public int getCdUserDataSize() {
        return 2048;
    }

    @Override
    protected int getHeaderDataSize() {
        return 0;
    }

    @Override
    @Nonnull
    public CdSector.Type getType() {
        return CdSector.Type.UNKNOWN2048;
    }

    @Override
    public boolean isCdAudioSector() {
        return false;
    }

    @Override
    @CheckForNull
    public CdSectorHeader getHeader() {
        return null;
    }

    @Override
    @CheckForNull
    public CdSectorXaSubHeader getSubHeader() {
        return null;
    }

    @Override
    public boolean hasHeaderErrors() {
        return false;
    }

    @Override
    public int getErrorCount() {
        return 0;
    }

    @Override
    @Nonnull
    public byte[] rebuildRawSector(@Nonnull byte[] abUserData) {
        return (byte[])abUserData.clone();
    }

    @Override
    public String toString() {
        return String.format("[Sector:%d 2048]", this.getSectorIndexFromStart());
    }
}

