/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSectorHeader;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.util.ByteArrayFPIS;
import jpsxdec.util.IO;

public abstract class CdSector {
    public static final int SECTOR_SIZE_2048_ISO = 2048;
    public static final int SECTOR_SIZE_2336_BIN_NOSYNC = 2336;
    public static final int SECTOR_SIZE_2352_BIN = 2352;
    public static final int SECTOR_SIZE_2448_BIN_SUBCHANNEL = 2448;
    public static final int SECTOR_USER_DATA_SIZE_MODE1_MODE2FORM1 = 2048;
    public static final int SECTOR_USER_DATA_SIZE_MODE2FORM2 = 2324;
    public static final int SECTOR_USER_DATA_SIZE_CD_AUDIO = 2352;
    private final int _iSectorIndex;
    @Nonnull
    private final byte[] _abSectorBytes;
    private final int _iByteStartOffset;
    private final long _lngFilePointer;

    public CdSector(int iSectorIndex, byte[] abSectorBytes, int iByteStartOffset, long lngFilePointer) {
        this._iSectorIndex = iSectorIndex;
        this._abSectorBytes = abSectorBytes;
        this._iByteStartOffset = iByteStartOffset;
        this._lngFilePointer = lngFilePointer;
    }

    public abstract int getRawCdSectorSize();

    public abstract int getCdUserDataSize();

    protected abstract int getHeaderDataSize();

    @Nonnull
    public abstract Type getType();

    public abstract boolean isCdAudioSector();

    @CheckForNull
    public abstract CdSectorHeader getHeader();

    @CheckForNull
    public abstract CdSectorXaSubHeader getSubHeader();

    public abstract boolean hasHeaderErrors();

    public abstract int getErrorCount();

    @Nonnull
    public abstract byte[] rebuildRawSector(@Nonnull byte[] var1);

    @Nonnull
    public abstract String toString();

    public int getSectorIndexFromStart() {
        return this._iSectorIndex;
    }

    public final long getUserDataFilePointer() {
        return this._lngFilePointer + (long)this.getHeaderDataSize();
    }

    @Nonnull
    public final byte[] getCdUserDataCopy() {
        int iStart = this._iByteStartOffset + this.getHeaderDataSize();
        return Arrays.copyOfRange(this._abSectorBytes, iStart, iStart + this.getCdUserDataSize());
    }

    public final void getCdUserDataCopy(int iSourcePos, @Nonnull byte[] abOut, int iOutPos, int iLength) throws IndexOutOfBoundsException {
        if (iSourcePos < 0 || iSourcePos + iLength > this.getCdUserDataSize() || iLength < 0 || iOutPos + iLength > abOut.length) {
            throw new IndexOutOfBoundsException();
        }
        int iStart = this._iByteStartOffset + this.getHeaderDataSize() + iSourcePos;
        System.arraycopy(this._abSectorBytes, iStart, abOut, iOutPos, iLength);
    }

    @Nonnull
    public final byte[] getRawSectorDataCopy() {
        return Arrays.copyOfRange(this._abSectorBytes, this._iByteStartOffset, this._iByteStartOffset + this.getRawCdSectorSize());
    }

    @Nonnull
    public final ByteArrayFPIS getCdUserDataStream() {
        int iStart = this._iByteStartOffset + this.getHeaderDataSize();
        return new ByteArrayFPIS(this._abSectorBytes, iStart, this.getCdUserDataSize(), this.getUserDataFilePointer());
    }

    public final byte readUserDataByte(int i) {
        this.checkIndex(i);
        return this._abSectorBytes[this._iByteStartOffset + this.getHeaderDataSize() + i];
    }

    public final short readSInt16LE(int i) {
        this.checkIndex(i);
        return IO.readSInt16LE(this._abSectorBytes, this._iByteStartOffset + this.getHeaderDataSize() + i);
    }

    public final short readSInt16BE(int i) {
        this.checkIndex(i);
        return IO.readSInt16BE(this._abSectorBytes, this._iByteStartOffset + this.getHeaderDataSize() + i);
    }

    public final int readUInt16LE(int i) {
        this.checkIndex(i);
        return IO.readUInt16LE(this._abSectorBytes, this._iByteStartOffset + this.getHeaderDataSize() + i);
    }

    public final long readUInt32LE(int i) {
        this.checkIndex(i);
        return IO.readUInt32LE(this._abSectorBytes, this._iByteStartOffset + this.getHeaderDataSize() + i);
    }

    public final long readUInt32BE(int i) {
        this.checkIndex(i);
        return IO.readUInt32BE(this._abSectorBytes, this._iByteStartOffset + this.getHeaderDataSize() + i);
    }

    public final int readSInt32LE(int i) {
        this.checkIndex(i);
        return IO.readSInt32LE(this._abSectorBytes, this._iByteStartOffset + this.getHeaderDataSize() + i);
    }

    public final int readSInt32BE(int i) {
        this.checkIndex(i);
        return IO.readSInt32BE(this._abSectorBytes, this._iByteStartOffset + this.getHeaderDataSize() + i);
    }

    public final long readSInt64BE(int i) {
        this.checkIndex(i);
        return IO.readSInt64BE(this._abSectorBytes, this._iByteStartOffset + this.getHeaderDataSize() + i);
    }

    private void checkIndex(int i) {
        if (i < 0 || i >= this.getCdUserDataSize()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static enum Type {
        CD_AUDIO(2352),
        UNKNOWN2048(2048),
        MODE1(2048),
        MODE2FORM1(2048),
        MODE2FORM2(2324);

        private final int _iSectorUserDataSize;

        private Type(int iSectorUserDataSize) {
            this._iSectorUserDataSize = iSectorUserDataSize;
        }

        public int getSectorUserDataSize() {
            return this._iSectorUserDataSize;
        }
    }
}

