/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.cdreaders;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import jpsxdec.util.IO;

public class CdRiffHeader {
    public static final int SIZEOF = 44;
    private static final byte[] RIFF = new byte[]{82, 73, 70, 70};
    private static final byte[] CDXA = new byte[]{67, 68, 88, 65};
    private static final byte[] fmt_ = new byte[]{102, 109, 116, 32};
    private static final byte[] data = new byte[]{100, 97, 116, 97};
    private static final byte[] EMPTY_fmt = new byte[16];

    public static void write(@Nonnull OutputStream os, long lngFileSize) throws IOException {
        if (lngFileSize % 2352L != 0L) {
            throw new IllegalArgumentException(lngFileSize + " is not a multiple of 2352");
        }
        if (lngFileSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("File size " + lngFileSize + " too big to write to header.");
        }
        os.write(RIFF);
        IO.writeInt32LE(os, lngFileSize + 44L - 8L);
        os.write(CDXA);
        os.write(fmt_);
        IO.writeInt32LE(os, 16L);
        os.write(EMPTY_fmt);
        os.write(data);
        IO.writeInt32LE(os, lngFileSize);
    }
}

