/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

public class vagpack {
    private static final int BUFFER_SIZE = 3584;
    private static final short[] wave = new short[3584];
    static double[][] f = new double[][]{{0.0, 0.0}, {-0.9375, 0.0}, {-1.796875, 0.8125}, {-1.53125, 0.859375}, {-1.90625, 0.9375}};

    public static int main(int argc, String[] argv) throws IOException {
        int j;
        int i;
        AudioInputStream fp = null;
        FileOutputStream vag = null;
        char[] fname = new char[128];
        double[] d_samples = new double[28];
        short[] four_bit = new short[28];
        find_predict find_predict2 = new find_predict();
        pack pack2 = new pack();
        if (argc != 2) {
            vagpack.printf("usage: vag-pack *.wav\n", new Object[0]);
            return -1;
        }
        try {
            fp = AudioSystem.getAudioInputStream(new File(argv[1]));
        }
        catch (IOException ex) {
            vagpack.printf("cant open %s\n", argv[1]);
            ex.printStackTrace(System.out);
            return -2;
        }
        catch (UnsupportedAudioFileException ex) {
            vagpack.printf("not a compatible audio file\n", new Object[0]);
            ex.printStackTrace(System.out);
            return -3;
        }
        int e = fp.getFormat().getChannels();
        if (e != 1) {
            vagpack.printf("must be MONO\n", new Object[0]);
            return -5;
        }
        int sample_freq = Math.round(fp.getFormat().getSampleRate());
        e = fp.getFormat().getSampleSizeInBits();
        if (e != 16) {
            vagpack.printf("only 16 bit samples\n", new Object[0]);
            return -6;
        }
        int sample_len = (int)fp.getFrameLength();
        System.arraycopy(argv[1].toCharArray(), 0, fname, 0, argv[1].length());
        int p = argv[1].lastIndexOf(46);
        System.arraycopy("VAG".toCharArray(), 0, fname, ++p, "VAG".length());
        try {
            vag = new FileOutputStream(new String(fname, 0, p + "VAG".length()));
        }
        catch (FileNotFoundException ex) {
            vagpack.printf("cant write output file\n", new Object[0]);
            ex.printStackTrace(System.out);
            return -8;
        }
        vag.write(Misc.stringToAscii("VAGp"));
        vagpack.fputi(32, vag);
        vagpack.fputi(0, vag);
        int size = sample_len / 28;
        if (sample_len % 28 != 0) {
            ++size;
        }
        vagpack.fputi(16 * (size + 2), vag);
        vagpack.fputi(sample_freq, vag);
        for (i = 0; i < 12; ++i) {
            vagpack.fputc(0, vag);
        }
        p -= 2;
        for (i = 0; i < 16 && p >= 0 && Character.isLetterOrDigit(fname[p]); ++i, --p) {
        }
        ++p;
        for (j = 0; j < i; ++j) {
            vagpack.fputc(fname[p + j], vag);
        }
        for (j = 0; j < 16 - i; ++j) {
            vagpack.fputc(0, vag);
        }
        for (i = 0; i < 16; ++i) {
            vagpack.fputc(0, vag);
        }
        int flags = 0;
        while (sample_len > 0) {
            size = sample_len >= 3584 ? 3584 : sample_len;
            vagpack.fread(wave, 2, size, fp);
            i = size / 28;
            if (size % 28 != 0) {
                for (j = size % 28; j < 28; ++j) {
                    vagpack.wave[28 * i + j] = 0;
                }
                ++i;
            }
            for (j = 0; j < i; ++j) {
                int ptr = j * 28;
                find_predict2.find_predict(wave, ptr, d_samples);
                pack2.pack(d_samples, four_bit, find_predict2.predict_nr, find_predict2.shift_factor);
                int d = find_predict2.predict_nr << 4 | find_predict2.shift_factor;
                vagpack.fputc(d, vag);
                vagpack.fputc(flags, vag);
                for (int k = 0; k < 28; k += 2) {
                    d = four_bit[k + 1] >> 8 & 0xF0 | four_bit[k] >> 12 & 0xF;
                    vagpack.fputc(d, vag);
                }
                if ((sample_len -= 28) >= 28) continue;
                flags = 1;
            }
        }
        vagpack.fputc(find_predict2.predict_nr << 4 | find_predict2.shift_factor, vag);
        vagpack.fputc(7, vag);
        for (i = 0; i < 14; ++i) {
            vagpack.fputc(0, vag);
        }
        fp.close();
        vag.close();
        return 0;
    }

    static void fputi(int d, FileOutputStream fp) throws IOException {
        fp.write(d >> 24);
        fp.write(d >> 16);
        fp.write(d >> 8);
        fp.write(d);
    }

    public static void main(String[] args) throws IOException {
        String[] cargs = new String[args.length + 1];
        System.arraycopy(args, 0, cargs, 1, args.length);
        System.exit(vagpack.main(cargs.length, cargs));
    }

    private static void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }

    private static void fputc(int c, FileOutputStream fos) throws IOException {
        fos.write(c);
    }

    private static void fread(short[] wave, int sizeof_elem, int size, AudioInputStream fp) throws IOException {
        byte[] buff = IO.readByteArray((InputStream)fp, size * sizeof_elem);
        for (int i = 0; i < size; ++i) {
            wave[i] = IO.readSInt16LE(buff, i * 2);
        }
    }

    static class pack {
        double s_1 = 0.0;
        double s_2 = 0.0;

        pack() {
        }

        void pack(double[] d_samples, short[] four_bit, int predict_nr, int shift_factor) {
            for (int i = 0; i < 28; ++i) {
                double s_0 = d_samples[i] + this.s_1 * f[predict_nr][0] + this.s_2 * f[predict_nr][1];
                double ds = s_0 * (double)(1 << shift_factor);
                int di = (int)ds + 2048 & 0xFFFFF000;
                if (di > Short.MAX_VALUE) {
                    di = Short.MAX_VALUE;
                }
                if (di < Short.MIN_VALUE) {
                    di = Short.MIN_VALUE;
                }
                four_bit[i] = (short)di;
                this.s_2 = this.s_1;
                this.s_1 = (double)(di >>= shift_factor) - s_0;
            }
        }
    }

    static class find_predict {
        double _s_1 = 0.0;
        double _s_2 = 0.0;
        int predict_nr;
        int shift_factor;

        find_predict() {
        }

        void find_predict(short[] samples, int samples_ptr, double[] d_samples) {
            int i;
            double[][] buffer = new double[28][5];
            double min = 1.0E10;
            double[] max = new double[5];
            double s_1 = 0.0;
            double s_2 = 0.0;
            for (i = 0; i < 5; ++i) {
                max[i] = 0.0;
                s_1 = this._s_1;
                s_2 = this._s_2;
                for (int j = 0; j < 28; ++j) {
                    double ds;
                    double s_0 = samples[samples_ptr + j];
                    if (s_0 > 30719.0) {
                        s_0 = 30719.0;
                    }
                    if (s_0 < -30720.0) {
                        s_0 = -30720.0;
                    }
                    buffer[j][i] = ds = s_0 + s_1 * f[i][0] + s_2 * f[i][1];
                    if (Math.abs(ds) > max[i]) {
                        max[i] = Math.abs(ds);
                    }
                    s_2 = s_1;
                    s_1 = s_0;
                }
                if (max[i] < min) {
                    min = max[i];
                    this.predict_nr = i;
                }
                if (!(min <= 7.0)) continue;
                this.predict_nr = 0;
                break;
            }
            this._s_1 = s_1;
            this._s_2 = s_2;
            for (i = 0; i < 28; ++i) {
                d_samples[i] = buffer[i][this.predict_nr];
            }
            int min2 = (int)min;
            int shift_mask = 16384;
            this.shift_factor = 0;
            while (this.shift_factor < 12 && (shift_mask & min2 + (shift_mask >> 3)) == 0) {
                ++this.shift_factor;
                shift_mask >>= 1;
            }
        }
    }
}

