/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.adpcm.IAdpcmSoundUnit;
import jpsxdec.adpcm.XaAdpcmDecoder;
import jpsxdec.util.Misc;

public class XaAdpcmSoundUnit
implements IAdpcmSoundUnit {
    private static final Logger LOG = Logger.getLogger(XaAdpcmSoundUnit.class.getName());
    private final int _iBestSoundUnitParameter;
    private final short[] _asiShiftedAdpcmSamples;

    public XaAdpcmSoundUnit(int iBestSoundUnitParameter, @Nonnull short[] asiShiftedAdpcmSamples) {
        this._iBestSoundUnitParameter = iBestSoundUnitParameter;
        this._asiShiftedAdpcmSamples = asiShiftedAdpcmSamples;
    }

    @Override
    public int getRange() {
        return this._iBestSoundUnitParameter & 0xF;
    }

    @Override
    public int getUncorruptedFilterIndex() {
        return this._iBestSoundUnitParameter >> 4 & 0xF;
    }

    @Override
    public short getShiftedAdpcmSample(int i) {
        return this._asiShiftedAdpcmSamples[i];
    }

    private static class SoundParameter
    implements Comparable<SoundParameter> {
        private final int _iIndex;
        private final int _iValue;
        private final boolean _blnIsValid;
        private final ArrayList<SoundParameter> _duplicates = new ArrayList(3);

        public SoundParameter(int iIndex, int iValue) {
            this._iIndex = iIndex;
            this._iValue = iValue;
            this._blnIsValid = (this._iValue & 0xC0) == 0;
        }

        public int getIndex() {
            return this._iIndex;
        }

        public int getValue() {
            return this._iValue;
        }

        public int getFixedValue() {
            int iFilterIndex = this._iValue >>> 4 & 0xF;
            int iRange = this._iValue & 0xF;
            if (iFilterIndex > 3) {
                iFilterIndex = 3;
            }
            return iFilterIndex << 4 | iRange;
        }

        public boolean isValid() {
            return this._blnIsValid;
        }

        public boolean addIfEquals(@Nonnull SoundParameter other) {
            if (other._iValue == this._iValue) {
                this._duplicates.add(other);
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(@Nonnull SoundParameter other) {
            if (this._iValue == other._iValue) {
                throw new IllegalStateException("I did something wrong");
            }
            if (this._blnIsValid && !other._blnIsValid) {
                return -1;
            }
            if (!this._blnIsValid && other._blnIsValid) {
                return 1;
            }
            if (this._blnIsValid) {
                if (this._duplicates.size() > other._duplicates.size()) {
                    return -1;
                }
                if (this._duplicates.size() < other._duplicates.size()) {
                    return 1;
                }
            }
            if (this._iIndex < other._iIndex) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("Should never happen");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(this._iIndex).append(']');
            for (SoundParameter dup : this._duplicates) {
                sb.append(",[").append(dup._iIndex).append(']');
            }
            sb.append('=').append(Misc.bitsToString(this._iValue, 8));
            if (!this._blnIsValid) {
                sb.append(" (bad)");
            }
            return sb.toString();
        }
    }

    private static class SoundParameterBuilder {
        @Nonnull
        private final ArrayList<SoundParameter> _allParameters = new ArrayList(4);
        @Nonnull
        private final ArrayList<SoundParameter> _uniqueParameters = new ArrayList(4);

        public void add(int iIndex, int iValue) {
            SoundParameter param = new SoundParameter(iIndex, iValue);
            this._allParameters.add(param);
            for (SoundParameter uniqueParam : this._uniqueParameters) {
                if (!uniqueParam.addIfEquals(param)) continue;
                return;
            }
            this._uniqueParameters.add(param);
        }

        public int getBestParameter(@Nonnull XaAdpcmDecoder.LogContext logContext) {
            boolean blnCorruption = false;
            if (this._uniqueParameters.size() > 1) {
                blnCorruption = true;
                Collections.sort(this._uniqueParameters);
            }
            SoundParameter chosen = this._uniqueParameters.get(0);
            int iChosen = chosen.getValue();
            boolean bl = blnCorruption = blnCorruption || !chosen.isValid();
            if (blnCorruption) {
                logContext.blnHadCorruption = true;
                if (LOG.isLoggable(Level.WARNING)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(logContext).append(" sound parameter corrupted: [");
                    for (int i = 0; i < this._allParameters.size(); ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(this._allParameters.get(i));
                    }
                    sb.append("]. Chose ").append(chosen);
                    if (!chosen.isValid()) {
                        iChosen = chosen.getFixedValue();
                        sb.append(" corrected to ").append(iChosen);
                    }
                    LOG.log(Level.WARNING, sb.toString());
                }
            }
            return iChosen;
        }
    }

    public static class Builder {
        private final SoundParameterBuilder _soundParameterBuilder = new SoundParameterBuilder();
        private int _iRedundantSoundParameterCount = 0;
        private final short[] _asiShiftedAdpcmSamples = new short[28];
        private int _iSampleIndex = 0;

        public void addRedundantParameter(int iSoundUnitParameter) {
            this._soundParameterBuilder.add(this._iRedundantSoundParameterCount, iSoundUnitParameter);
            ++this._iRedundantSoundParameterCount;
        }

        public void addShiftedAdpcmSample(short siShiftedSample) {
            this._asiShiftedAdpcmSamples[this._iSampleIndex] = siShiftedSample;
            ++this._iSampleIndex;
        }

        @Nonnull
        public XaAdpcmSoundUnit build(@Nonnull XaAdpcmDecoder.LogContext logContext) {
            return new XaAdpcmSoundUnit(this._soundParameterBuilder.getBestParameter(logContext), this._asiShiftedAdpcmSamples);
        }
    }
}

