/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import jpsxdec.adpcm.AudioShortReader;
import jpsxdec.adpcm.IContextCopier;
import jpsxdec.adpcm.K0K1Filter;
import jpsxdec.adpcm.SoundUnitEncoder;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;

public class XaAdpcmEncoder
implements Closeable {
    @Nonnull
    private final AudioShortReader _audioShortReader;
    private final int _iSampleRate;
    private final boolean _blnEncode4BitsElse8Bits;
    @Nonnull
    private final SoundUnitEncoder[] _aoEncoders;
    private final LogContext _logContext = new LogContext();
    @CheckForNull
    private InputStream _presetPrameters = null;

    public long getSampleFramesRead() {
        return this._audioShortReader.getSampleFramesRead();
    }

    public XaAdpcmEncoder(@Nonnull AudioInputStream ais, int iEncodeToAdpcmBitsPerSample) throws IncompatibleException {
        if (iEncodeToAdpcmBitsPerSample == 4) {
            this._blnEncode4BitsElse8Bits = true;
        } else if (iEncodeToAdpcmBitsPerSample == 8) {
            this._blnEncode4BitsElse8Bits = false;
        } else {
            throw new IllegalArgumentException("Invalid encoding bits/sample " + iEncodeToAdpcmBitsPerSample + ", must be 4 or 8");
        }
        AudioFormat fmt = ais.getFormat();
        if (Math.abs(fmt.getSampleRate() - 37800.0f) > 0.1f) {
            this._iSampleRate = 37800;
        } else if (Math.abs(fmt.getSampleRate() - 18900.0f) > 0.1f) {
            this._iSampleRate = 18900;
        } else {
            throw new IncompatibleException("Unsupported sample rate " + fmt.getSampleRate() + ", must be 18900 or 37800");
        }
        this._audioShortReader = new AudioShortReader(ais);
        int iChannels = fmt.getChannels();
        this._aoEncoders = new SoundUnitEncoder[iChannels];
        for (int i = 0; i < iChannels; ++i) {
            this._aoEncoders[i] = new SoundUnitEncoder(iEncodeToAdpcmBitsPerSample, K0K1Filter.XA);
        }
    }

    public boolean isStereo() {
        return this._aoEncoders.length == 2;
    }

    public int getSampleRate() {
        return this._iSampleRate;
    }

    public boolean isEof() {
        return this._audioShortReader.isEof();
    }

    @Override
    public void close() throws IOException {
        this._audioShortReader.close();
    }

    public void setPresetParameters(@CheckForNull InputStream presetParameters) {
        this._presetPrameters = presetParameters;
    }

    public void encode1Sector(@Nonnull OutputStream os) throws IOException {
        this._logContext.iSoundGroup = 0;
        while (this._logContext.iSoundGroup < 18) {
            this.encodeSoundGroup(os);
            ++this._logContext.iSoundGroup;
        }
        this._logContext.iSoundGroup = -1;
        ++this._logContext.iEncodedSectorCount;
    }

    private void encodeSoundGroup(@Nonnull OutputStream os) throws IOException {
        SoundUnitEncoder.EncodedUnit[] aoEncoded = this._blnEncode4BitsElse8Bits ? new SoundUnitEncoder.EncodedUnit[8] : new SoundUnitEncoder.EncodedUnit[4];
        this._logContext.iSoundUnit = 0;
        while (this._logContext.iSoundUnit < aoEncoded.length) {
            short[][] aasiPcmSoundUnitChannelSamples = this._audioShortReader.readSoundUnitSamples(28);
            this._logContext.iChannel = 0;
            while (this._logContext.iChannel < this._aoEncoders.length) {
                aoEncoded[this._logContext.iSoundUnit] = this._presetPrameters == null ? this._aoEncoders[this._logContext.iChannel].encodeSoundUnit(aasiPcmSoundUnitChannelSamples[this._logContext.iChannel], this._logContext) : this._aoEncoders[this._logContext.iChannel].encodeSoundUnit(aasiPcmSoundUnitChannelSamples[this._logContext.iChannel], this._presetPrameters.read(), this._logContext);
                ++this._logContext.iChannel;
                ++this._logContext.iSoundUnit;
            }
            this._logContext.iChannel = -1;
            this._logContext.lngSamplesFramesRead += 28L;
        }
        this._logContext.iSoundUnit = -1;
        if (this._blnEncode4BitsElse8Bits) {
            int i;
            for (i = 0; i < 4; ++i) {
                os.write(aoEncoded[i].getSoundParameter());
            }
            for (i = 0; i < 4; ++i) {
                os.write(aoEncoded[i].getSoundParameter());
            }
            for (i = 4; i < 8; ++i) {
                os.write(aoEncoded[i].getSoundParameter());
            }
            for (i = 4; i < 8; ++i) {
                os.write(aoEncoded[i].getSoundParameter());
            }
            for (i = 0; i < 28; ++i) {
                IO.writeInt4x2(os, aoEncoded[1].abEncodedAdpcm[i], aoEncoded[0].abEncodedAdpcm[i]);
                IO.writeInt4x2(os, aoEncoded[3].abEncodedAdpcm[i], aoEncoded[2].abEncodedAdpcm[i]);
                IO.writeInt4x2(os, aoEncoded[5].abEncodedAdpcm[i], aoEncoded[4].abEncodedAdpcm[i]);
                IO.writeInt4x2(os, aoEncoded[7].abEncodedAdpcm[i], aoEncoded[6].abEncodedAdpcm[i]);
            }
        } else {
            for (int iRepeat = 0; iRepeat < 4; ++iRepeat) {
                for (int i = 0; i < 4; ++i) {
                    os.write(aoEncoded[i].getSoundParameter());
                }
            }
            for (int i = 0; i < 28; ++i) {
                os.write(aoEncoded[0].abEncodedAdpcm[i]);
                os.write(aoEncoded[1].abEncodedAdpcm[i]);
                os.write(aoEncoded[2].abEncodedAdpcm[i]);
                os.write(aoEncoded[3].abEncodedAdpcm[i]);
            }
        }
    }

    public static class LogContext
    implements IContextCopier {
        public int iEncodedSectorCount = 0;
        public int iSoundGroup = -1;
        public int iSoundUnit = -1;
        public int iChannel = -1;
        public long lngSamplesFramesRead = 0L;

        private LogContext() {
        }

        @Override
        @Nonnull
        public LogContext copy() {
            LogContext cpy = new LogContext();
            cpy.iEncodedSectorCount = this.iEncodedSectorCount;
            cpy.iSoundGroup = this.iSoundGroup;
            cpy.iSoundUnit = this.iSoundUnit;
            cpy.iChannel = this.iChannel;
            cpy.lngSamplesFramesRead = this.lngSamplesFramesRead;
            return cpy;
        }

        public String toString() {
            return String.format("Sector %d Sound Group.Unit %d.%d Channel %d after Sample Frame %d", this.iEncodedSectorCount, this.iSoundGroup, this.iSoundUnit, this.iChannel, this.lngSamplesFramesRead);
        }
    }
}

