/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.adpcm.AdpcmContext;
import jpsxdec.adpcm.IContextCopier;
import jpsxdec.adpcm.K0K1Filter;
import jpsxdec.adpcm.SoundUnitDecoder;
import jpsxdec.adpcm.XaAdpcmSoundUnit;
import jpsxdec.util.IO;

public class XaAdpcmDecoder {
    public static final int ADPCM_SOUND_GROUPS_PER_SECTOR = 18;
    public static final int SIZEOF_SOUND_GROUP = 128;
    static final int SOUND_UNITS_IN_8_BIT_SOUND_GROUP = 4;
    static final int SOUND_UNITS_IN_4_BIT_SOUND_GROUP = 8;
    private final boolean _blnIsStereo;
    private final int _iAdpcmBitsPerSample;
    @Nonnull
    private final AdpcmContext _leftOrMonoContext;
    @CheckForNull
    private final AdpcmContext _rightContext;
    @Nonnull
    private final short[] _asiLeftOrMonoPcmBuffer;
    @CheckForNull
    private final short[] _asiRightPcmBuffer;
    @Nonnull
    private final XaAdpcmSoundUnitDecoder[] _aoSoundUnitDecoders;
    private final byte[] _abParameterBuffer = new byte[16];
    private final LogContext _logContext = new LogContext();

    public static int pcmSampleFramesGeneratedFromXaAdpcmSector(int iAdpcmBitsPerSample, boolean blnStereo) {
        int iSoundUnitCount;
        switch (iAdpcmBitsPerSample) {
            case 4: {
                iSoundUnitCount = 8;
                break;
            }
            case 8: {
                iSoundUnitCount = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bits/sample " + iAdpcmBitsPerSample);
            }
        }
        int iSamplesPerFrame = blnStereo ? 2 : 1;
        return 504 * iSoundUnitCount / iSamplesPerFrame;
    }

    public XaAdpcmDecoder(int iAdpcmBitsPerSample, boolean blnIsStereo, double dblVolume) {
        int iSoundUnitsPerSoundGroup;
        if (iAdpcmBitsPerSample == 8) {
            iSoundUnitsPerSoundGroup = 4;
        } else if (iAdpcmBitsPerSample == 4) {
            iSoundUnitsPerSoundGroup = 8;
        } else {
            throw new IllegalArgumentException("Invalid bits per sample " + iAdpcmBitsPerSample);
        }
        this._aoSoundUnitDecoders = new XaAdpcmSoundUnitDecoder[iSoundUnitsPerSoundGroup];
        for (int iSoundUnitIndex = 0; iSoundUnitIndex < this._aoSoundUnitDecoders.length; ++iSoundUnitIndex) {
            this._aoSoundUnitDecoders[iSoundUnitIndex] = new XaAdpcmSoundUnitDecoder(iSoundUnitIndex);
        }
        this._iAdpcmBitsPerSample = iAdpcmBitsPerSample;
        this._blnIsStereo = blnIsStereo;
        this._leftOrMonoContext = new AdpcmContext(dblVolume);
        this._asiLeftOrMonoPcmBuffer = new short[28];
        if (this._blnIsStereo) {
            this._rightContext = new AdpcmContext(dblVolume);
            this._asiRightPcmBuffer = new short[28];
        } else {
            this._rightContext = null;
            this._asiRightPcmBuffer = null;
        }
    }

    public double getVolume() {
        return this._leftOrMonoContext.getVolumeScale();
    }

    public int getAdpcmBitsPerSample() {
        return this._iAdpcmBitsPerSample;
    }

    public boolean isStereo() {
        return this._blnIsStereo;
    }

    public int getSampleFrameSize() {
        return this.isStereo() ? 4 : 2;
    }

    public long getSampleFramesWritten() {
        return this._logContext.lngSampleFramesWritten;
    }

    public boolean hadCorruption() {
        return this._logContext.blnHadCorruption;
    }

    @Nonnull
    public AudioFormat getOutputFormat(int iSampleFramesPerSecond) {
        return new AudioFormat(iSampleFramesPerSecond, 16, this._blnIsStereo ? 2 : 1, true, false);
    }

    public void decode(@Nonnull InputStream inStream, @Nonnull OutputStream out, int iSourceSector) throws IOException {
        this._logContext.decodeReset(iSourceSector);
        this._logContext.iSoundGroup = 0;
        while (this._logContext.iSoundGroup < 18) {
            this.decodeSoundGroup(inStream, out);
            ++this._logContext.iSoundGroup;
        }
        this._logContext.iSourceSector = -1;
        this._logContext.iSoundGroup = -1;
    }

    private void decodeSoundGroup(@Nonnull InputStream inStream, @Nonnull OutputStream out) throws IOException {
        IO.readByteArray(inStream, this._abParameterBuffer);
        if (this._iAdpcmBitsPerSample == 4) {
            this.deinterleave4BitsPerSampleSoundGroup(inStream);
        } else {
            this.deinterleave8BitsPerSampleSoundGroup(inStream);
        }
        if (this._blnIsStereo) {
            for (int iSoundUnit = 0; iSoundUnit < this._aoSoundUnitDecoders.length; iSoundUnit += 2) {
                this._logContext.iSoundUnit = iSoundUnit;
                XaAdpcmSoundUnitDecoder leftSoundUnit = this._aoSoundUnitDecoders[iSoundUnit];
                leftSoundUnit.decodeSoundUnit(this._leftOrMonoContext, this._asiLeftOrMonoPcmBuffer, this._logContext);
                this._logContext.iSoundUnit = iSoundUnit + 1;
                XaAdpcmSoundUnitDecoder rightSoundUnit = this._aoSoundUnitDecoders[iSoundUnit + 1];
                rightSoundUnit.decodeSoundUnit(this._rightContext, this._asiRightPcmBuffer, this._logContext);
                this._logContext.iSoundUnit = -1;
                int iSample = 0;
                while (iSample < 28) {
                    IO.writeInt16LE(out, (int)this._asiLeftOrMonoPcmBuffer[iSample]);
                    IO.writeInt16LE(out, (int)this._asiRightPcmBuffer[iSample]);
                    ++iSample;
                    ++this._logContext.lngSampleFramesWritten;
                }
            }
        } else {
            for (int iSoundUnit = 0; iSoundUnit < this._aoSoundUnitDecoders.length; ++iSoundUnit) {
                this._logContext.iSoundUnit = iSoundUnit;
                XaAdpcmSoundUnitDecoder soundUnit = this._aoSoundUnitDecoders[iSoundUnit];
                soundUnit.decodeSoundUnit(this._leftOrMonoContext, this._asiLeftOrMonoPcmBuffer, this._logContext);
                this._logContext.iSoundUnit = -1;
                int iSample = 0;
                while (iSample < 28) {
                    IO.writeInt16LE(out, (int)this._asiLeftOrMonoPcmBuffer[iSample]);
                    ++iSample;
                    ++this._logContext.lngSampleFramesWritten;
                }
            }
        }
    }

    private void deinterleave4BitsPerSampleSoundGroup(@Nonnull InputStream inStream) throws EOFException, IOException {
        for (int iSoundUnit = 0; iSoundUnit < 4; ++iSoundUnit) {
            this._logContext.iSoundUnit = iSoundUnit;
            this._aoSoundUnitDecoders[iSoundUnit].addSoundParamter(this._abParameterBuffer[iSoundUnit] & 0xFF);
            this._aoSoundUnitDecoders[iSoundUnit].addSoundParamter(this._abParameterBuffer[iSoundUnit + 4] & 0xFF);
            this._logContext.iSoundUnit = iSoundUnit + 4;
            this._aoSoundUnitDecoders[iSoundUnit + 4].addSoundParamter(this._abParameterBuffer[iSoundUnit + 8] & 0xFF);
            this._aoSoundUnitDecoders[iSoundUnit + 4].addSoundParamter(this._abParameterBuffer[iSoundUnit + 12] & 0xFF);
        }
        this._logContext.iSoundUnit = -1;
        for (int iSampleIdx = 0; iSampleIdx < 28; ++iSampleIdx) {
            this._logContext.iSoundUnit = 0;
            while (this._logContext.iSoundUnit < 8) {
                int iByte = inStream.read();
                if (iByte < 0) {
                    throw new EOFException();
                }
                short siADPCMSample = (short)((iByte & 0xF) << 12);
                this._aoSoundUnitDecoders[this._logContext.iSoundUnit].addShiftedAdpcmSample(siADPCMSample);
                ++this._logContext.iSoundUnit;
                siADPCMSample = (short)((iByte & 0xF0) << 8);
                this._aoSoundUnitDecoders[this._logContext.iSoundUnit].addShiftedAdpcmSample(siADPCMSample);
                ++this._logContext.iSoundUnit;
            }
            this._logContext.iSoundUnit = -1;
        }
    }

    private void deinterleave8BitsPerSampleSoundGroup(@Nonnull InputStream inStream) throws EOFException, IOException {
        this._logContext.iSoundUnit = 0;
        while (this._logContext.iSoundUnit < 4) {
            XaAdpcmSoundUnitDecoder soundUnit = this._aoSoundUnitDecoders[this._logContext.iSoundUnit];
            for (int iRepeat = this._logContext.iSoundUnit; iRepeat < 16; iRepeat += 4) {
                soundUnit.addSoundParamter(this._abParameterBuffer[iRepeat] & 0xFF);
            }
            ++this._logContext.iSoundUnit;
        }
        this._logContext.iSoundUnit = -1;
        for (int iSampleIdx = 0; iSampleIdx < 28; ++iSampleIdx) {
            this._logContext.iSoundUnit = 0;
            while (this._logContext.iSoundUnit < 4) {
                int iByte = inStream.read();
                if (iByte < 0) {
                    throw new EOFException();
                }
                this._aoSoundUnitDecoders[this._logContext.iSoundUnit].addShiftedAdpcmSample((short)(iByte << 8));
                ++this._logContext.iSoundUnit;
            }
            this._logContext.iSoundUnit = -1;
        }
    }

    private static class XaAdpcmSoundUnitDecoder {
        private final int _iSoundUnitIndex;
        private final SoundUnitDecoder _soundUnitDecoder = new SoundUnitDecoder(K0K1Filter.XA);
        private XaAdpcmSoundUnit.Builder _soundUnitBuilder = new XaAdpcmSoundUnit.Builder();

        public XaAdpcmSoundUnitDecoder(int iSoundUnitIndex) {
            this._iSoundUnitIndex = iSoundUnitIndex;
        }

        public void addSoundParamter(int iSoundParameter) {
            this._soundUnitBuilder.addRedundantParameter(iSoundParameter);
        }

        private void addShiftedAdpcmSample(short s) {
            this._soundUnitBuilder.addShiftedAdpcmSample(s);
        }

        private void decodeSoundUnit(@Nonnull AdpcmContext context, @Nonnull short[] asiOutPcmBuffer, @Nonnull LogContext logContext) {
            XaAdpcmSoundUnit su = this._soundUnitBuilder.build(logContext);
            this._soundUnitDecoder.decodeSoundUnit(context, su, asiOutPcmBuffer, logContext);
            this._soundUnitBuilder = new XaAdpcmSoundUnit.Builder();
        }
    }

    public static class LogContext
    implements IContextCopier {
        public long lngSampleFramesWritten = 0L;
        public int iSourceSector = -1;
        public int iSoundGroup = -1;
        public int iSoundUnit = -1;
        public boolean blnHadCorruption = false;

        @Override
        @Nonnull
        public LogContext copy() {
            LogContext cpy = new LogContext();
            cpy.lngSampleFramesWritten = this.lngSampleFramesWritten;
            cpy.iSourceSector = this.iSourceSector;
            cpy.iSoundGroup = this.iSoundGroup;
            cpy.iSoundUnit = this.iSoundUnit;
            cpy.blnHadCorruption = this.blnHadCorruption;
            return cpy;
        }

        public void decodeReset(int iSector) {
            this.iSourceSector = iSector;
            this.iSoundGroup = -1;
            this.iSoundUnit = -1;
            this.blnHadCorruption = false;
        }

        public String toString() {
            String s = String.format("Sector %d Sound Group.Unit %d.%d after Sample Frame %d", this.iSourceSector, this.iSoundGroup, this.iSoundUnit, this.lngSampleFramesWritten);
            if (this.blnHadCorruption) {
                return s + " [corruption]";
            }
            return s;
        }
    }
}

