/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

public class VagWriter
implements Closeable {
    private static final Logger LOG = Logger.getLogger(VagWriter.class.getName());
    private static final int VERSION = 32;
    private static final int RESERVED = 0;
    private static final int POSITION_OF_SOUND_LENGTH_IN_VAG_FILE = 12;
    @Nonnull
    private final RandomAccessFile _vagFile;
    @Nonnull
    private final String _sId;
    private final int _iSampleRate;
    private int _iWrittenSoundUnitCount = 0;

    public static boolean isValidId(@Nonnull String sId) {
        if (sId.length() > 16) {
            return false;
        }
        for (int i = 0; i < sId.length(); ++i) {
            if (Character.isLetterOrDigit(sId.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public VagWriter(@Nonnull String sOutputFile, @Nonnull String sId, int iSampleRate) throws FileNotFoundException, IOException {
        this(new File(sOutputFile), sId, iSampleRate);
    }

    public VagWriter(@Nonnull File outputFile, @Nonnull String sId, int iSampleRate) throws FileNotFoundException, IOException, IllegalArgumentException {
        if (!VagWriter.isValidId(sId)) {
            throw new IllegalArgumentException(sId);
        }
        this._sId = sId;
        this._iSampleRate = iSampleRate;
        this._vagFile = new RandomAccessFile(outputFile, "rw");
        try {
            this._vagFile.write(Misc.stringToAscii("VAGp"));
            IO.writeInt32LE(this._vagFile, 32L);
            IO.writeInt32LE(this._vagFile, 0L);
            IO.writeInt32LE(this._vagFile, 0L);
            IO.writeInt32LE(this._vagFile, (long)this._iSampleRate);
            IO.writeZeros(this._vagFile, 12);
            this._vagFile.write(Misc.stringToAscii(this._sId));
            IO.writeZeros(this._vagFile, 16 - this._sId.length());
            IO.writeZeros(this._vagFile, 16);
        }
        catch (IOException ex) {
            IO.closeSilently(this._vagFile, LOG);
            throw ex;
        }
    }

    public void writeSoundUnit(@Nonnull byte[] abSoundUnit) throws IOException {
        this.writeSoundUnit(abSoundUnit, 0);
    }

    public void writeSoundUnit(@Nonnull byte[] abSoundUnit, int iOffset) throws IOException {
        this._vagFile.write(abSoundUnit, iOffset, 16);
        ++this._iWrittenSoundUnitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean blnExceptionThrown = true;
        try {
            this._vagFile.seek(12L);
            IO.writeInt32LE(this._vagFile, (long)(this._iWrittenSoundUnitCount * 16));
            blnExceptionThrown = false;
        }
        finally {
            if (blnExceptionThrown) {
                IO.closeSilently(this._vagFile, LOG);
            } else {
                this._vagFile.close();
            }
        }
    }
}

