/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.adpcm.IAdpcmSoundUnit;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

public class SpuAdpcmSoundUnit
implements IAdpcmSoundUnit {
    private static final Logger LOG = Logger.getLogger(SpuAdpcmSoundUnit.class.getName());
    public static final int SIZEOF_SOUND_UNIT = 16;
    private static final byte[] FILTER_CORRUPTION_FIX = new byte[]{0, 1, 2, 3, 4, 1, 2, 3};
    @Nonnull
    private final byte[] _abSoundUnit = new byte[16];

    public SpuAdpcmSoundUnit(@Nonnull byte[] abSource) {
        this(abSource, 0);
    }

    public SpuAdpcmSoundUnit(@Nonnull byte[] abSource, int iSourceOffset) {
        if (iSourceOffset < 0 || iSourceOffset + 16 > abSource.length) {
            throw new IllegalArgumentException("iSourceOffset out of bounds " + iSourceOffset);
        }
        System.arraycopy(abSource, iSourceOffset, this._abSoundUnit, 0, 16);
        this.checkRange();
    }

    public SpuAdpcmSoundUnit(@Nonnull InputStream is) throws EOFException, IOException {
        IO.readByteArray(is, this._abSoundUnit);
        this.checkRange();
    }

    private void checkRange() {
        if (this.getRange() > 12) {
            LOG.log(Level.INFO, "Range {0} > 12", this.getRange());
        }
    }

    @Override
    public short getShiftedAdpcmSample(int i) {
        int iIndex = i / 2;
        boolean blnBottomNibble = i % 2 == 0;
        int iBothNibbles = this.getAdpcmByte(iIndex) & 0xFF;
        if (blnBottomNibble) {
            return (short)((iBothNibbles & 0xF) << 12);
        }
        return (short)((iBothNibbles & 0xF0) << 8);
    }

    @CheckForNull
    public String getCorruptionLog() {
        if (this.isFilterCorrupted() || this.isFlagBitsCorrupted()) {
            StringBuilder sbLog = new StringBuilder("Bad SPU ADPCM header:");
            if (this.isFilterCorrupted()) {
                sbLog.append(" Sound Parameter Filter Index[").append(this.getFilterIndex()).append(" > 4, using ").append(this.getUncorruptedFilterIndex()).append(']');
            }
            if (this.isFlagBitsCorrupted()) {
                sbLog.append(" BitFlags[").append(Misc.bitsToString(this.getFlagBits(), 8)).append("]");
            }
            return sbLog.toString();
        }
        return null;
    }

    public byte getSoundUnitParameters() {
        return this._abSoundUnit[0];
    }

    public int getFilterIndex() {
        return this.getSoundUnitParameters() >> 4 & 0xF;
    }

    public boolean isFilterCorrupted() {
        return this.getFilterIndex() > 4;
    }

    @Override
    public int getUncorruptedFilterIndex() {
        if (this.isFilterCorrupted()) {
            return FILTER_CORRUPTION_FIX[this.getSoundUnitParameters() & 7];
        }
        return this.getFilterIndex();
    }

    @Override
    public int getRange() {
        return this.getSoundUnitParameters() & 0xF;
    }

    public byte getFlagBits() {
        return this._abSoundUnit[1];
    }

    public boolean isFlagBitsCorrupted() {
        return (this.getFlagBits() & 0xFFFFFFF8) != 0;
    }

    private byte getAdpcmByte(int i) {
        if (i < 0 || i > 14) {
            throw new IndexOutOfBoundsException();
        }
        return this._abSoundUnit[2 + i];
    }

    public String toString() {
        if (this._abSoundUnit == null) {
            return null;
        }
        String sCorruptedFilter = "";
        if (this.isFilterCorrupted()) {
            sCorruptedFilter = String.format(" (corrupted -> %d)", this.getFilterIndex());
        }
        String sFlagsCorrupted = "";
        if (this.isFlagBitsCorrupted()) {
            sFlagsCorrupted = " corrupted";
        }
        return String.format("Params 0x%02x = filter %d%s + range %d, flags %s%s", this.getSoundUnitParameters(), this.getFilterIndex(), sCorruptedFilter, this.getRange(), Misc.bitsToString(this.getFlagBits(), 8), sFlagsCorrupted);
    }
}

