/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioInputStream;
import jpsxdec.adpcm.AudioShortReader;
import jpsxdec.adpcm.IContextCopier;
import jpsxdec.adpcm.K0K1Filter;
import jpsxdec.adpcm.SoundUnitEncoder;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;

public abstract class SpuAdpcmEncoder
implements Closeable {
    @Nonnull
    protected final AudioShortReader _audioShortReader;
    @Nonnull
    protected final SoundUnitEncoder _leftOrMonoEncoder;
    protected final LogContext _logContext = new LogContext();
    @CheckForNull
    protected InputStream _presetPrameters = null;

    protected SpuAdpcmEncoder(@Nonnull AudioInputStream input) throws IncompatibleException {
        this._audioShortReader = new AudioShortReader(input);
        this._leftOrMonoEncoder = new SoundUnitEncoder(4, K0K1Filter.SPU);
    }

    public abstract boolean isStereo();

    public boolean isEof() {
        return this._audioShortReader.isEof();
    }

    @Override
    public void close() throws IOException {
        this._audioShortReader.close();
    }

    public long getSampleFramesReadAndEncoded() {
        return this._logContext.lngSampleFramesReadEncoded;
    }

    public void setPresetParameters(@CheckForNull InputStream presetParameters) {
        this._presetPrameters = presetParameters;
    }

    protected void encode1SoundUnitChannel(@Nonnull SoundUnitEncoder encoder, @Nonnull short[] asiPcmSoundUnitChannelSamples, byte bFlagBits, @Nonnull OutputStream spuStream) throws IOException {
        SoundUnitEncoder.EncodedUnit encoded = this._presetPrameters == null ? encoder.encodeSoundUnit(asiPcmSoundUnitChannelSamples, this._logContext) : encoder.encodeSoundUnit(asiPcmSoundUnitChannelSamples, this._presetPrameters.read(), this._logContext);
        spuStream.write(encoded.getSoundParameter() & 0xFF);
        spuStream.write(bFlagBits & 0xFF);
        for (int i = 0; i < 28; i += 2) {
            IO.writeInt4x2(spuStream, encoded.abEncodedAdpcm[i + 1], encoded.abEncodedAdpcm[i]);
        }
    }

    public static class Stereo
    extends SpuAdpcmEncoder {
        @Nonnull
        private final SoundUnitEncoder _rightChannel;

        public Stereo(@Nonnull AudioInputStream input) throws IncompatibleException {
            super(input);
            if (input.getFormat().getChannels() != 2) {
                throw new IncompatibleException();
            }
            this._rightChannel = new SoundUnitEncoder(4, K0K1Filter.SPU);
        }

        @Override
        public boolean isStereo() {
            return true;
        }

        public boolean encode1SoundUnit(byte bLeftFlagBits, @Nonnull OutputStream leftSpuStream, byte bRightFlagBits, @Nonnull OutputStream rightSpuStream) throws IOException {
            if (this._audioShortReader.isEof()) {
                return false;
            }
            short[][] aasiPcmSoundUnitChannelSamples = this._audioShortReader.readSoundUnitSamples(28);
            this._logContext.iChannel = 0;
            this.encode1SoundUnitChannel(this._leftOrMonoEncoder, aasiPcmSoundUnitChannelSamples[this._logContext.iChannel], bLeftFlagBits, leftSpuStream);
            this._logContext.iChannel = 1;
            this.encode1SoundUnitChannel(this._rightChannel, aasiPcmSoundUnitChannelSamples[this._logContext.iChannel], bRightFlagBits, rightSpuStream);
            this._logContext.iChannel = -1;
            this._logContext.lngSampleFramesReadEncoded += 28L;
            return true;
        }
    }

    public static class Mono
    extends SpuAdpcmEncoder {
        public Mono(@Nonnull AudioInputStream input) throws IncompatibleException {
            super(input);
            if (input.getFormat().getChannels() != 1) {
                throw new IncompatibleException();
            }
        }

        @Override
        public boolean isStereo() {
            return false;
        }

        public boolean encode1SoundUnit(byte bFlagBits, @Nonnull OutputStream spuOutputStream) throws IOException {
            if (this._audioShortReader.isEof()) {
                return false;
            }
            short[][] aasiPcmSoundUnitChannelSamples = this._audioShortReader.readSoundUnitSamples(28);
            this.encode1SoundUnitChannel(this._leftOrMonoEncoder, aasiPcmSoundUnitChannelSamples[0], bFlagBits, spuOutputStream);
            return true;
        }
    }

    public static class LogContext
    implements IContextCopier {
        public long lngSampleFramesReadEncoded = 0L;
        public int iChannel = -1;

        private LogContext() {
        }

        @Override
        @Nonnull
        public LogContext copy() {
            LogContext cpy = new LogContext();
            cpy.lngSampleFramesReadEncoded = this.lngSampleFramesReadEncoded;
            cpy.iChannel = this.iChannel;
            return cpy;
        }

        public String toString() {
            return String.format("Sample frames read/encoded %d Channel %d", this.lngSampleFramesReadEncoded, this.iChannel);
        }
    }
}

