/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.adpcm.AdpcmContext;
import jpsxdec.adpcm.IContextCopier;
import jpsxdec.adpcm.K0K1Filter;
import jpsxdec.adpcm.SoundUnitDecoder;
import jpsxdec.adpcm.SpuAdpcmSoundUnit;
import jpsxdec.util.IO;

public abstract class SpuAdpcmDecoder {
    private static final Logger LOG = Logger.getLogger(SpuAdpcmDecoder.class.getName());
    @Nonnull
    protected final SpuSoundUnitDecoder _leftOrMonoSoundUnitDecoder;
    protected final LogContext _logContext = new LogContext();

    public static int calculatePcmSampleFramesGenerated(int iInputBytes) {
        if (iInputBytes % 16 != 0) {
            throw new IllegalArgumentException("iInputBytes must be divisible by 16");
        }
        int iSoundUnitCount = iInputBytes / 16;
        return iSoundUnitCount * 28;
    }

    public static int calculatePcmBytesGenerated(int iInputBytes) {
        return SpuAdpcmDecoder.calculatePcmSampleFramesGenerated(iInputBytes) * 2;
    }

    protected SpuAdpcmDecoder(double dblVolume) {
        this._leftOrMonoSoundUnitDecoder = new SpuSoundUnitDecoder(dblVolume, this._logContext);
    }

    public double getVolume() {
        return this._leftOrMonoSoundUnitDecoder.getVolume();
    }

    public boolean hadCorruption() {
        return this._logContext.blnHadCorruption;
    }

    public long getSampleFramesWritten() {
        return this._logContext.lngSampleFramesWritten;
    }

    public abstract int getBytesPerSampleFrame();

    @Nonnull
    public abstract AudioFormat getOutputFormat(int var1);

    protected static class SpuSoundUnitDecoder {
        private final SoundUnitDecoder _decoder = new SoundUnitDecoder(K0K1Filter.SPU);
        @Nonnull
        private final AdpcmContext _adpcmContext;
        private final short[] _asiPcmSampleBuffer = new short[28];
        private final LogContext _logContext;

        public SpuSoundUnitDecoder(double dblVolume, @Nonnull LogContext logContext) {
            this._adpcmContext = new AdpcmContext(dblVolume);
            this._logContext = logContext;
        }

        public void decodeSoundUnit(@Nonnull SpuAdpcmSoundUnit soundUnit) {
            String sCorruptionLog = soundUnit.getCorruptionLog();
            if (sCorruptionLog != null) {
                this._logContext.blnHadCorruption = true;
                if (LOG.isLoggable(Level.WARNING)) {
                    StringBuilder sbLog = new StringBuilder(sCorruptionLog);
                    sbLog.append(" at ").append(this._logContext);
                    LOG.warning(sbLog.toString());
                }
            }
            this._decoder.decodeSoundUnit(this._adpcmContext, soundUnit, this._asiPcmSampleBuffer, this._logContext);
        }

        public double getVolume() {
            return this._adpcmContext.getVolumeScale();
        }

        public short getDecodedPcmSample(int i) {
            return this._asiPcmSampleBuffer[i];
        }
    }

    public static class Stereo
    extends SpuAdpcmDecoder {
        @Nonnull
        private final SpuSoundUnitDecoder _rightSoundUnitDecoder;

        public Stereo(double dblVolume) {
            super(dblVolume);
            this._rightSoundUnitDecoder = new SpuSoundUnitDecoder(dblVolume, this._logContext);
        }

        @Override
        @Nonnull
        public AudioFormat getOutputFormat(int iSampleFramesPerSecond) {
            return new AudioFormat(iSampleFramesPerSecond, 16, 2, true, false);
        }

        @Override
        public int getBytesPerSampleFrame() {
            return 4;
        }

        public int decode(@Nonnull InputStream leftSpuStream, @Nonnull InputStream rightSpuStream, int iSoundUnitCount, @Nonnull OutputStream pcmOut) throws EOFException, IOException {
            int iTotal = 0;
            for (int iSoundUnit = 0; iSoundUnit < iSoundUnitCount; ++iSoundUnit) {
                SpuAdpcmSoundUnit leftUnit = new SpuAdpcmSoundUnit(leftSpuStream);
                SpuAdpcmSoundUnit rightUnit = new SpuAdpcmSoundUnit(rightSpuStream);
                iTotal += this.decode(leftUnit, rightUnit, pcmOut);
            }
            return iTotal;
        }

        public int decode(@Nonnull SpuAdpcmSoundUnit leftSoundUnit, @Nonnull SpuAdpcmSoundUnit rightSoundUnit, @Nonnull OutputStream out) throws IOException {
            this._logContext.decodeReset();
            this._logContext.iChannel = 0;
            this._leftOrMonoSoundUnitDecoder.decodeSoundUnit(leftSoundUnit);
            ++this._logContext.iSoundUnitsDecoded;
            this._logContext.iChannel = 1;
            this._rightSoundUnitDecoder.decodeSoundUnit(rightSoundUnit);
            ++this._logContext.iSoundUnitsDecoded;
            this._logContext.iChannel = -1;
            int iSampleIdx = 0;
            while (iSampleIdx < 28) {
                IO.writeInt16LE(out, (int)this._leftOrMonoSoundUnitDecoder.getDecodedPcmSample(iSampleIdx));
                IO.writeInt16LE(out, (int)this._rightSoundUnitDecoder.getDecodedPcmSample(iSampleIdx));
                ++iSampleIdx;
                ++this._logContext.lngSampleFramesWritten;
            }
            return 28;
        }
    }

    public static class Mono
    extends SpuAdpcmDecoder {
        public Mono(double dblVolume) {
            super(dblVolume);
        }

        @Override
        @Nonnull
        public AudioFormat getOutputFormat(int iSampleFramesPerSecond) {
            return new AudioFormat(iSampleFramesPerSecond, 16, 1, true, false);
        }

        @Override
        public int getBytesPerSampleFrame() {
            return 2;
        }

        public int decode(@Nonnull InputStream spuStream, int iSoundUnitCount, @Nonnull OutputStream pcmOut) throws IOException {
            int iTotal = 0;
            for (int iSoundUnit = 0; iSoundUnit < iSoundUnitCount; ++iSoundUnit) {
                SpuAdpcmSoundUnit soundUnit = new SpuAdpcmSoundUnit(spuStream);
                iTotal = this.decode(soundUnit, pcmOut);
            }
            return iTotal;
        }

        public int decode(@Nonnull SpuAdpcmSoundUnit soundUnit, @Nonnull OutputStream out) throws IOException {
            this._logContext.decodeReset();
            this._logContext.iChannel = 0;
            this._leftOrMonoSoundUnitDecoder.decodeSoundUnit(soundUnit);
            ++this._logContext.iSoundUnitsDecoded;
            int iSampleIdx = 0;
            while (iSampleIdx < 28) {
                IO.writeInt16LE(out, (int)this._leftOrMonoSoundUnitDecoder.getDecodedPcmSample(iSampleIdx));
                ++iSampleIdx;
                ++this._logContext.lngSampleFramesWritten;
            }
            this._logContext.iChannel = -1;
            return 28;
        }
    }

    public static class LogContext
    implements IContextCopier {
        public int iSoundUnitsDecoded = 0;
        public long lngSampleFramesWritten = 0L;
        public int iChannel = -1;
        public boolean blnHadCorruption = false;

        @Override
        @Nonnull
        public LogContext copy() {
            LogContext cpy = new LogContext();
            cpy.iSoundUnitsDecoded = this.iSoundUnitsDecoded;
            cpy.lngSampleFramesWritten = this.lngSampleFramesWritten;
            cpy.iChannel = this.iChannel;
            cpy.blnHadCorruption = this.blnHadCorruption;
            return cpy;
        }

        public void decodeReset() {
            this.iChannel = -1;
            this.blnHadCorruption = false;
        }

        public String toString() {
            String s = String.format("Sound Units %d Sample Frames Written %d Channel %d", this.iSoundUnitsDecoded, this.lngSampleFramesWritten, this.iChannel);
            if (this.blnHadCorruption) {
                return s + " [corruption]";
            }
            return s;
        }
    }
}

