/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.adpcm.IContextCopier;
import jpsxdec.adpcm.K0K1Filter;

public class SoundUnitEncoder {
    private static final Logger LOG = Logger.getLogger(SoundUnitEncoder.class.getName());
    @CheckForNull
    public static TelemetryListener TELEMETRY_LISTENER = null;
    private final AdpcmEncodingContext _context = new AdpcmEncodingContext();
    @Nonnull
    private final K0K1Filter _filters;
    private final int _iAdpcmBitsPerSample;
    private final int _iEncodeMax;
    private final int _iEncodeMin;
    private final int _iMaxRange;

    public SoundUnitEncoder(int iAdpcmBitsPerSample, @Nonnull K0K1Filter filters) {
        if (iAdpcmBitsPerSample == 4) {
            this._iAdpcmBitsPerSample = 4;
            this._iEncodeMin = -8;
            this._iEncodeMax = 7;
            this._iMaxRange = 12;
        } else if (iAdpcmBitsPerSample == 8) {
            this._iAdpcmBitsPerSample = 8;
            this._iEncodeMin = -128;
            this._iEncodeMax = 127;
            this._iMaxRange = 8;
        } else {
            throw new IllegalArgumentException("Bad bps " + iAdpcmBitsPerSample);
        }
        this._filters = filters;
    }

    @Nonnull
    EncodedUnit encodeSoundUnit(@Nonnull short[] asiPcmSoundUnitSamples, @Nonnull IContextCopier loggingContext) throws IOException {
        if (asiPcmSoundUnitSamples.length != 28) {
            throw new IllegalArgumentException();
        }
        FilterRangeEncoder best = null;
        FilterRangeEncoder zeroRangeFilter = null;
        for (int iRange = this._iMaxRange; iRange >= 0; --iRange) {
            for (int iFilterIdx = 0; iFilterIdx < this._filters.getCount(); ++iFilterIdx) {
                FilterRangeEncoder encTry = new FilterRangeEncoder(iFilterIdx, iRange, this._context.copy());
                if (iRange == 0 && iFilterIdx == 0) {
                    zeroRangeFilter = encTry;
                }
                if (encTry.encode(asiPcmSoundUnitSamples, loggingContext) || best != null && !encTry.isBetterThan(best)) continue;
                best = encTry;
            }
        }
        if (best == null) {
            LOG.log(Level.WARNING, "Had to clamp encoded samples to encode {0}", loggingContext);
            best = zeroRangeFilter;
        }
        this._context.update(best.getDecodedContext());
        return best.makeEncodedUnit();
    }

    @Nonnull
    private EncodedUnit encodeSoundUnit(@Nonnull short[] asiPcmSoundUnitSamples, int iFilterIdx, int iRange, @Nonnull IContextCopier loggingContext) throws IOException {
        if (asiPcmSoundUnitSamples.length != 28) {
            throw new IllegalArgumentException();
        }
        if (iFilterIdx < 0 || iFilterIdx >= this._filters.getCount() || iRange < 0 || iRange > this._iMaxRange) {
            throw new IllegalArgumentException();
        }
        FilterRangeEncoder encoder = new FilterRangeEncoder(iFilterIdx, iRange, this._context.copy());
        if (encoder.encode(asiPcmSoundUnitSamples, loggingContext)) {
            LOG.log(Level.WARNING, "{0}: Unable to encode with Filter Index {1} Range {2} without clamping", new Object[]{loggingContext, iFilterIdx, iRange});
        }
        this._context.update(encoder.getDecodedContext());
        return encoder.makeEncodedUnit();
    }

    @Nonnull
    EncodedUnit encodeSoundUnit(@Nonnull short[] asiPcmSoundUnitSamples, int iParameters, @Nonnull IContextCopier loggingContext) throws IOException {
        if (iParameters < 0) {
            throw new IllegalArgumentException();
        }
        byte iFilterIdx = (byte)(iParameters >>> 4 & 0xF);
        byte iRange = (byte)(iParameters & 0xF);
        return this.encodeSoundUnit(asiPcmSoundUnitSamples, iFilterIdx, iRange, loggingContext);
    }

    public static interface TelemetryListener {
        public void soundUnitEncoded(@Nonnull Telemetry var1);
    }

    public static class Telemetry {
        @Nonnull
        private final IContextCopier _loggingContext;
        public final int iFilter;
        public final int iRange;
        public final boolean[] ablnSampleClamped;
        public final short[] asiSourcePcmSamples;
        public final double[] adblPrev1Samples;
        public final double[] adblPrev2Samples;
        public final double[] adblFilteredSamples;
        public final double[] adblRangedSamples;
        public final byte[] abEncodedAdpcmSamples;
        public final short[] asiShortTopSamples;
        public final double[] adblDecodedSamples;
        public double dblMaxDelta;
        public String sFailure;

        private Telemetry(@Nonnull IContextCopier loggingContextx, int _iFilter, int _iRange) {
            this._loggingContext = loggingContextx;
            this.iFilter = _iFilter;
            this.iRange = _iRange;
            this.ablnSampleClamped = new boolean[28];
            this.asiSourcePcmSamples = new short[28];
            this.adblPrev1Samples = new double[28];
            this.adblPrev2Samples = new double[28];
            this.adblFilteredSamples = new double[28];
            this.adblRangedSamples = new double[28];
            this.abEncodedAdpcmSamples = new byte[28];
            this.asiShortTopSamples = new short[28];
            this.adblDecodedSamples = new double[28];
        }

        @Nonnull
        public Object getLoggingContextCopy() {
            return this._loggingContext.copy();
        }

        public String sample(int iSample) {
            return String.format("Filter %d Range %d: Sample#%d %d filterd (Prev1 %f Prev2 %f) => %f ranged => %f. Encoded %d shifted => %d decoded => %f%s", this.iFilter, this.iRange, iSample, this.asiSourcePcmSamples[iSample], this.adblPrev1Samples[iSample], this.adblPrev2Samples[iSample], this.adblFilteredSamples[iSample], this.adblRangedSamples[iSample], this.abEncodedAdpcmSamples[iSample], this.asiShortTopSamples[iSample], this.adblDecodedSamples[iSample], this.ablnSampleClamped[iSample] ? " FAILED" : "");
        }
    }

    private class FilterRangeEncoder {
        private final int _iFilterIndex;
        private final int _iRange;
        @Nonnull
        private final AdpcmEncodingContext _contextSnapshot;
        private final byte[] _abEncodedAdpcm = new byte[28];
        private boolean _blnHadToClamp = false;
        private double _dblMaxDelta = 0.0;

        private FilterRangeEncoder(int iFilterIndex, @Nonnull int iRange, AdpcmEncodingContext contextSnapshot) {
            this._iFilterIndex = iFilterIndex;
            this._iRange = iRange;
            this._contextSnapshot = contextSnapshot;
        }

        public boolean isBetterThan(@Nonnull FilterRangeEncoder other) {
            return this._dblMaxDelta < other._dblMaxDelta;
        }

        @Nonnull
        public AdpcmEncodingContext getDecodedContext() {
            return this._contextSnapshot;
        }

        @Nonnull
        public EncodedUnit makeEncodedUnit() {
            return new EncodedUnit(this._iFilterIndex, this._iRange, this._blnHadToClamp, this._abEncodedAdpcm);
        }

        private boolean encode(@Nonnull short[] asiPcmSoundUnitSamples, @Nonnull IContextCopier loggingContext) {
            Telemetry telemetry = TELEMETRY_LISTENER == null ? null : new Telemetry(loggingContext, this._iFilterIndex, this._iRange);
            for (int i = 0; i < 28; ++i) {
                byte bEncoded;
                short siPcmSample = asiPcmSoundUnitSamples[i];
                double dblFiltered = (double)siPcmSample - SoundUnitEncoder.this._filters.getK0(this._iFilterIndex) * this._contextSnapshot.dblPrev1 - SoundUnitEncoder.this._filters.getK1(this._iFilterIndex) * this._contextSnapshot.dblPrev2;
                int iBitsToShift = this._iRange - (16 - SoundUnitEncoder.this._iAdpcmBitsPerSample);
                double dblRaned = iBitsToShift < 0 ? dblFiltered / (double)(1 << -iBitsToShift) : (iBitsToShift > 0 ? dblFiltered * (double)(1 << iBitsToShift) : dblFiltered);
                long lngRanged = Math.round(dblRaned);
                if (lngRanged < (long)SoundUnitEncoder.this._iEncodeMin || lngRanged > (long)SoundUnitEncoder.this._iEncodeMax) {
                    if (lngRanged < (long)SoundUnitEncoder.this._iEncodeMin) {
                        lngRanged = SoundUnitEncoder.this._iEncodeMin;
                    } else if (lngRanged > (long)SoundUnitEncoder.this._iEncodeMax) {
                        lngRanged = SoundUnitEncoder.this._iEncodeMax;
                    }
                    if (telemetry != null) {
                        telemetry.sFailure = "Sample#" + i + "=" + lngRanged + " won't fit between " + SoundUnitEncoder.this._iEncodeMin + " and " + SoundUnitEncoder.this._iEncodeMax;
                    }
                    this._blnHadToClamp = true;
                }
                this._abEncodedAdpcm[i] = bEncoded = (byte)lngRanged;
                short siAdpcmShortTopSample = (short)(bEncoded << 16 - SoundUnitEncoder.this._iAdpcmBitsPerSample);
                int iUnRanged = siAdpcmShortTopSample >> this._iRange;
                double dblDecodedPcm = (double)iUnRanged + SoundUnitEncoder.this._filters.getK0(this._iFilterIndex) * this._contextSnapshot.dblPrev1 + SoundUnitEncoder.this._filters.getK1(this._iFilterIndex) * this._contextSnapshot.dblPrev2;
                this._contextSnapshot.update(dblDecodedPcm);
                double dblDelta = Math.abs(dblDecodedPcm - (double)siPcmSample);
                if (dblDelta > this._dblMaxDelta) {
                    this._dblMaxDelta = dblDelta;
                }
                if (telemetry == null) continue;
                telemetry.ablnSampleClamped[i] = this._blnHadToClamp;
                telemetry.asiSourcePcmSamples[i] = siPcmSample;
                telemetry.adblPrev1Samples[i] = this._contextSnapshot.dblPrev1;
                telemetry.adblPrev2Samples[i] = this._contextSnapshot.dblPrev2;
                telemetry.adblFilteredSamples[i] = dblFiltered;
                telemetry.adblRangedSamples[i] = dblRaned;
                telemetry.abEncodedAdpcmSamples[i] = bEncoded;
                telemetry.asiShortTopSamples[i] = siAdpcmShortTopSample;
                telemetry.adblDecodedSamples[i] = dblDecodedPcm;
            }
            if (telemetry != null) {
                telemetry.dblMaxDelta = this._dblMaxDelta;
                TELEMETRY_LISTENER.soundUnitEncoded(telemetry);
            }
            return this._blnHadToClamp;
        }
    }

    private static class AdpcmEncodingContext {
        public double dblPrev1 = 0.0;
        public double dblPrev2 = 0.0;

        private AdpcmEncodingContext() {
        }

        public void update(double dblNewSample) {
            this.dblPrev2 = this.dblPrev1;
            this.dblPrev1 = dblNewSample;
        }

        public void update(@Nonnull AdpcmEncodingContext other) {
            this.dblPrev1 = other.dblPrev1;
            this.dblPrev2 = other.dblPrev2;
        }

        @Nonnull
        public AdpcmEncodingContext copy() {
            AdpcmEncodingContext c = new AdpcmEncodingContext();
            c.update(this);
            return c;
        }
    }

    public static class EncodedUnit {
        public final int iFilterIndex;
        public final int iRange;
        public final boolean blnHadToClamp;
        @Nonnull
        public final byte[] abEncodedAdpcm;

        private EncodedUnit(int iFilterIndex, int iRange, boolean blnHadToClamp, @Nonnull byte[] abEncodedAdpcm) {
            this.iFilterIndex = iFilterIndex;
            this.iRange = iRange;
            this.blnHadToClamp = blnHadToClamp;
            this.abEncodedAdpcm = abEncodedAdpcm;
        }

        public byte getSoundParameter() {
            return (byte)((this.iFilterIndex & 0xF) << 4 | this.iRange & 0xF);
        }
    }
}

