/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.adpcm.AdpcmContext;
import jpsxdec.adpcm.IAdpcmSoundUnit;
import jpsxdec.adpcm.IContextCopier;
import jpsxdec.adpcm.K0K1Filter;

public class SoundUnitDecoder {
    @CheckForNull
    public static TelemetryListener TELEMETRY_LISTENER = null;
    public static final int SAMPLES_PER_SOUND_UNIT = 28;
    @Nonnull
    private final K0K1Filter _filterTable;

    public SoundUnitDecoder(@Nonnull K0K1Filter filterTable) {
        this._filterTable = filterTable;
    }

    void decodeSoundUnit(@Nonnull AdpcmContext context, @Nonnull IAdpcmSoundUnit su, @Nonnull short[] asiPcmOutBuffer, @Nonnull IContextCopier loggingContext) {
        Telemetry telemetry = null;
        int iFilterIndex = su.getUncorruptedFilterIndex();
        int iRange = su.getRange();
        if (TELEMETRY_LISTENER != null) {
            telemetry = new Telemetry(loggingContext, iFilterIndex, iRange);
        }
        for (int i = 0; i < 28; ++i) {
            short siPcmSample;
            short siAdpcmShortTopSample = su.getShiftedAdpcmSample(i);
            int iUnRanged = siAdpcmShortTopSample >> iRange;
            double dblDecodedPcm = (double)iUnRanged + this._filterTable.getK0(iFilterIndex) * context.getPreviousPCMSample1() + this._filterTable.getK1(iFilterIndex) * context.getPreviousPCMSample2();
            if (telemetry != null) {
                telemetry.asiSourceAdpcmSamples[i] = siAdpcmShortTopSample;
                telemetry.aiUnRangedSamples[i] = iUnRanged;
                telemetry.adblPrev1Samples[i] = context.getPreviousPCMSample1();
                telemetry.adblPrev2Samples[i] = context.getPreviousPCMSample2();
                telemetry.adblDecodedPcmSamples[i] = dblDecodedPcm;
            }
            asiPcmOutBuffer[i] = siPcmSample = context.saveScaleRoundClampPCMSample(dblDecodedPcm);
        }
        if (telemetry != null && TELEMETRY_LISTENER != null) {
            TELEMETRY_LISTENER.soundUnitDecoded(telemetry);
        }
    }

    public static interface TelemetryListener {
        public void soundUnitDecoded(@Nonnull Telemetry var1);
    }

    public static class Telemetry {
        @Nonnull
        private final IContextCopier _loggingContext;
        public final int iFilter;
        public final int iRange;
        public final short[] asiSourceAdpcmSamples;
        public final double[] adblPrev1Samples;
        public final double[] adblPrev2Samples;
        public final int[] aiUnRangedSamples;
        public final double[] adblDecodedPcmSamples;

        private Telemetry(@Nonnull IContextCopier loggingContext, int _iFilter, int _iRange) {
            this._loggingContext = loggingContext;
            this.iFilter = _iFilter;
            this.iRange = _iRange;
            this.asiSourceAdpcmSamples = new short[28];
            this.adblPrev1Samples = new double[28];
            this.adblPrev2Samples = new double[28];
            this.aiUnRangedSamples = new int[28];
            this.adblDecodedPcmSamples = new double[28];
        }

        @Nonnull
        public Object getLoggingContextCopy() {
            return this._loggingContext.copy();
        }

        public String sample(int iSample) {
            return String.format("Filter %d Range %d: Sample#%d %d unranged => %d filtered (Prev1 %f Prev2 %f) => %f", this.iFilter, this.iRange, iSample, this.asiSourceAdpcmSamples[iSample], this.aiUnRangedSamples[iSample], this.adblPrev1Samples[iSample], this.adblPrev2Samples[iSample], this.adblDecodedPcmSamples[iSample]);
        }

        public String toString() {
            return String.format("%s Filter.Range %d.%d", this._loggingContext, this.iFilter, this.iRange);
        }
    }
}

