/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import javax.annotation.Nonnull;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

public class PSoundPpl
extends AbstractList<Entry> {
    private static final String PSND = "PSnd";
    private final int _iVersion;
    @Nonnull
    private final Entry[] _aoEntries;

    public PSoundPpl(@Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
        byte[] abPsnd = IO.readByteArray(is, 4);
        String sPsnd = Misc.asciiToString(abPsnd);
        if (!PSND.equals(sPsnd)) {
            throw new BinaryDataNotRecognized();
        }
        this._iVersion = IO.readSInt32LE(is);
        if (this._iVersion != 1) {
            throw new BinaryDataNotRecognized();
        }
        int iEntryCount = IO.readSInt32LE(is);
        if (iEntryCount < 1) {
            throw new BinaryDataNotRecognized();
        }
        this._aoEntries = new Entry[iEntryCount];
        for (int i = 0; i < this._aoEntries.length; ++i) {
            this._aoEntries[i] = new Entry(is, i);
        }
    }

    @Override
    @Nonnull
    public Entry get(int index) {
        return this._aoEntries[index];
    }

    @Override
    public int size() {
        return this._aoEntries.length;
    }

    @Override
    public String toString() {
        return "Version " + this._iVersion + ", " + this._aoEntries.length + " entries";
    }

    public static class Entry {
        @Nonnull
        private final String _sItemName;
        @Nonnull
        private final String _sSourceFilePath;
        private final long _lngEncryptedOffset;
        private final byte[] _abUnknown5Bytes = new byte[5];
        private long _lngDecryptedOffset;
        private static final int ITEM_NAME_BUFFER_SIZE = 256;
        private static final int FILE_NAME_BUFFER_SIZE = 260;

        private Entry(@Nonnull InputStream is, int iIndex) throws EOFException, IOException, BinaryDataNotRecognized {
            byte[] abItemNameAndFileName = new byte[516];
            int iItemNameLength = IO.readUInt8(is);
            if (iItemNameLength == 0) {
                throw new BinaryDataNotRecognized();
            }
            IO.readByteArray(is, abItemNameAndFileName, 0, iItemNameLength);
            abItemNameAndFileName[iItemNameLength] = 0;
            int iFileNameLength = IO.readUInt8(is);
            if (iFileNameLength == 0) {
                throw new BinaryDataNotRecognized();
            }
            IO.readByteArray(is, abItemNameAndFileName, 256, iFileNameLength);
            abItemNameAndFileName[256 + iFileNameLength] = 0;
            this._sItemName = Misc.asciiToString(abItemNameAndFileName, 0, iItemNameLength);
            this._sSourceFilePath = Misc.asciiToString(abItemNameAndFileName, 256, iFileNameLength);
            this._lngEncryptedOffset = IO.readUInt32LE(is);
            IO.readByteArray(is, this._abUnknown5Bytes);
            int bitsToRotate = iItemNameLength + iFileNameLength;
            int eax = iFileNameLength;
            int temp = eax = IO.readSInt32LE(abItemNameAndFileName, 256 + eax - 5);
            eax = (int)this._lngEncryptedOffset;
            eax ^= 0xFFFFFFFF;
            int cl = bitsToRotate & 0x1F;
            eax = eax >>> cl | eax << 32 - cl;
            int ecx = temp;
            eax ^= ecx;
            this._lngDecryptedOffset = (long)(eax -= iIndex) & 0xFFFFFFFFL;
        }

        @Nonnull
        public String getItemName() {
            return this._sItemName;
        }

        @Nonnull
        public String getSourceFilePath() {
            return this._sSourceFilePath;
        }

        public long getOffset() {
            return this._lngDecryptedOffset;
        }

        public String toString() {
            return String.format("\"%s\" \"%s\" %02x%02x%02x%02x%02x? %08x -> %d", this._sSourceFilePath, this._sItemName, this._abUnknown5Bytes[0], this._abUnknown5Bytes[1], this._abUnknown5Bytes[2], this._abUnknown5Bytes[3], this._abUnknown5Bytes[4], this._lngEncryptedOffset, this._lngDecryptedOffset);
        }
    }
}

