/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

public abstract class K0K1Filter {
    public static final K0K1Filter XA = new Xa();
    public static final K0K1Filter SPU = new Spu();

    public abstract int getCount();

    public abstract double getK0(int var1);

    public abstract double getK1(int var1);

    private static class Spu
    extends K0K1Filter {
        private static final double[] K0 = new double[]{0.0, 0.9375, 1.796875, 1.53125, 1.90625};
        private static final double[] K1 = new double[]{0.0, 0.0, -0.8125, -0.859375, -0.9375};

        private Spu() {
        }

        @Override
        public int getCount() {
            return 5;
        }

        @Override
        public double getK0(int iIndex) {
            return K0[iIndex];
        }

        @Override
        public double getK1(int iIndex) {
            return K1[iIndex];
        }
    }

    private static class Xa
    extends K0K1Filter {
        static final double[] SoundUnit_K0 = new double[]{0.0, 0.9375, 1.796875, 1.53125};
        static final double[] SoundUnit_K1 = new double[]{0.0, 0.0, -0.8125, -0.859375};

        private Xa() {
        }

        @Override
        public int getCount() {
            return 4;
        }

        @Override
        public double getK0(int iIndex) {
            return SoundUnit_K0[iIndex];
        }

        @Override
        public double getK1(int iIndex) {
            return SoundUnit_K1[iIndex];
        }
    }
}

