/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;

public class AudioShortReader
implements Closeable {
    @Nonnull
    private final AudioInputStream _sourceAudio;
    private long _lngSampleFramesRead = 0L;
    private boolean _blnIsEof = false;

    public AudioShortReader(@Nonnull AudioInputStream sourceAudio) throws IncompatibleException {
        AudioFormat fmt = sourceAudio.getFormat();
        int iChannels = fmt.getChannels();
        if (fmt.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            throw new IncompatibleException("Encoding must be PCM_SIGNED");
        }
        if (fmt.getSampleSizeInBits() != 16) {
            throw new IncompatibleException("Bit size must be 16 " + fmt.getSampleRate());
        }
        if (iChannels < 1 || iChannels > 2) {
            throw new IncompatibleException("Channels must be 1 or 2");
        }
        this._sourceAudio = sourceAudio;
    }

    public boolean isEof() {
        return this._blnIsEof;
    }

    @Override
    public void close() throws IOException {
        this._sourceAudio.close();
    }

    public long getSampleFramesRead() {
        return this._lngSampleFramesRead;
    }

    @Nonnull
    public short[][] readSoundUnitSamples(int iSampleFrameCount) throws IOException {
        int iRead;
        int iChannels = this._sourceAudio.getFormat().getChannels();
        byte[] abReadPcmSoundUnitSamples = new byte[iSampleFrameCount * 2 * iChannels];
        short[][] aasiPcmSoundUnitChannelSamples = new short[iChannels][iSampleFrameCount];
        int iStart = 0;
        for (int iLen = abReadPcmSoundUnitSamples.length; iLen > 0; iLen -= iRead) {
            iRead = this._sourceAudio.read(abReadPcmSoundUnitSamples, iStart, iLen);
            if (iRead < 0) {
                this._blnIsEof = true;
                break;
            }
            this._lngSampleFramesRead += (long)iRead;
        }
        boolean blnIsBigEndian = this._sourceAudio.getFormat().isBigEndian();
        int iInByte = 0;
        int iOutSample = 0;
        while (iInByte < abReadPcmSoundUnitSamples.length) {
            int iChannel = 0;
            while (iChannel < iChannels) {
                aasiPcmSoundUnitChannelSamples[iChannel][iOutSample] = blnIsBigEndian ? IO.readSInt16BE(abReadPcmSoundUnitSamples, iInByte) : IO.readSInt16LE(abReadPcmSoundUnitSamples, iInByte);
                ++iChannel;
                iInByte += 2;
            }
            ++iOutSample;
        }
        return aasiPcmSoundUnitChannelSamples;
    }
}

