/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.adpcm;

import jpsxdec.util.Maths;

public class AdpcmContext {
    private final double _dblVolumeScale;
    private double _dblPreviousPCMSample1 = 0.0;
    private double _dblPreviousPCMSample2 = 0.0;

    public AdpcmContext(double dblVolumeScale) {
        this._dblVolumeScale = dblVolumeScale;
    }

    public AdpcmContext() {
        this(1.0);
    }

    public double getVolumeScale() {
        return this._dblVolumeScale;
    }

    public short saveScaleRoundClampPCMSample(double dblPCMSample) {
        this._dblPreviousPCMSample2 = this._dblPreviousPCMSample1;
        this._dblPreviousPCMSample1 = dblPCMSample;
        long lngSample = Maths.round(dblPCMSample * this._dblVolumeScale);
        return this.clampPCM(lngSample);
    }

    private short clampPCM(long lngPCMSample) {
        if (lngPCMSample > 32767L) {
            return Short.MAX_VALUE;
        }
        if (lngPCMSample < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)lngPCMSample;
    }

    public double getPreviousPCMSample1() {
        return this._dblPreviousPCMSample1;
    }

    public double getPreviousPCMSample2() {
        return this._dblPreviousPCMSample2;
    }
}

