/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec;

import java.awt.EventQueue;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.cmdline.CommandLine;
import jpsxdec.gui.Gui;
import jpsxdec.util.ArgParser;
import jpsxdec.util.IO;

public class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadLoggerConfigFromSystemProperty() {
        FileInputStream fis;
        String sLogConfigFile = System.getProperty("java.util.logging.config.file");
        if (sLogConfigFile == null) {
            return false;
        }
        try {
            fis = new FileInputStream(sLogConfigFile);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return false;
        }
        boolean blnSuccess = false;
        try {
            LogManager.getLogManager().readConfiguration(fis);
            blnSuccess = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            blnSuccess = false;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
                blnSuccess = false;
            }
        }
        return blnSuccess;
    }

    public static void loadDefaultLogger() {
        Main.loadLoggerConfigResource(Main.class, "LogToFile.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLoggerConfigResource(@Nonnull Class<?> referenceClass, @Nonnull String sLogFileResource) {
        InputStream is = referenceClass.getResourceAsStream(sLogFileResource);
        if (is != null) {
            try {
                LogManager.getLogManager().readConfiguration(is);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
            finally {
                IO.closeSilently(is, LOG);
            }
        }
    }

    public static void main(final String[] asArgs) {
        if (!Main.loadLoggerConfigFromSystemProperty()) {
            Main.loadDefaultLogger();
        }
        ArgParser ap = new ArgParser(asArgs);
        boolean blnShowGui = false;
        if (asArgs.length == 0) {
            blnShowGui = true;
        } else if (asArgs.length == 1) {
            boolean bl = blnShowGui = !ap.hasHelp();
        }
        if (blnShowGui) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Gui gui = new Gui();
                    if (asArgs.length > 0) {
                        gui.setCommandLineFile(asArgs[0]);
                    }
                    gui.setVisible(true);
                }
            });
        } else {
            System.exit(CommandLine.main(ap));
        }
    }
}

