/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Box;
import com.pdfjet.Font;
import com.pdfjet.Page;

public class TextLine {
    protected double x = 0.0;
    protected double y = 0.0;
    protected Font font = null;
    protected String str = "";
    protected String uri = null;
    protected boolean underline = false;
    protected boolean strike = false;
    protected int degrees = 0;
    protected double[] color = new double[]{0.0, 0.0, 0.0};
    private double box_x = 0.0;
    private double box_y = 0.0;

    public TextLine(Font font) {
        this.font = font;
    }

    public TextLine(Font font, String str) {
        this.font = font;
        this.str = str;
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setText(String str) {
        this.str = str;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setColor(double[] color) {
        this.color = color;
    }

    public void setColor(int[] rgb) {
        this.color = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
    }

    public String getText() {
        return this.str;
    }

    public double[] getColor() {
        return this.color;
    }

    public void setURIAction(String uri) {
        this.uri = uri;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public void setStrikeLine(boolean strike) {
        this.strike = strike;
    }

    public void setTextDirection(int degrees) {
        this.degrees = degrees;
    }

    public void placeIn(Box box) {
        this.box_x = box.x;
        this.box_y = box.y;
    }

    public void drawOn(Page page) throws Exception {
        this.drawOn(page, true);
    }

    public void drawOn(Page page, boolean draw) throws Exception {
        double y2;
        double x2;
        double y_adjust;
        double x_adjust;
        double radians;
        double lineLength;
        if (!draw) {
            return;
        }
        page.setTextDirection(this.degrees);
        this.x += this.box_x;
        this.y += this.box_y;
        if (this.uri != null) {
            page.annots.add(new Annotation(this.uri, this.x, page.height - (this.y - this.font.ascent), this.x + this.font.stringWidth(this.str), page.height - (this.y - this.font.descent)));
        }
        if (this.str != null) {
            page.setBrushColor(this.color[0], this.color[1], this.color[2]);
            page.drawString(this.font, this.str, this.x, this.y);
        }
        if (this.underline) {
            page.setPenWidth(this.font.underlineThickness);
            page.setPenColor(this.color[0], this.color[1], this.color[2]);
            lineLength = this.font.stringWidth(this.str);
            radians = Math.PI * (double)this.degrees / 180.0;
            x_adjust = this.font.underlinePosition * Math.sin(radians);
            y_adjust = this.font.underlinePosition * Math.cos(radians);
            x2 = this.x + lineLength * Math.cos(radians);
            y2 = this.y - lineLength * Math.sin(radians);
            page.moveTo(this.x + x_adjust, this.y + y_adjust);
            page.lineTo(x2 + x_adjust, y2 + y_adjust);
            page.strokePath();
        }
        if (this.strike) {
            page.setPenWidth(this.font.underlineThickness);
            page.setPenColor(this.color[0], this.color[1], this.color[2]);
            lineLength = this.font.stringWidth(this.str);
            radians = Math.PI * (double)this.degrees / 180.0;
            x_adjust = this.font.body_height / 4.0 * Math.sin(radians);
            y_adjust = this.font.body_height / 4.0 * Math.cos(radians);
            x2 = this.x + lineLength * Math.cos(radians);
            y2 = this.y - lineLength * Math.sin(radians);
            page.moveTo(this.x - x_adjust, this.y - y_adjust);
            page.lineTo(x2 - x_adjust, y2 - y_adjust);
            page.strokePath();
        }
        page.setTextDirection(0);
    }
}

