/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Cell;
import com.pdfjet.Font;
import com.pdfjet.Page;
import com.pdfjet.Point;
import com.pdfjet.RGB;
import java.util.ArrayList;
import java.util.List;

public class Table {
    public static int DATA_HAS_0_HEADER_ROWS = 0;
    public static int DATA_HAS_1_HEADER_ROWS = 1;
    public static int DATA_HAS_2_HEADER_ROWS = 2;
    public static int DATA_HAS_3_HEADER_ROWS = 3;
    public static int DATA_HAS_4_HEADER_ROWS = 4;
    public static int DATA_HAS_5_HEADER_ROWS = 5;
    public static int DATA_HAS_6_HEADER_ROWS = 6;
    public static int DATA_HAS_7_HEADER_ROWS = 7;
    public static int DATA_HAS_8_HEADER_ROWS = 8;
    public static int DATA_HAS_9_HEADER_ROWS = 9;
    private int rendered = 0;
    private List<List<Cell>> tableData = null;
    private int numOfHeaderRows = 0;
    private double x1 = 0.0;
    private double y1 = 0.0;
    private double w1 = 50.0;
    private double h1 = 30.0;
    private double lineWidth = 0.2;
    private double[] lineColor = RGB.BLACK;
    private double margin = 1.0;
    private double bottom_margin = 30.0;
    private Font f1 = null;
    private Font f2 = null;
    private Exception e = null;

    public Table(Font f1, Font f2) {
        this.f1 = f1;
        this.f2 = f2;
        this.tableData = new ArrayList<List<Cell>>();
    }

    public void setPosition(double x, double y) {
        this.x1 = x;
        this.y1 = y;
    }

    public void setSize(double w, double h) {
        this.w1 = w;
        this.h1 = h;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setLineColor(double[] color) {
        this.lineColor = color;
    }

    public void setLineColor(int[] rgb) {
        this.lineColor = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
    }

    public void setCellPadding(double margin) {
        this.margin = margin;
    }

    public void setCellMargin(double margin) {
        this.margin = margin;
    }

    public void setBottomMargin(double bottom_margin) {
        this.bottom_margin = bottom_margin;
    }

    public void setData(List<List<Cell>> tableData) throws Exception {
        this.tableData = tableData;
        this.numOfHeaderRows = 0;
    }

    public void setData(List<List<Cell>> tableData, int numOfHeaderRows) throws Exception {
        this.tableData = tableData;
        this.numOfHeaderRows = numOfHeaderRows;
        this.rendered = numOfHeaderRows;
    }

    public void autoAdjustColumnWidths() {
        Cell cell;
        int j;
        List<Cell> row;
        int i;
        double[] max_col_widths = new double[this.tableData.get(0).size()];
        for (i = 0; i < this.tableData.size(); ++i) {
            row = this.tableData.get(i);
            for (j = 0; j < row.size(); ++j) {
                cell = row.get(j);
                if (cell.colspan > 1) continue;
                cell.width = cell.font.stringWidth(cell.text);
                if (max_col_widths[j] != 0.0 && !(cell.width > max_col_widths[j])) continue;
                max_col_widths[j] = cell.width;
            }
        }
        for (i = 0; i < this.tableData.size(); ++i) {
            row = this.tableData.get(i);
            for (j = 0; j < row.size(); ++j) {
                cell = row.get(j);
                cell.width = max_col_widths[j] != 0.0 ? max_col_widths[j] + 3.0 * this.margin : cell.font.body_height;
            }
        }
    }

    public void rightAlignNumbers() {
        for (int i = this.numOfHeaderRows; i < this.tableData.size(); ++i) {
            List<Cell> row = this.tableData.get(i);
            for (int j = 0; j < row.size(); ++j) {
                Cell cell = row.get(j);
                try {
                    Double.valueOf(cell.text.replace(",", ""));
                    cell.align = 2;
                    continue;
                }
                catch (Exception e) {
                    this.e = e;
                }
            }
        }
    }

    public void removeLineBetweenRows(int index1, int index2) {
        int i;
        List<Cell> row = this.tableData.get(index1);
        Cell cell = null;
        for (i = 0; i < row.size(); ++i) {
            cell = row.get(i);
            cell.border.bottom = false;
        }
        row = this.tableData.get(index2);
        for (i = 0; i < row.size(); ++i) {
            cell = row.get(i);
            cell.border.top = false;
        }
    }

    public void setTextAlignInColumn(int index, int alignment) throws Exception {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> row = this.tableData.get(i);
            if (index >= row.size()) continue;
            row.get((int)index).align = alignment;
        }
    }

    public void setTextColorInColumn(int index, double[] color) throws Exception {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> row = this.tableData.get(i);
            if (index >= row.size()) continue;
            row.get((int)index).brushColor = color;
        }
    }

    public void setTextColorInColumn(int index, int[] rgb) throws Exception {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> row = this.tableData.get(i);
            if (index >= row.size()) continue;
            row.get((int)index).brushColor = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
        }
    }

    public void setTextFontInColumn(int index, Font font, double size) throws Exception {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> row = this.tableData.get(i);
            if (index >= row.size()) continue;
            row.get((int)index).font = font;
            row.get((int)index).font.setSize(size);
        }
    }

    public void setTextColorInRow(int index, double[] color) throws Exception {
        List<Cell> row = this.tableData.get(index);
        for (int i = 0; i < row.size(); ++i) {
            row.get((int)i).brushColor = color;
        }
    }

    public void setTextColorInRow(int index, int[] rgb) throws Exception {
        List<Cell> row = this.tableData.get(index);
        for (int i = 0; i < row.size(); ++i) {
            row.get((int)i).brushColor = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
        }
    }

    public void setTextFontInRow(int index, Font font, double size) throws Exception {
        List<Cell> row = this.tableData.get(index);
        for (int i = 0; i < row.size(); ++i) {
            row.get((int)i).font = font;
            row.get((int)i).font.setSize(size);
        }
    }

    @Deprecated
    public void setWidthForColumn(int index, double width) throws Exception {
        this.setColumnWidth(index, width);
    }

    public void setColumnWidth(int index, double width) throws Exception {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> row = this.tableData.get(i);
            if (index >= row.size()) continue;
            row.get((int)index).width = width;
        }
    }

    @Deprecated
    public Cell getCellAtRowColumn(int row, int col) throws Exception {
        return this.getCellAt(row, col);
    }

    public Cell getCellAt(int row, int col) throws Exception {
        if (row >= 0) {
            return this.tableData.get(row).get(col);
        }
        return this.tableData.get(this.tableData.size() + row).get(col);
    }

    public List<Cell> getRow(int index) throws Exception {
        return this.tableData.get(index);
    }

    public List<Cell> getColumn(int index) throws Exception {
        ArrayList<Cell> column = new ArrayList<Cell>();
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> row = this.tableData.get(i);
            if (index >= row.size()) continue;
            column.add(row.get(index));
        }
        return column;
    }

    public int getNumberOfPages(Page page) throws Exception {
        int numOfPages = 1;
        int j = this.numOfHeaderRows;
        double cell_h = 0.0;
        block0: while (j != this.tableData.size()) {
            double y = this.y1;
            for (int i = 0; i < this.numOfHeaderRows; ++i) {
                Cell cell = this.tableData.get(i).get(0);
                cell_h = cell.font.body_height + 2.0 * this.margin;
                y += cell_h;
            }
            while (j < this.tableData.size()) {
                Cell cell = this.tableData.get(j).get(0);
                cell_h = cell.font.body_height + 2.0 * this.margin;
                if ((y += cell_h) + cell_h > page.height - this.bottom_margin) {
                    ++numOfPages;
                    continue block0;
                }
                ++j;
            }
        }
        return numOfPages;
    }

    public Point drawOn(Page page) throws Exception {
        int k;
        Cell cell;
        int j;
        List<Cell> dataRow;
        int i;
        double x = this.x1;
        double y = this.y1;
        double cell_w = 0.0;
        double cell_h = 0.0;
        page.setPenWidth(this.lineWidth);
        page.setPenColor(this.lineColor[0], this.lineColor[1], this.lineColor[2]);
        for (i = 0; i < this.numOfHeaderRows; ++i) {
            dataRow = this.tableData.get(i);
            for (j = 0; j < dataRow.size(); ++j) {
                cell = dataRow.get(j);
                cell_h = cell.font.body_height + 2.0 * this.margin;
                cell_w = cell.width;
                for (k = 1; k < cell.colspan; ++k) {
                    cell_w += dataRow.get((int)(++j)).width;
                }
                page.setBrushColor(cell.brushColor[0], cell.brushColor[1], cell.brushColor[2]);
                cell.paint(page, x, y, cell_w, cell_h, this.margin);
                x += cell_w;
            }
            x = this.x1;
            y += cell_h;
        }
        for (i = this.rendered; i < this.tableData.size(); ++i) {
            dataRow = this.tableData.get(i);
            for (j = 0; j < dataRow.size(); ++j) {
                cell = dataRow.get(j);
                cell_h = cell.font.body_height + 2.0 * this.margin;
                cell_w = cell.width;
                for (k = 1; k < cell.colspan; ++k) {
                    cell_w += dataRow.get((int)(++j)).width;
                }
                page.setBrushColor(cell.brushColor[0], cell.brushColor[1], cell.brushColor[2]);
                cell.paint(page, x, y, cell_w, cell_h, this.margin);
                x += cell_w;
            }
            x = this.x1;
            if (!((y += cell_h) + cell_h > page.height - this.bottom_margin)) continue;
            this.rendered = i == this.tableData.size() - 1 ? -1 : i + 1;
            return new Point(x, y);
        }
        this.rendered = -1;
        return new Point(x, y);
    }

    public boolean hasMoreData() {
        return this.rendered != -1;
    }

    public double getWidth() {
        double table_width = 0.0;
        List<Cell> row = this.tableData.get(0);
        for (int i = 0; i < row.size(); ++i) {
            table_width += row.get((int)i).width;
        }
        return table_width;
    }

    @Deprecated
    public double getHeight() {
        double table_height = 0.0;
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> row = this.tableData.get(i);
            table_height += row.get((int)0).height;
        }
        return table_height;
    }

    public int getRowsRendered() {
        return this.rendered == -1 ? this.rendered : this.rendered - this.numOfHeaderRows;
    }
}

