/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Box;
import com.pdfjet.Page;
import java.util.List;

public class Point {
    public static final int INVISIBLE = -1;
    public static final int CIRCLE = 0;
    public static final int DIAMOND = 1;
    public static final int BOX = 2;
    public static final int PLUS = 3;
    public static final int H_DASH = 4;
    public static final int V_DASH = 5;
    public static final int MULTIPLY = 6;
    public static final int STAR = 7;
    public static final int X_MARK = 8;
    public static final int UP_ARROW = 9;
    public static final int DOWN_ARROW = 10;
    public static final int LEFT_ARROW = 11;
    public static final int RIGHT_ARROW = 12;
    public static final boolean IS_CURVE_POINT = true;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double r = 2.0;
    protected int shape = 0;
    protected double[] color = new double[]{0.0, 0.0, 0.0};
    protected double line_width = 0.3;
    protected String line_pattern = "[] 0";
    protected boolean fill_shape = false;
    protected boolean isCurvePoint = false;
    protected String text = null;
    protected String uri = null;
    protected List<String> info = null;
    protected boolean drawLineTo = false;
    private double box_x = 0.0;
    private double box_y = 0.0;

    public Point() {
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point(double x, double y, boolean isCurvePoint) {
        this.x = x;
        this.y = y;
        this.isCurvePoint = isCurvePoint;
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public void setRadius(double r) {
        this.r = r;
    }

    public double getRadius() {
        return this.r;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public int getShape() {
        return this.shape;
    }

    public void setFillShape(boolean fill) {
        this.fill_shape = fill;
    }

    public boolean getFillShape() {
        return this.fill_shape;
    }

    public void setColor(double[] color) {
        this.color = color;
    }

    public void setColor(int[] rgb) {
        this.color = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
    }

    public double[] getColor() {
        return this.color;
    }

    public void setLineWidth(double line_width) {
        this.line_width = line_width;
    }

    public double getLineWidth() {
        return this.line_width;
    }

    public void setLinePattern(String line_pattern) {
        this.line_pattern = line_pattern;
    }

    public String getLinePattern() {
        return this.line_pattern;
    }

    public void setDrawLineTo(boolean drawLineTo) {
        this.drawLineTo = drawLineTo;
    }

    public boolean getDrawLineTo() {
        return this.drawLineTo;
    }

    public void setURIAction(String uri) {
        this.uri = uri;
    }

    public String getURIAction() {
        return this.uri;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setInfo(List<String> info) {
        this.info = info;
    }

    public List<String> getInfo() {
        return this.info;
    }

    public void placeIn(Box box, double x_offset, double y_offset) throws Exception {
        this.box_x = box.x + x_offset;
        this.box_y = box.y + y_offset;
    }

    public void drawOn(Page page) throws Exception {
        page.setPenWidth(this.line_width);
        page.setLinePattern(this.line_pattern);
        if (this.fill_shape) {
            page.setBrushColor(this.color[0], this.color[1], this.color[2]);
        } else {
            page.setPenColor(this.color[0], this.color[1], this.color[2]);
        }
        this.x += this.box_x;
        this.y += this.box_y;
        page.drawPoint(this);
        this.x -= this.box_x;
        this.y -= this.box_y;
    }
}

