/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Box;
import com.pdfjet.Page;
import com.pdfjet.Point;
import java.util.ArrayList;
import java.util.List;

public class Path {
    private double[] color = new double[]{0.0, 0.0, 0.0};
    private double width = 0.3;
    private String pattern = "[] 0";
    private boolean fill_shape = false;
    private boolean close_path = false;
    private List<Point> points = new ArrayList<Point>();
    private double box_x = 0.0;
    private double box_y = 0.0;

    public void add(Point point) {
        this.points.add(point);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setColor(double[] color) {
        this.color = color;
    }

    public void setColor(int[] rgb) {
        this.color = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, rgb[2] / 255};
    }

    public void setClosePath(boolean close_path) {
        this.close_path = close_path;
    }

    public void setFillShape(boolean fill_shape) {
        this.fill_shape = fill_shape;
    }

    public void placeIn(Box box, double x_offset, double y_offset) throws Exception {
        this.box_x = box.x + x_offset;
        this.box_y = box.y + y_offset;
    }

    public void scaleBy(double factor) throws Exception {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = this.points.get(i);
            point.x *= factor;
            point.y *= factor;
        }
    }

    public void drawOn(Page page) throws Exception {
        Point point;
        int i;
        if (this.fill_shape) {
            page.setBrushColor(this.color[0], this.color[1], this.color[2]);
        } else {
            page.setPenColor(this.color[0], this.color[1], this.color[2]);
        }
        page.setPenWidth(this.width);
        page.setLinePattern(this.pattern);
        for (i = 0; i < this.points.size(); ++i) {
            point = this.points.get(i);
            point.x += this.box_x;
            point.y += this.box_y;
        }
        if (this.fill_shape) {
            page.drawPath(this.points, 'f');
        } else if (this.close_path) {
            page.drawPath(this.points, 's');
        } else {
            page.drawPath(this.points, 'S');
        }
        for (i = 0; i < this.points.size(); ++i) {
            point = this.points.get(i);
            point.x -= this.box_x;
            point.y -= this.box_y;
        }
    }
}

