/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Font;
import com.pdfjet.PDF;
import com.pdfjet.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Page {
    protected ByteArrayOutputStream buf = null;
    protected String writingMode = "1 0 0 1 ";
    protected int renderingMode = 0;
    protected double width = 0.0;
    protected double height = 0.0;
    protected List<Annotation> annots = null;
    protected PDF pdf = null;
    private double[] pen_color = new double[]{0.0, 0.0, 0.0};
    private double[] brush_color = new double[]{0.0, 0.0, 0.0};
    private double pen_width = 0.0;
    private String line_pattern = "[] 0";

    public Page(PDF pdf, double[] pageSize) throws Exception {
        this.pdf = pdf;
        this.annots = new ArrayList<Annotation>();
        this.width = pageSize[0];
        this.height = pageSize[1];
        this.buf = new ByteArrayOutputStream(8192);
        pdf.pages.add(this);
    }

    protected void drawLine(double x1, double y1, double x2, double y2) throws IOException {
        this.moveTo(x1, y1);
        this.lineTo(x2, y2);
        this.strokePath();
    }

    protected void drawString(Font font, String str, double x, double y) throws IOException {
        this.append("BT\n");
        this.append("/F");
        this.append(font.objNumber);
        this.append(' ');
        this.append(font.size);
        this.append(" Tf\n");
        if (this.renderingMode != 0) {
            this.append(this.renderingMode);
            this.append(" Tr\n");
        }
        this.append(this.writingMode);
        this.append(x);
        this.append(' ');
        this.append(this.height - y);
        this.append(" Tm\n");
        this.append("[ (");
        block0: for (int i = 0; i < str.length(); ++i) {
            int c1 = str.charAt(i);
            if (font.isComposite) {
                if (c1 < font.firstChar || c1 > font.lastChar) {
                    this.append((byte)0);
                    this.append((byte)32);
                    continue;
                }
                byte hi = (byte)(c1 >> 8);
                byte lo = (byte)c1;
                if (hi == 40 || hi == 41 || hi == 92) {
                    this.append((byte)92);
                }
                this.append((byte)(c1 >> 8));
                if (lo == 40 || lo == 41 || lo == 92) {
                    this.append((byte)92);
                }
                this.append((byte)c1);
                continue;
            }
            if (c1 < font.firstChar || c1 > font.lastChar) {
                c1 = 32;
            }
            if (c1 == 40 || c1 == 41 || c1 == 92) {
                this.append((byte)92);
            }
            this.append((byte)c1);
            if (!font.isStandard || !font.kernPairs || font.name.startsWith("C") || font.name.startsWith("S") || font.name.startsWith("Z")) continue;
            if (i == str.length() - 1) break;
            c1 -= 32;
            int c2 = str.charAt(i + 1);
            if (c2 < font.firstChar || c2 > font.lastChar) {
                c2 = 32;
            }
            for (int j = 2; j < font.metrics[c1].length; j += 2) {
                if (font.metrics[c1][j] != c2) continue;
                this.append(") ");
                this.append(-font.metrics[c1][j + 1]);
                this.append(" (");
                continue block0;
            }
        }
        this.append(") ] TJ\n");
        this.append("ET\n");
    }

    protected void setPenColor(double r, double g, double b) throws IOException {
        if (this.pen_color[0] == r && this.pen_color[1] == g && this.pen_color[2] == b) {
            return;
        }
        this.pen_color[0] = r;
        this.pen_color[1] = g;
        this.pen_color[2] = b;
        this.append(r);
        this.append(' ');
        this.append(g);
        this.append(' ');
        this.append(b);
        this.append(" RG\n");
    }

    protected void setBrushColor(double r, double g, double b) throws IOException {
        if (this.brush_color[0] == r && this.brush_color[1] == g && this.brush_color[2] == b) {
            return;
        }
        this.brush_color[0] = r;
        this.brush_color[1] = g;
        this.brush_color[2] = b;
        this.append(r);
        this.append(' ');
        this.append(g);
        this.append(' ');
        this.append(b);
        this.append(" rg\n");
    }

    protected void setDefaultLineWidth() throws IOException {
        this.append(0.0);
        this.append(" w\n");
    }

    protected void setLinePattern(String pattern) throws IOException {
        if (pattern.equals(this.line_pattern)) {
            return;
        }
        this.line_pattern = pattern;
        if (pattern.startsWith("[")) {
            this.append(pattern);
        } else {
            int dash = 0;
            int space = 0;
            for (int i = 0; i < pattern.length(); ++i) {
                if (pattern.charAt(i) == '-') {
                    ++dash;
                    continue;
                }
                ++space;
            }
            if (dash == 0 || space == 0) {
                this.append("[] 0");
            } else {
                this.append("[" + dash / 2 + " " + space / 2 + "] 0");
            }
        }
        this.append(" d\n");
    }

    protected void setDefaultLinePattern() throws IOException {
        this.append("[] 0");
        this.append(" d\n");
    }

    protected void setPenWidth(double width) throws IOException {
        if (this.pen_width == width) {
            return;
        }
        this.pen_width = width;
        this.append(this.pen_width);
        this.append(" w\n");
    }

    protected void moveTo(double x, double y) throws IOException {
        this.append(x);
        this.append(' ');
        this.append(this.height - y);
        this.append(" m\n");
    }

    protected void lineTo(double x, double y) throws IOException {
        this.append(x);
        this.append(' ');
        this.append(this.height - y);
        this.append(" l\n");
    }

    protected void closePath() throws IOException {
        this.append("h\n");
    }

    protected void strokePath() throws IOException {
        this.append("S\n");
    }

    protected void fillPath() throws IOException {
        this.append("f\n");
    }

    protected void drawPath(List<Point> list, char operand) throws Exception {
        if (list.size() < 2) {
            throw new Exception("The Path object must contain at least 2 points");
        }
        Point point = list.get(0);
        this.moveTo(point.x, point.y);
        int numOfCurvePoints = 0;
        for (int i = 1; i < list.size(); ++i) {
            point = list.get(i);
            if (point.isCurvePoint) {
                this.append(point.x);
                this.append(' ');
                this.append(this.height - point.y);
                if (numOfCurvePoints < 2) {
                    this.append(' ');
                    ++numOfCurvePoints;
                    continue;
                }
                this.append(" c\n");
                numOfCurvePoints = 0;
                continue;
            }
            this.lineTo(point.x, point.y);
        }
        if (numOfCurvePoints != 0) {
            throw new Exception("Invalid number of curve points in the Path object");
        }
        this.append(operand);
        this.append('\n');
    }

    protected void drawBezierCurve(List<Point> list, char operand) throws IOException {
        Point point = list.get(0);
        this.moveTo(point.x, point.y);
        for (int i = 1; i < list.size(); ++i) {
            point = list.get(i);
            this.append(point.x);
            this.append(' ');
            this.append(this.height - point.y);
            if (i % 3 == 0) {
                this.append(" c\n");
                continue;
            }
            this.append(' ');
        }
        this.append(operand);
        this.append('\n');
    }

    protected void drawCircle(double x, double y, double r, char operand) throws Exception {
        ArrayList<Point> list = new ArrayList<Point>();
        Point point = new Point();
        point.x = x;
        point.y = y - r;
        list.add(point);
        point = new Point();
        point.x = x + 0.55 * r;
        point.y = y - r;
        list.add(point);
        point = new Point();
        point.x = x + r;
        point.y = y - 0.55 * r;
        list.add(point);
        point = new Point();
        point.x = x + r;
        point.y = y;
        list.add(point);
        point = new Point();
        point.x = x + r;
        point.y = y + 0.55 * r;
        list.add(point);
        point = new Point();
        point.x = x + 0.55 * r;
        point.y = y + r;
        list.add(point);
        point = new Point();
        point.x = x;
        point.y = y + r;
        list.add(point);
        point = new Point();
        point.x = x - 0.55 * r;
        point.y = y + r;
        list.add(point);
        point = new Point();
        point.x = x - r;
        point.y = y + 0.55 * r;
        list.add(point);
        point = new Point();
        point.x = x - r;
        point.y = y;
        list.add(point);
        point = new Point();
        point.x = x - r;
        point.y = y - 0.55 * r;
        list.add(point);
        point = new Point();
        point.x = x - 0.55 * r;
        point.y = y - r;
        list.add(point);
        point = new Point();
        point.x = x;
        point.y = y - r;
        list.add(point);
        this.drawBezierCurve(list, operand);
    }

    protected void drawPoint(Point p) throws Exception {
        if (p.shape == -1) {
            return;
        }
        ArrayList<Point> list = null;
        Point point = null;
        if (p.shape == 0) {
            if (p.fill_shape) {
                this.drawCircle(p.x, p.y, p.r, 'f');
            } else {
                this.drawCircle(p.x, p.y, p.r, 'S');
            }
        } else if (p.shape == 1) {
            list = new ArrayList<Point>();
            point = new Point();
            point.x = p.x;
            point.y = p.y - p.r;
            list.add(point);
            point = new Point();
            point.x = p.x + p.r;
            point.y = p.y;
            list.add(point);
            point = new Point();
            point.x = p.x;
            point.y = p.y + p.r;
            list.add(point);
            point = new Point();
            point.x = p.x - p.r;
            point.y = p.y;
            list.add(point);
            if (p.fill_shape) {
                this.drawPath(list, 'f');
            } else {
                this.drawPath(list, 's');
            }
        } else if (p.shape == 2) {
            list = new ArrayList();
            point = new Point();
            point.x = p.x - p.r;
            point.y = p.y - p.r;
            list.add(point);
            point = new Point();
            point.x = p.x + p.r;
            point.y = p.y - p.r;
            list.add(point);
            point = new Point();
            point.x = p.x + p.r;
            point.y = p.y + p.r;
            list.add(point);
            point = new Point();
            point.x = p.x - p.r;
            point.y = p.y + p.r;
            list.add(point);
            if (p.fill_shape) {
                this.drawPath(list, 'f');
            } else {
                this.drawPath(list, 's');
            }
        } else if (p.shape == 3) {
            this.drawLine(p.x - p.r, p.y, p.x + p.r, p.y);
            this.drawLine(p.x, p.y - p.r, p.x, p.y + p.r);
        } else if (p.shape == 9) {
            list = new ArrayList();
            point = new Point();
            point.x = p.x;
            point.y = p.y - p.r;
            list.add(point);
            point = new Point();
            point.x = p.x + p.r;
            point.y = p.y + p.r;
            list.add(point);
            point = new Point();
            point.x = p.x - p.r;
            point.y = p.y + p.r;
            list.add(point);
            if (p.fill_shape) {
                this.drawPath(list, 'f');
            } else {
                this.drawPath(list, 's');
            }
        } else if (p.shape == 10) {
            list = new ArrayList();
            point = new Point();
            point.x = p.x - p.r;
            point.y = p.y - p.r;
            list.add(point);
            point = new Point();
            point.x = p.x + p.r;
            point.y = p.y - p.r;
            list.add(point);
            point = new Point();
            point.x = p.x;
            point.y = p.y + p.r;
            list.add(point);
            if (p.fill_shape) {
                this.drawPath(list, 'f');
            } else {
                this.drawPath(list, 's');
            }
        } else if (p.shape == 11) {
            list = new ArrayList();
            point = new Point();
            point.x = p.x + p.r;
            point.y = p.y + p.r;
            list.add(point);
            point = new Point();
            point.x = p.x - p.r;
            point.y = p.y;
            list.add(point);
            point = new Point();
            point.x = p.x + p.r;
            point.y = p.y - p.r;
            list.add(point);
            if (p.fill_shape) {
                this.drawPath(list, 'f');
            } else {
                this.drawPath(list, 's');
            }
        } else if (p.shape == 12) {
            list = new ArrayList();
            point = new Point();
            point.x = p.x - p.r;
            point.y = p.y - p.r;
            list.add(point);
            point = new Point();
            point.x = p.x + p.r;
            point.y = p.y;
            list.add(point);
            point = new Point();
            point.x = p.x - p.r;
            point.y = p.y + p.r;
            list.add(point);
            if (p.fill_shape) {
                this.drawPath(list, 'f');
            } else {
                this.drawPath(list, 's');
            }
        } else if (p.shape == 4) {
            this.drawLine(p.x - p.r, p.y, p.x + p.r, p.y);
        } else if (p.shape == 5) {
            this.drawLine(p.x, p.y - p.r, p.x, p.y + p.r);
        } else if (p.shape == 8) {
            this.drawLine(p.x - p.r, p.y - p.r, p.x + p.r, p.y + p.r);
            this.drawLine(p.x - p.r, p.y + p.r, p.x + p.r, p.y - p.r);
        } else if (p.shape == 6) {
            this.drawLine(p.x - p.r, p.y - p.r, p.x + p.r, p.y + p.r);
            this.drawLine(p.x - p.r, p.y + p.r, p.x + p.r, p.y - p.r);
            this.drawLine(p.x - p.r, p.y, p.x + p.r, p.y);
            this.drawLine(p.x, p.y - p.r, p.x, p.y + p.r);
        } else if (p.shape == 7) {
            double angle = 0.3141592653589793;
            double sin18 = Math.sin(angle);
            double cos18 = Math.cos(angle);
            double a = p.r * cos18;
            double b = p.r * sin18;
            double c = 2.0 * a * sin18;
            double d = 2.0 * a * cos18 - p.r;
            list = new ArrayList();
            point = new Point();
            point.x = p.x;
            point.y = p.y - p.r;
            list.add(point);
            point = new Point();
            point.x = p.x + c;
            point.y = p.y + d;
            list.add(point);
            point = new Point();
            point.x = p.x - a;
            point.y = p.y - b;
            list.add(point);
            point = new Point();
            point.x = p.x + a;
            point.y = p.y - b;
            list.add(point);
            point = new Point();
            point.x = p.x - c;
            point.y = p.y + d;
            list.add(point);
            if (p.fill_shape) {
                this.drawPath(list, 'f');
            } else {
                this.drawPath(list, 's');
            }
        }
    }

    protected void setTextRenderingMode(int mode) throws Exception {
        if (mode != 0 && mode != 1 && mode != 2 && mode != 3 && mode != 4 && mode != 5 && mode != 6 && mode != 7) {
            throw new Exception("Invalid text rendering mode: " + mode);
        }
        this.renderingMode = mode;
    }

    protected void setTextDirection(int degrees) throws Exception {
        if (degrees > 360) {
            degrees %= 360;
        }
        if (degrees == 0) {
            this.writingMode = "1 0 0 1 ";
        } else if (degrees == 90) {
            this.writingMode = "0 1 -1 0 ";
        } else if (degrees == 180) {
            this.writingMode = "-1 0 0 -1 ";
        } else if (degrees == 270) {
            this.writingMode = "0 -1 1 0 ";
        } else if (degrees == 360) {
            this.writingMode = "1 0 0 1 ";
        } else {
            double sinOfAngle = Math.sin((double)degrees * (Math.PI / 180));
            double cosOfAngle = Math.cos((double)degrees * (Math.PI / 180));
            StringBuilder sb = new StringBuilder();
            sb.append(cosOfAngle);
            sb.append(' ');
            sb.append(sinOfAngle);
            sb.append(' ');
            sb.append(-sinOfAngle);
            sb.append(' ');
            sb.append(cosOfAngle);
            sb.append(' ');
            this.writingMode = sb.toString().replace(',', '.');
        }
    }

    protected void append(String str) throws IOException {
        for (int i = 0; i < str.length(); ++i) {
            this.buf.write((byte)str.charAt(i));
        }
    }

    protected void append(int num) throws IOException {
        this.append(String.valueOf(num));
    }

    protected void append(double val) throws IOException {
        this.append(String.valueOf(val).replace(',', '.'));
    }

    protected void append(char ch) throws IOException {
        this.buf.write((byte)ch);
    }

    protected void append(byte b) throws IOException {
        this.buf.write(b);
    }
}

