/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Chunk;
import com.pdfjet.Compressor;
import com.pdfjet.Decompressor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class PNGImage {
    int w = 0;
    int h = 0;
    byte[] data;
    byte[] alpha;
    byte[] inflated;
    byte[] image;
    byte[] deflated;
    byte[] rgb;
    public byte bitDepth = (byte)8;
    public int colorType = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PNGImage(InputStream inputStream) throws Exception {
        this.validatePNG(inputStream);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        this.processPNG(chunks, inputStream);
        for (int i = 0; i < chunks.size(); ++i) {
            Chunk chunk = (Chunk)chunks.get(i);
            if (chunk.type[0] == 73 && chunk.type[1] == 72 && chunk.type[2] == 68 && chunk.type[3] == 82) {
                this.w = this.toIntValue(chunk.getData(), 0);
                this.h = this.toIntValue(chunk.getData(), 4);
                this.bitDepth = chunk.getData()[8];
                this.colorType = chunk.getData()[9];
                continue;
            }
            if (chunk.type[0] == 73 && chunk.type[1] == 68 && chunk.type[2] == 65 && chunk.type[3] == 84) {
                this.data = this.appendIdatChunk(this.data, chunk.getData());
                continue;
            }
            if (chunk.type[0] != 80 || chunk.type[1] != 76 || chunk.type[2] != 84 || chunk.type[3] != 69) continue;
            this.rgb = chunk.getData();
            if (this.rgb.length % 3 == 0) continue;
            throw new Exception("Incorrect palette length.");
        }
        this.inflated = this.getDecompressedData();
        if (this.colorType == 0) {
            if (this.bitDepth == 16) {
                this.image = this.getImageColorType0BitDepth16();
            } else if (this.bitDepth == 8) {
                this.image = this.getImageColorType0BitDepth8();
            } else if (this.bitDepth == 4) {
                this.image = this.getImageColorType0BitDepth4();
            } else if (this.bitDepth == 2) {
                this.image = this.getImageColorType0BitDepth2();
            } else {
                if (this.bitDepth != 1) throw new Exception("Image with unsupported bit depth == " + this.bitDepth);
                this.image = this.getImageColorType0BitDepth1();
            }
        } else if (this.colorType == 6) {
            this.image = this.getImageColorType6BitDepth8();
        } else if (this.rgb == null) {
            this.image = this.bitDepth == 16 ? this.getImageColorType2BitDepth16() : this.getImageColorType2BitDepth8();
        } else if (this.bitDepth == 8) {
            this.image = this.getImageColorType3BitDepth8();
        } else if (this.bitDepth == 4) {
            this.image = this.getImageColorType3BitDepth4();
        } else if (this.bitDepth == 2) {
            this.image = this.getImageColorType3BitDepth2();
        } else {
            if (this.bitDepth != 1) throw new Exception("Image with unsupported bit depth == " + this.bitDepth);
            this.image = this.getImageColorType3BitDepth1();
        }
        this.deflated = this.deflateReconstructedData();
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public byte[] getData() {
        return this.deflated;
    }

    private void processPNG(List<Chunk> chunks, InputStream inputStream) throws Exception {
        Chunk chunk;
        do {
            chunk = this.getChunk(inputStream);
            chunks.add(chunk);
        } while (chunk.type[0] != 73 || chunk.type[1] != 69 || chunk.type[2] != 78 || chunk.type[3] != 68);
    }

    private void validatePNG(InputStream inputStream) throws Exception {
        byte[] buf = new byte[8];
        if (inputStream.read(buf, 0, buf.length) == -1) {
            throw new Exception("File is too short!");
        }
        if ((buf[0] & 0xFF) != 137 || buf[1] != 80 || buf[2] != 78 || buf[3] != 71 || buf[4] != 13 || buf[5] != 10 || buf[6] != 26 || buf[7] != 10) {
            throw new Exception("Wrong PNG signature.");
        }
    }

    private Chunk getChunk(InputStream inputStream) throws Exception {
        Chunk chunk = new Chunk();
        chunk.setLength(this.getLong(inputStream));
        chunk.setType(this.getBytes(inputStream, 4L));
        chunk.setData(this.getBytes(inputStream, chunk.getLength()));
        chunk.setCrc(this.getLong(inputStream));
        if (!chunk.hasGoodCRC()) {
            throw new Exception("Chunk has bad CRC.");
        }
        return chunk;
    }

    private long getLong(InputStream inputStream) throws Exception {
        byte[] buf = this.getBytes(inputStream, 4L);
        return (long)this.toIntValue(buf, 0) & 0xFFFFFFFFL;
    }

    private byte[] getBytes(InputStream inputStream, long length) throws Exception {
        byte[] buf = new byte[(int)length];
        inputStream.read(buf, 0, buf.length);
        return buf;
    }

    private int toIntValue(byte[] buf, int off) {
        long val = 0L;
        val |= (long)buf[0 + off] & 0xFFL;
        val <<= 8;
        val |= (long)buf[1 + off] & 0xFFL;
        val <<= 8;
        val |= (long)buf[2 + off] & 0xFFL;
        val <<= 8;
        return (int)(val |= (long)buf[3 + off] & 0xFFL);
    }

    private byte[] getImageColorType2BitDepth16() {
        int j = 0;
        byte[] image = new byte[this.inflated.length - this.h];
        byte filter = 0;
        int scanLineLength = 6 * this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (scanLineLength + 1) == 0) {
                filter = this.inflated[i];
                continue;
            }
            image[j] = this.inflated[i];
            int a = 0;
            int b = 0;
            int c = 0;
            if (j % scanLineLength >= 6) {
                a = image[j - 6] & 0xFF;
            }
            if (j >= scanLineLength) {
                b = image[j - scanLineLength] & 0xFF;
            }
            if (j % scanLineLength >= 6 && j >= scanLineLength) {
                c = image[j - (scanLineLength + 6)] & 0xFF;
            }
            this.applyFilters(filter, image, j, a, b, c);
            ++j;
        }
        return image;
    }

    private byte[] getImageColorType2BitDepth8() {
        int j = 0;
        byte[] image = new byte[this.inflated.length - this.h];
        byte filter = 0;
        int scanLineLength = 3 * this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (scanLineLength + 1) == 0) {
                filter = this.inflated[i];
                continue;
            }
            image[j] = this.inflated[i];
            int a = 0;
            int b = 0;
            int c = 0;
            if (j % scanLineLength >= 3) {
                a = image[j - 3] & 0xFF;
            }
            if (j >= scanLineLength) {
                b = image[j - scanLineLength] & 0xFF;
            }
            if (j % scanLineLength >= 3 && j >= scanLineLength) {
                c = image[j - (scanLineLength + 3)] & 0xFF;
            }
            this.applyFilters(filter, image, j, a, b, c);
            ++j;
        }
        return image;
    }

    private byte[] getImageColorType6BitDepth8() {
        int j = 0;
        byte[] image = new byte[4 * this.w * this.h];
        byte filter = 0;
        int scanLineLength = 4 * this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (scanLineLength + 1) == 0) {
                filter = this.inflated[i];
                continue;
            }
            image[j] = this.inflated[i];
            int a = 0;
            int b = 0;
            int c = 0;
            if (j % scanLineLength >= 4) {
                a = image[j - 4] & 0xFF;
            }
            if (j >= scanLineLength) {
                b = image[j - scanLineLength] & 0xFF;
            }
            if (j % scanLineLength >= 4 && j >= scanLineLength) {
                c = image[j - (scanLineLength + 4)] & 0xFF;
            }
            this.applyFilters(filter, image, j, a, b, c);
            ++j;
        }
        byte[] idata = new byte[3 * this.w * this.h];
        this.alpha = new byte[this.w * this.h];
        int k = 0;
        int n = 0;
        for (int i = 0; i < image.length; i += 4) {
            idata[k] = image[i];
            idata[k + 1] = image[i + 1];
            idata[k + 2] = image[i + 2];
            this.alpha[n] = image[i + 3];
            k += 3;
            ++n;
        }
        return idata;
    }

    private byte[] getImageColorType3BitDepth8() {
        int j = 0;
        int k = 0;
        byte[] image = new byte[3 * (this.inflated.length - this.h)];
        int scanLineLength = this.w + 1;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % scanLineLength == 0) continue;
            k = 3 * (this.inflated[i] & 0xFF);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
        }
        return image;
    }

    private byte[] getImageColorType3BitDepth4() {
        int j = 0;
        int k = 0;
        byte[] image = new byte[6 * (this.inflated.length - this.h)];
        int scanLineLength = this.w / 2 + 1;
        if (this.w % 2 > 0) {
            ++scanLineLength;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % scanLineLength == 0) continue;
            byte l = this.inflated[i];
            k = 3 * (l >> 4 & 0xF);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 0 & 0xF);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
        }
        return image;
    }

    private byte[] getImageColorType3BitDepth2() {
        int j = 0;
        int k = 0;
        byte[] image = new byte[12 * (this.inflated.length - this.h)];
        int scanLineLength = this.w / 4 + 1;
        if (this.w % 4 > 0) {
            ++scanLineLength;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % scanLineLength == 0) continue;
            byte l = this.inflated[i];
            k = 3 * (l >> 6 & 3);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 4 & 3);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 2 & 3);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 0 & 3);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
        }
        return image;
    }

    private byte[] getImageColorType3BitDepth1() {
        int j = 0;
        int k = 0;
        byte[] image = new byte[24 * (this.inflated.length - this.h)];
        int scanLineLength = this.w / 8 + 1;
        if (this.w % 8 > 0) {
            ++scanLineLength;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % scanLineLength == 0) continue;
            byte l = this.inflated[i];
            k = 3 * (l >> 7 & 1);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 6 & 1);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 5 & 1);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 4 & 1);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 3 & 1);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 2 & 1);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 1 & 1);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
            if (j % (3 * this.w) == 0) continue;
            k = 3 * (l >> 0 & 1);
            image[j++] = this.rgb[k];
            image[j++] = this.rgb[k + 1];
            image[j++] = this.rgb[k + 2];
        }
        return image;
    }

    private byte[] getImageColorType0BitDepth16() {
        int j = 0;
        byte[] image = new byte[this.inflated.length - this.h];
        byte filter = 0;
        int scanLineLength = 2 * this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (scanLineLength + 1) == 0) {
                filter = this.inflated[i];
                continue;
            }
            image[j] = this.inflated[i];
            int a = 0;
            int b = 0;
            int c = 0;
            if (j % scanLineLength >= 2) {
                a = image[j - 2] & 0xFF;
            }
            if (j >= scanLineLength) {
                b = image[j - scanLineLength] & 0xFF;
            }
            if (j % scanLineLength >= 2 && j >= scanLineLength) {
                c = image[j - (scanLineLength + 2)] & 0xFF;
            }
            this.applyFilters(filter, image, j, a, b, c);
            ++j;
        }
        return image;
    }

    private byte[] getImageColorType0BitDepth8() {
        int j = 0;
        byte[] image = new byte[this.inflated.length - this.h];
        byte filter = 0;
        int scanLineLength = this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (scanLineLength + 1) == 0) {
                filter = this.inflated[i];
                continue;
            }
            image[j] = this.inflated[i];
            int a = 0;
            int b = 0;
            int c = 0;
            if (j % scanLineLength >= 1) {
                a = image[j - 1] & 0xFF;
            }
            if (j >= scanLineLength) {
                b = image[j - scanLineLength] & 0xFF;
            }
            if (j % scanLineLength >= 1 && j >= scanLineLength) {
                c = image[j - (scanLineLength + 1)] & 0xFF;
            }
            this.applyFilters(filter, image, j, a, b, c);
            ++j;
        }
        return image;
    }

    private byte[] getImageColorType0BitDepth4() {
        int j = 0;
        byte[] image = new byte[this.inflated.length - this.h];
        int scanLineLength = this.w / 2 + 1;
        if (this.w % 2 > 0) {
            ++scanLineLength;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % scanLineLength == 0) continue;
            image[j++] = this.inflated[i];
        }
        return image;
    }

    private byte[] getImageColorType0BitDepth2() {
        int j = 0;
        byte[] image = new byte[this.inflated.length - this.h];
        int scanLineLength = this.w / 4 + 1;
        if (this.w % 4 > 0) {
            ++scanLineLength;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % scanLineLength == 0) continue;
            image[j++] = this.inflated[i];
        }
        return image;
    }

    private byte[] getImageColorType0BitDepth1() {
        int j = 0;
        byte[] image = new byte[this.inflated.length - this.h];
        int scanLineLength = this.w / 8 + 1;
        if (this.w % 8 > 0) {
            ++scanLineLength;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % scanLineLength == 0) continue;
            image[j++] = this.inflated[i];
        }
        return image;
    }

    private void applyFilters(byte filter, byte[] image, int j, int a, int b, int c) {
        if (filter != 0) {
            if (filter == 1) {
                int n = j;
                image[n] = (byte)(image[n] + (byte)a);
            } else if (filter == 2) {
                int n = j;
                image[n] = (byte)(image[n] + (byte)b);
            } else if (filter == 3) {
                int n = j;
                image[n] = (byte)(image[n] + (byte)Math.floor((double)(a + b) / 2.0));
            } else if (filter == 4) {
                int pr = 0;
                int p = a + b - c;
                int pa = Math.abs(p - a);
                int pb = Math.abs(p - b);
                int pc = Math.abs(p - c);
                pr = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                int n = j;
                image[n] = (byte)(image[n] + (byte)(pr & 0xFF));
            }
        }
    }

    private byte[] getDecompressedData() throws Exception {
        Decompressor decompressor = new Decompressor(this.data);
        return decompressor.getDecompressedData();
    }

    private byte[] deflateReconstructedData() throws Exception {
        Compressor compressor = new Compressor(this.image);
        return compressor.getCompressedData();
    }

    private byte[] appendIdatChunk(byte[] array1, byte[] array2) {
        if (array1 == null) {
            return array2;
        }
        if (array2 == null) {
            return array1;
        }
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }
}

